/*
 * Decompiled with CFR 0.152.
 */
package sky.cmAutoSplitter;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import sky.cmAutoSplitter.CoxCMAutoSplitterConfig;
import sky.cmAutoSplitter.CoxCMAutoSplitterPanel;
import sky.cmAutoSplitter.CoxUtil;

@PluginDescriptor(name="CoX Auto splitter", description="Auto splitter for LiveSplit for cox cm")
public class CoxCMAutoSplitter
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private CoxCMAutoSplitterConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    PrintWriter writer;
    private NavigationButton navButton;
    private CoxCMAutoSplitterPanel panel;
    private static final int RAID_STATE_VARBIT = 5425;
    private int prevRaidState = -1;
    private boolean in_raid;
    private final int[] cryp = new int[16];
    private final int[] cryx = new int[16];
    private final int[] cryy = new int[16];
    private int olm_phase;
    private boolean iceout;
    private boolean treecut;
    private static final String FL_COMPLETE_MES = "level complete! Duration: </col><col=ff0000>";
    private static final int SMOKE_PUFF = 188;

    @Provides
    CoxCMAutoSplitterConfig provideConfig(ConfigManager configManager) {
        return (CoxCMAutoSplitterConfig)configManager.getConfig(CoxCMAutoSplitterConfig.class);
    }

    @Subscribe
    public void onClientTick(ClientTick e) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.clock() == 0 || !this.client.isInInstancedRegion()) {
            this.in_raid = false;
            return;
        }
        if (!this.in_raid) {
            this.in_raid = true;
            this.olm_phase = -1;
            this.iceout = false;
            this.treecut = false;
        }
        for (int i = 0; i < 16; ++i) {
            if (this.cryp[i] == -1) continue;
            int p = this.cryp[i];
            int x = this.cryx[i] - this.client.getBaseX();
            int y = this.cryy[i] - this.client.getBaseY();
            if (p != this.client.getPlane() || x < 0 || x >= 104 || y < 0 || y >= 104) {
                this.cryp[i] = -1;
                continue;
            }
            int flags = this.client.getCollisionMaps()[p].getFlags()[x][y];
            if ((flags & 0x100) != 0 || this.config.regular()) continue;
            this.send_split();
            this.cryp[i] = -1;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        String mes = e.getMessage();
        if (e.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION && mes.startsWith("<col=ef20ff>")) {
            boolean is_fl_time;
            int duration = mes.indexOf(FL_COMPLETE_MES);
            boolean bl = is_fl_time = duration != -1;
            if (!is_fl_time) {
                return;
            }
            this.send_split();
        } else if (e.getType() == ChatMessageType.GAMEMESSAGE && mes.equals("The Great Olm is giving its all. This is its final stand.")) {
            this.send_split();
            this.olm_phase = 99;
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        GameObject go = e.getGameObject();
        switch (go.getId()) {
            case 29881: {
                if (this.olm_phase >= 0) break;
                this.olm_phase ^= 0xFFFFFFFF;
                break;
            }
            case 30013: {
                if (!this.config.splitMuttadileTree() || this.treecut || this.config.regular()) break;
                this.send_split();
                this.treecut = true;
                break;
            }
            case 26209: 
            case 29741: 
            case 29749: 
            case 29753: 
            case 29754: 
            case 29755: 
            case 29756: 
            case 29757: 
            case 29876: 
            case 30016: 
            case 30017: 
            case 30018: 
            case 30070: {
                Point pt = go.getSceneMinLocation();
                int p = go.getPlane();
                int x = pt.getX();
                int y = pt.getY();
                int template = this.client.getInstanceTemplateChunks()[p][x / 8][y / 8];
                int roomtype = CoxUtil.getroom_type(template);
                if (roomtype >= 16) break;
                this.cryp[roomtype] = p;
                this.cryx[roomtype] = x + this.client.getBaseX();
                this.cryy[roomtype] = y + this.client.getBaseY();
            }
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned e) {
        if (e.getGameObject().getId() == 29881) {
            this.send_split();
            this.olm_phase ^= 0xFFFFFFFF;
        }
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated e) {
        if (this.config.splitIcePop() && e.getGraphicsObject().getId() == 188 && !this.iceout && !this.config.regular()) {
            WorldPoint wp = WorldPoint.fromLocal((Client)this.client, (LocalPoint)e.getGraphicsObject().getLocation());
            int p = this.client.getPlane();
            int x = wp.getX() - this.client.getBaseX();
            int y = wp.getY() - this.client.getBaseY();
            int template = this.client.getInstanceTemplateChunks()[p][x / 8][y / 8];
            if (CoxUtil.getroom_type(template) == 12) {
                this.send_split();
                this.iceout = true;
            }
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged e) {
        int raidState = this.client.getVarbitValue(5425);
        if (this.prevRaidState == 0 && raidState == 1) {
            if (this.config.autoReset()) {
                this.send_reset();
            }
            this.send_split();
        }
        this.prevRaidState = raidState;
    }

    private void send_split() {
        try {
            this.writer.write("startorsplit\r\n");
            this.writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void send_reset() {
        try {
            this.writer.write("reset\r\n");
            this.writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int clock() {
        return this.client.getVarbitValue(6386);
    }

    protected void startUp() {
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icon.png");
        this.panel = new CoxCMAutoSplitterPanel(this.client, this.writer, this.config, this);
        this.navButton = NavigationButton.builder().tooltip("LiveSplit controller").icon(icon).priority(6).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.panel.startPanel();
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
        this.panel.disconnect();
    }
}

