/*
 * Decompiled with CFR 0.152.
 */
package info.sigterm.plugins.largemodels;

import info.sigterm.plugins.largemodels.LargeModelsConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.Model;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Player;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

@Singleton
class LargeModelsOverlay
extends Overlay {
    private static final Font FONT = FontManager.getRunescapeFont().deriveFont(1, 16.0f);
    private static final Color GREEN = new Color(0, 200, 83);
    private static final Color ORANGE = new Color(255, 109, 0);
    private static final Color YELLOW = new Color(255, 214, 0);
    private static final Color PURPLE = new Color(170, 0, 255);
    private static final Color GRAY = new Color(158, 158, 158);
    private final Client client;
    private final LargeModelsConfig config;
    private int faceCount;

    @Inject
    private LargeModelsOverlay(Client client, LargeModelsConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPriority(OverlayPriority.HIGHEST);
        this.client = client;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        graphics.setFont(FONT);
        this.faceCount = this.config.numFaces();
        this.renderNpcs(graphics);
        this.renderTileObjects(graphics);
        return null;
    }

    private void renderNpcs(Graphics2D graphics) {
        List npcs = this.client.getNpcs();
        for (NPC npc : npcs) {
            Model m;
            Color color;
            NPCComposition composition = npc.getComposition();
            Color color2 = color = composition.getCombatLevel() > 1 ? YELLOW : ORANGE;
            if (composition.getConfigs() != null) {
                NPCComposition transformedComposition = composition.transform();
                if (transformedComposition == null) {
                    color = GRAY;
                } else {
                    composition = transformedComposition;
                }
            }
            if ((m = npc.getModel()) == null || m.getFaceCount() <= this.faceCount) continue;
            String text = composition.getName() + " " + m.getFaceCount();
            OverlayUtil.renderActorOverlay((Graphics2D)graphics, (Actor)npc, (String)text, (Color)color);
        }
    }

    private void renderTileObjects(Graphics2D graphics) {
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        int z = this.client.getPlane();
        boolean ground = this.config.groundObjects();
        boolean game = this.config.gameObjects();
        boolean walls = this.config.walls();
        boolean deco = this.config.decorations();
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                Player player;
                Tile tile = tiles[z][x][y];
                if (tile == null || (player = this.client.getLocalPlayer()) == null) continue;
                if (ground) {
                    this.renderGroundObject(graphics, tile.getGroundObject(), PURPLE);
                }
                if (game) {
                    this.renderGameObjects(graphics, tile);
                }
                if (walls) {
                    this.renderWallObject(graphics, tile.getWallObject(), GRAY);
                }
                if (!deco) continue;
                this.renderDecorObject(graphics, tile);
            }
        }
    }

    private void renderGameObjects(Graphics2D graphics, Tile tile) {
        GameObject[] gameObjects = tile.getGameObjects();
        if (gameObjects != null) {
            for (GameObject gameObject : gameObjects) {
                if (gameObject == null || !gameObject.getSceneMinLocation().equals((Object)tile.getSceneLocation())) continue;
                StringBuilder stringBuilder = new StringBuilder();
                Model m = LargeModelsOverlay.renderableToModel(gameObject.getRenderable());
                if (m == null || m.getFaceCount() <= this.faceCount) continue;
                stringBuilder.append(m.getFaceCount());
                OverlayUtil.renderTileOverlay((Graphics2D)graphics, (TileObject)gameObject, (String)stringBuilder.toString(), (Color)GREEN);
            }
        }
    }

    private void renderGroundObject(Graphics2D graphics, GroundObject groundObject, Color color) {
        Model m;
        if (groundObject != null && (m = LargeModelsOverlay.renderableToModel(groundObject.getRenderable())) != null && m.getFaceCount() > this.faceCount) {
            OverlayUtil.renderTileOverlay((Graphics2D)graphics, (TileObject)groundObject, (String)Integer.toString(m.getFaceCount()), (Color)color);
        }
    }

    private void renderWallObject(Graphics2D graphics, WallObject wallObject, Color color) {
        Model m;
        if (wallObject != null && (m = LargeModelsOverlay.renderableToModel(wallObject.getRenderable1())) != null && m.getFaceCount() > this.faceCount) {
            OverlayUtil.renderTileOverlay((Graphics2D)graphics, (TileObject)wallObject, (String)Integer.toString(m.getFaceCount()), (Color)color);
        }
    }

    private void renderDecorObject(Graphics2D graphics, Tile tile) {
        DecorativeObject decorObject = tile.getDecorativeObject();
        if (decorObject != null) {
            Shape p;
            Model m = LargeModelsOverlay.renderableToModel(decorObject.getRenderable());
            if (m != null && m.getFaceCount() > this.faceCount && (p = decorObject.getConvexHull()) != null) {
                graphics.draw(p);
            }
            if ((m = LargeModelsOverlay.renderableToModel(decorObject.getRenderable2())) != null && m.getFaceCount() > this.faceCount && (p = decorObject.getConvexHull2()) != null) {
                graphics.draw(p);
            }
        }
    }

    private static Model renderableToModel(Renderable r) {
        if (r == null) {
            return null;
        }
        if (r instanceof Model) {
            return (Model)r;
        }
        return r.getModel();
    }
}

