/*
 * Decompiled with CFR 0.152.
 */
package com.aocalerter;

import com.aocalerter.AoCAlerterConfig;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Amulet of Chemistry Alerter")
public class AoCAlerterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AoCAlerterPlugin.class);
    @Inject
    private Client client;
    @Inject
    private AoCAlerterConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Notifier notifier;
    public ArrayList<Integer> unfPotIds = new ArrayList();
    private static final Map<Integer, Set<Integer>> UNF_POTION_TO_SECONDARIES = ImmutableMap.builder().put((Object)26346, (Object)ImmutableSet.of((Object)27616)).put((Object)26344, (Object)ImmutableSet.of((Object)27616)).put((Object)26342, (Object)ImmutableSet.of((Object)27616)).put((Object)5958, (Object)ImmutableSet.of((Object)12934)).put((Object)5956, (Object)ImmutableSet.of((Object)12934)).put((Object)5954, (Object)ImmutableSet.of((Object)12934)).put((Object)2458, (Object)ImmutableSet.of((Object)11994)).put((Object)2456, (Object)ImmutableSet.of((Object)11994)).put((Object)2454, (Object)ImmutableSet.of((Object)11994)).put((Object)22470, (Object)ImmutableSet.of((Object)23964)).put((Object)22467, (Object)ImmutableSet.of((Object)23964)).put((Object)22464, (Object)ImmutableSet.of((Object)23964)).put((Object)22458, (Object)ImmutableSet.of((Object)23964)).put((Object)22455, (Object)ImmutableSet.of((Object)23964)).put((Object)22452, (Object)ImmutableSet.of((Object)23964)).put((Object)3046, (Object)ImmutableSet.of((Object)23964)).put((Object)3044, (Object)ImmutableSet.of((Object)23964)).put((Object)3042, (Object)ImmutableSet.of((Object)23964)).put((Object)173, (Object)ImmutableSet.of((Object)23964)).put((Object)171, (Object)ImmutableSet.of((Object)23964)).put((Object)169, (Object)ImmutableSet.of((Object)23964)).put((Object)21987, (Object)ImmutableSet.of((Object)11994)).put((Object)21984, (Object)ImmutableSet.of((Object)11994)).put((Object)21981, (Object)ImmutableSet.of((Object)11994)).put((Object)149, (Object)ImmutableSet.of((Object)23964)).put((Object)147, (Object)ImmutableSet.of((Object)23964)).put((Object)145, (Object)ImmutableSet.of((Object)23964)).put((Object)12701, (Object)ImmutableSet.of((Object)23964)).put((Object)12699, (Object)ImmutableSet.of((Object)23964)).put((Object)12697, (Object)ImmutableSet.of((Object)23964)).put((Object)167, (Object)ImmutableSet.of((Object)23964)).put((Object)165, (Object)ImmutableSet.of((Object)23964)).put((Object)163, (Object)ImmutableSet.of((Object)23964)).put((Object)3022, (Object)ImmutableSet.of((Object)12640)).put((Object)3020, (Object)ImmutableSet.of((Object)12640)).put((Object)3018, (Object)ImmutableSet.of((Object)12640)).put((Object)161, (Object)ImmutableSet.of((Object)23964)).put((Object)159, (Object)ImmutableSet.of((Object)23964)).put((Object)157, (Object)ImmutableSet.of((Object)23964)).put((Object)103, (Object)ImmutableSet.of((Object)10111, (Object)2970, (Object)231)).put((Object)22443, (Object)ImmutableSet.of((Object)3138, (Object)245)).put((Object)107, (Object)ImmutableSet.of((Object)3138, (Object)239, (Object)245)).put((Object)109, (Object)ImmutableSet.of((Object)27272, (Object)26368, (Object)245)).put((Object)91, (Object)ImmutableSet.of((Object)221)).put((Object)97, (Object)ImmutableSet.of((Object)1975, (Object)9736, (Object)223, (Object)21622)).put((Object)101, (Object)ImmutableSet.of((Object)221, (Object)235)).put((Object)105, (Object)ImmutableSet.of((Object)225)).put((Object)2483, (Object)ImmutableSet.of((Object)241, (Object)3138)).put((Object)93, (Object)ImmutableSet.of((Object)235)).put((Object)99, (Object)ImmutableSet.of((Object)231, (Object)239)).put((Object)3004, (Object)ImmutableSet.of((Object)223)).put((Object)95, (Object)ImmutableSet.of((Object)592, (Object)225)).put((Object)3002, (Object)ImmutableSet.of((Object)6693, (Object)26569, (Object)2152)).put((Object)111, (Object)ImmutableSet.of((Object)247)).put((Object)10923, (Object)ImmutableSet.of((Object)10937)).put((Object)10921, (Object)ImmutableSet.of((Object)10937)).put((Object)10919, (Object)ImmutableSet.of((Object)10937)).put((Object)7654, (Object)ImmutableSet.of((Object)7650)).put((Object)7656, (Object)ImmutableSet.of((Object)7650)).put((Object)7658, (Object)ImmutableSet.of((Object)7650)).build();

    protected void startUp() {
        this.unfPotIds.clear();
        this.splitIdList(this.config.desiredList(), this.unfPotIds);
        this.clientThread.invokeLater(() -> {
            ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
            if (this.containerHasMatch(inventory, UNF_POTION_TO_SECONDARIES)) {
                this.checkAoC();
            }
        });
    }

    private void checkAoC() {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (itemContainer == null || itemContainer.getItems()[EquipmentInventorySlot.AMULET.getSlotIdx()].getId() != 21163) {
            this.notifier.notify("You don't have an Amulet of Chemistry equipped!");
        }
    }

    @Subscribe
    void onItemContainerChanged(ItemContainerChanged event) {
        int changedContainerId = event.getContainerId();
        if (changedContainerId != InventoryID.INVENTORY.getId() && changedContainerId != InventoryID.EQUIPMENT.getId()) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
            if (this.containerHasMatch(container, UNF_POTION_TO_SECONDARIES)) {
                this.checkAoC();
            }
        });
    }

    private void splitIdList(String configStr, ArrayList<Integer> idList) {
        if (!configStr.equals("")) {
            for (String str : configStr.split(",")) {
                if (str.trim().equals("")) continue;
                try {
                    idList.add(Integer.parseInt(str.trim()));
                }
                catch (Exception ex) {
                    log.info("AoC Alerter: " + ex.getMessage());
                }
            }
        }
    }

    protected void shutDown() throws Exception {
        this.unfPotIds.clear();
    }

    private boolean containerHasMatch(@Nullable ItemContainer container, Map<Integer, Set<Integer>> unfToSecondaries) {
        if (container == null) {
            return false;
        }
        if (!this.config.useIDList()) {
            for (Map.Entry<Integer, Set<Integer>> entry : unfToSecondaries.entrySet()) {
                if (!container.contains(entry.getKey().intValue())) continue;
                for (int secondary : entry.getValue()) {
                    if (!container.contains(secondary)) continue;
                    return true;
                }
            }
            return false;
        }
        for (int desiredID : this.unfPotIds) {
            if (!container.contains(desiredID)) continue;
            for (int secondary : unfToSecondaries.get(desiredID)) {
                if (!container.contains(secondary)) continue;
                return true;
            }
        }
        return false;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("aocalerter")) {
            this.unfPotIds.clear();
            this.splitIdList(this.config.desiredList(), this.unfPotIds);
        }
    }

    @Provides
    AoCAlerterConfig providesConfig(ConfigManager configManager) {
        return (AoCAlerterConfig)configManager.getConfig(AoCAlerterConfig.class);
    }
}

