/*
 * Decompiled with CFR 0.152.
 */
package com.skeldoor;

import com.google.inject.Provides;
import com.skeldoor.HoldYourGroundConfig;
import com.skeldoor.HoldYourGroundOverlay;
import com.skeldoor.HoldYourGroundUtils;
import java.awt.Color;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Hold Your Ground")
public class HoldYourGroundPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HoldYourGroundPlugin.class);
    @Inject
    private Client client;
    @Inject
    private HoldYourGroundConfig config;
    @Inject
    private HoldYourGroundOverlay holdYourGroundOverlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    String attackOption = "Attack";
    String magicOption = "Cast";
    String talkMenuOption = "Talk-to";
    String tradeMenuOption = "Trade";
    String pickpocketMenuOption = "Pickpocket";
    String useMenuOption = "Use";
    String walkHereMenuOption = "Walk here";
    boolean overrideHoldMove = false;
    @Inject
    private KeyManager keyManager;
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> this.config.holdMovingHotkey()){

        public void hotkeyPressed() {
            HoldYourGroundPlugin.this.overrideHoldMove = true;
        }

        public void hotkeyReleased() {
            HoldYourGroundPlugin.this.overrideHoldMove = false;
        }
    };

    protected void startUp() {
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
        this.overlayManager.add((Overlay)this.holdYourGroundOverlay);
    }

    protected void shutDown() throws Exception {
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
        this.overlayManager.remove((Overlay)this.holdYourGroundOverlay);
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        String target = event.getMenuTarget();
        String menuOption = event.getMenuOption();
        if (Objects.equals(menuOption, this.walkHereMenuOption)) {
            if (this.overrideHoldMove) {
                this.sendHighlightedChatMessage("Player movement is allowed as hotkey is held");
            } else if (this.config.holdMoving()) {
                event.getMenuEntry().setTarget(ColorUtil.prependColorTag((String)Text.removeTags((String)target), (Color)Color.black));
                event.getMenuEntry().setDeprioritized(true);
                event.consume();
                this.sendHighlightedChatMessage("Player movement is disabled");
            }
        }
        int identifier = event.getMenuEntry().getIdentifier();
        NPC[] cachedNPCs = this.client.getCachedNPCs();
        NPC npc = cachedNPCs[identifier];
        if (npc == null) {
            return;
        }
        if (npc.getName() == null) {
            return;
        }
        WorldArea start = this.client.getLocalPlayer().getWorldArea();
        boolean hasLineOfSight = HoldYourGroundUtils.hasLineOfSight(this.client, start, npc.getLocalLocation());
        boolean isWithinRange = HoldYourGroundUtils.isWithinRange(this.client, start, npc.getLocalLocation(), this.config.maxTileRange());
        if (this.config.holdAttacks() && Objects.equals(menuOption, this.attackOption) || this.config.holdSpells() && Objects.equals(menuOption, this.magicOption) || this.config.holdTalkTo() && Objects.equals(menuOption, this.talkMenuOption) || this.config.holdTrades() && Objects.equals(menuOption, this.tradeMenuOption) || this.config.holdPickpockets() && Objects.equals(menuOption, this.pickpocketMenuOption) || this.config.holdUses() && Objects.equals(menuOption, this.useMenuOption)) {
            if (!hasLineOfSight) {
                event.getMenuEntry().setTarget(ColorUtil.prependColorTag((String)Text.removeTags((String)target), (Color)Color.black));
                event.getMenuEntry().setDeprioritized(true);
                event.consume();
                this.sendHighlightedChatMessage("No line of sight to your target to " + menuOption);
            } else if (!isWithinRange) {
                event.getMenuEntry().setTarget(ColorUtil.prependColorTag((String)Text.removeTags((String)target), (Color)Color.black));
                event.getMenuEntry().setDeprioritized(true);
                event.consume();
                this.sendHighlightedChatMessage("Your target is too far to " + menuOption);
            } else if (this.config.requireStationary() && npc.getPoseAnimation() != npc.getIdlePoseAnimation()) {
                event.getMenuEntry().setTarget(ColorUtil.prependColorTag((String)Text.removeTags((String)target), (Color)Color.black));
                event.getMenuEntry().setDeprioritized(true);
                event.consume();
                this.sendHighlightedChatMessage("Your target is moving");
            }
        }
    }

    private void sendHighlightedChatMessage(String message) {
        if (!this.config.chatMessages()) {
            return;
        }
        ChatMessageBuilder msg = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(message);
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(msg.build()).build());
    }

    @Provides
    HoldYourGroundConfig provideConfig(ConfigManager configManager) {
        return (HoldYourGroundConfig)configManager.getConfig(HoldYourGroundConfig.class);
    }
}

