/*
 * Decompiled with CFR 0.152.
 */
package com.skeldoor;

import com.skeldoor.HoldYourGroundConfig;
import com.skeldoor.HoldYourGroundUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class HoldYourGroundOverlay
extends Overlay {
    @Inject
    private Client client;
    @Inject
    private HoldYourGroundConfig config;

    @Inject
    private HoldYourGroundOverlay() {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPriority(OverlayPriority.HIGHEST);
    }

    private void renderTileIfHasLineOfSight(Graphics2D graphics, WorldArea start, LocalPoint targetLocalPoint, Polygon polyToRender) {
        Color tileColour = Color.red;
        if (HoldYourGroundUtils.hasLineOfSight(this.client, start, targetLocalPoint) && HoldYourGroundUtils.isWithinRange(this.client, start, targetLocalPoint, this.config.maxTileRange())) {
            tileColour = Color.green;
        }
        OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)polyToRender, (Color)tileColour);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showOverlay()) {
            return null;
        }
        WorldArea start = this.client.getLocalPlayer().getWorldArea();
        Tile[][][] tiles = this.client.getScene().getTiles();
        int z = this.client.getPlane();
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                Tile tile = tiles[z][x][y];
                LocalPoint tileLocalLocation = tile.getLocalLocation();
                Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)tileLocalLocation);
                if (poly == null || !poly.contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) continue;
                this.renderTileIfHasLineOfSight(graphics, start, tileLocalLocation, poly);
            }
        }
        return null;
    }
}

