/*
 * Decompiled with CFR 0.152.
 */
package pharros.probabilitycalculator;

import com.google.inject.Provides;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pharros.probabilitycalculator.ProbabilityCalculatorConfig;
import pharros.probabilitycalculator.ProbabilityCalculatorInputArea;
import pharros.probabilitycalculator.ProbabilityCalculatorOutputArea;
import pharros.probabilitycalculator.ProbabilityCalculatorPanel;

@PluginDescriptor(name="Probability Calculator")
public class ProbabilityCalculatorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ProbabilityCalculatorPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ProbabilityCalculatorConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    private ProbabilityCalculatorPanel panel;
    private ProbabilityCalculatorInputArea input;
    private ProbabilityCalculatorOutputArea output;
    private NavigationButton navButton;
    private double dropRate = 0.01;
    private int killCount = 100;
    private int dropsReceived = 1;

    protected void startUp() {
        log.info("prob-calc: Plugin started!");
        this.input = new ProbabilityCalculatorInputArea();
        this.output = new ProbabilityCalculatorOutputArea(this.dropRate, this.killCount, this.dropsReceived, this.config);
        this.panel = new ProbabilityCalculatorPanel(this.input, this.output);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(ProbabilityCalculatorPlugin.class, (String)"probabilitycalculator_icon.png");
        this.input.getUiDropRate().addActionListener(e -> this.onFieldDropRateUpdated());
        this.input.getUiKillCount().addActionListener(e -> this.onFieldKillCountUpdated());
        this.input.getUiDropsReceived().addActionListener(e -> this.onFieldDropsReceivedUpdated());
        this.input.getUiDropRate().addFocusListener(this.buildFocusAdapter(e -> this.onFieldDropRateUpdated()));
        this.input.getUiKillCount().addFocusListener(this.buildFocusAdapter(e -> this.onFieldKillCountUpdated()));
        this.input.getUiDropsReceived().addFocusListener(this.buildFocusAdapter(e -> this.onFieldDropsReceivedUpdated()));
        this.updateInputFields();
        this.navButton = NavigationButton.builder().tooltip("Probability Calculator").icon(icon).priority(7).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    private void onFieldDropRateUpdated() {
        if (this.input.getDropRateInput().contains("/")) {
            String num = this.input.getDropRateInput().split("/")[0];
            String den = this.input.getDropRateInput().split("/")[1];
            this.dropRate = Double.parseDouble(num) / Double.parseDouble(den);
        } else {
            this.dropRate = Double.parseDouble(this.input.getDropRateInput());
        }
        this.updateInputFields();
    }

    private void onFieldKillCountUpdated() {
        this.killCount = this.input.getKillCountInput();
        this.updateInputFields();
    }

    private void onFieldDropsReceivedUpdated() {
        this.dropsReceived = this.input.getDropsReceivedInput();
        this.updateInputFields();
    }

    private void updateInputFields() {
        this.input.setDropRateInput(this.input.getDropRateInput());
        this.input.setDropsReceivedInput(this.dropsReceived);
        this.input.setKillCountInput(this.killCount);
        this.output.setDropRate(this.dropRate);
        this.output.setKillCount(this.killCount);
        this.output.setDropsReceived(this.dropsReceived);
        this.output.updateTextArea();
        log.info("prob-calc: Input fields updated!");
    }

    private FocusAdapter buildFocusAdapter(final Consumer<FocusEvent> focusLostConsumer) {
        return new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                focusLostConsumer.accept(e);
            }
        };
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
        log.info("prob-calc: Plugin stopped!");
    }

    @Provides
    ProbabilityCalculatorConfig provideConfig(ConfigManager configManager) {
        return (ProbabilityCalculatorConfig)configManager.getConfig(ProbabilityCalculatorConfig.class);
    }
}

