/*
 * Decompiled with CFR 0.152.
 */
package pharros.probabilitycalculator;

import java.awt.BorderLayout;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import pharros.probabilitycalculator.ProbabilityCalculatorConfig;

public class ProbabilityCalculatorOutputArea
extends JPanel {
    private JTextArea textArea;
    private double atLeastChance;
    private double zeroChance;
    private double exactChance;
    private long killCount;
    private long dropsReceived;
    private double dropRate;
    private String strAtLeastChance;
    private String strExactChance;
    private String strZeroChance;
    private String outputMsg;
    private DecimalFormat df;
    private String dfPattern;
    private final ProbabilityCalculatorConfig config;
    private StringBuilder strBldr;

    ProbabilityCalculatorOutputArea(double dropRate, int killCount, int dropsReceived, ProbabilityCalculatorConfig config) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(ColorScheme.DARKER_GRAY_COLOR, 5));
        this.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.killCount = killCount;
        this.dropsReceived = dropsReceived;
        this.dropRate = dropRate;
        this.config = config;
        this.updatedfPattern();
        this.calculateProbabilities();
        this.textArea = new JTextArea(this.outputMsg);
        this.textArea.setEditable(false);
        this.textArea.setFont(FontManager.getRunescapeBoldFont());
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.add(this.textArea);
    }

    private double nCx(double n, double x) {
        if (x > n / 2.0) {
            x = n - x;
        }
        double ret = 1.0;
        int i = 1;
        while ((double)i <= x) {
            ret *= n - x + (double)i;
            ret /= (double)i;
            ++i;
        }
        return ret;
    }

    private double binomialProb(double n, double x, double p) {
        return this.nCx(n, x) * Math.pow(p, x) * Math.pow(1.0 - p, n - x);
    }

    void calculateProbabilities() {
        if (this.killCount < this.dropsReceived) {
            this.outputMsg = "You've somehow cheated the RNG gods and managed to get more drops than you got kills. What is this sorcery?!";
        } else if (this.dropRate >= 1.0 || this.dropRate <= 0.0) {
            this.outputMsg = "Please use a drop rate value that is between 0.0 and 1.0, exclusively.";
        } else {
            this.exactChance = this.binomialProb(this.killCount, this.dropsReceived, this.dropRate);
            if (Double.isNaN(this.exactChance)) {
                this.outputMsg = "Your input for kill count or drops received is too large for this calculator. Please user smaller amounts.";
                return;
            }
            this.zeroChance = Math.pow(1.0 - this.dropRate, this.killCount);
            if (Double.isNaN(this.zeroChance)) {
                this.outputMsg = "Your input for kill count or drops received is too large for this calculator. Please user smaller amounts.";
                return;
            }
            if ((double)this.dropsReceived == 1.0) {
                this.atLeastChance = 1.0 - this.zeroChance;
            } else {
                this.atLeastChance = 0.0;
                int i = 0;
                while ((long)i < this.dropsReceived) {
                    this.atLeastChance += this.binomialProb(this.killCount, i, this.dropRate);
                    ++i;
                }
                this.atLeastChance = 1.0 - this.atLeastChance;
                if (Double.isNaN(this.atLeastChance)) {
                    this.outputMsg = "Your input for kill count or drops received is too large for this calculator. Please user smaller amounts.";
                    return;
                }
            }
            this.strAtLeastChance = this.df.format(Math.abs(this.atLeastChance * 100.0));
            if (this.strAtLeastChance.equals("0") || this.strAtLeastChance.equals("100")) {
                this.strAtLeastChance = "~" + this.strAtLeastChance;
            }
            this.strExactChance = this.df.format(Math.abs(this.exactChance * 100.0));
            if (this.strExactChance.equals("0") || this.strExactChance.equals("100")) {
                this.strExactChance = "~" + this.strExactChance;
            }
            this.strZeroChance = this.df.format(Math.abs(this.zeroChance * 100.0));
            if (this.strZeroChance.equals("0") || this.strZeroChance.equals("100")) {
                this.strZeroChance = "~" + this.strZeroChance;
            }
            this.outputMsg = "At " + this.killCount + " kill(s), " + this.dropsReceived + " drop(s), and a drop rate of " + this.dropRate + ", your chances are:\n\nChance to get at least " + this.dropsReceived + " drop(s):\n" + this.strAtLeastChance + "%\n\nChance to get exactly " + this.dropsReceived + " drop(s):\n" + this.strExactChance + "%\n\nChance to get zero drops:\n" + this.strZeroChance + "%\n\n==========================\n\nExpected drop(s) for given input:\n" + (int)Math.round(this.dropRate * (double)this.killCount) + "\n\nExpected kill count for given input:\n" + (int)Math.ceil((double)this.dropsReceived / this.dropRate);
        }
    }

    void updateTextArea() {
        this.remove(this.textArea);
        this.updatedfPattern();
        this.calculateProbabilities();
        this.textArea = new JTextArea(this.outputMsg);
        this.textArea.setEditable(false);
        this.textArea.setFont(FontManager.getRunescapeBoldFont());
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.add(this.textArea);
        this.revalidate();
        this.repaint();
    }

    private void updatedfPattern() {
        if (this.config.getDecimalPlaces() > 0) {
            this.strBldr = new StringBuilder();
            this.strBldr.append("#.");
            for (int i = 0; i < this.config.getDecimalPlaces(); ++i) {
                this.strBldr.append("#");
            }
            this.dfPattern = this.strBldr.toString();
        } else {
            this.dfPattern = "#";
        }
        this.df = new DecimalFormat(this.dfPattern);
    }

    public void setTextArea(JTextArea textArea) {
        this.textArea = textArea;
    }

    public void setAtLeastChance(double atLeastChance) {
        this.atLeastChance = atLeastChance;
    }

    public void setZeroChance(double zeroChance) {
        this.zeroChance = zeroChance;
    }

    public void setExactChance(double exactChance) {
        this.exactChance = exactChance;
    }

    public void setKillCount(long killCount) {
        this.killCount = killCount;
    }

    public void setDropsReceived(long dropsReceived) {
        this.dropsReceived = dropsReceived;
    }

    public void setDropRate(double dropRate) {
        this.dropRate = dropRate;
    }

    public void setStrAtLeastChance(String strAtLeastChance) {
        this.strAtLeastChance = strAtLeastChance;
    }

    public void setStrExactChance(String strExactChance) {
        this.strExactChance = strExactChance;
    }

    public void setStrZeroChance(String strZeroChance) {
        this.strZeroChance = strZeroChance;
    }

    public void setOutputMsg(String outputMsg) {
        this.outputMsg = outputMsg;
    }

    public void setDf(DecimalFormat df) {
        this.df = df;
    }

    public void setDfPattern(String dfPattern) {
        this.dfPattern = dfPattern;
    }

    public void setStrBldr(StringBuilder strBldr) {
        this.strBldr = strBldr;
    }
}

