/*
 * Decompiled with CFR 0.152.
 */
package pharros.probabilitycalculator;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.FlatTextField;

public class ProbabilityCalculatorInputArea
extends JPanel {
    private final JTextField uiDropRate;
    private final JTextField uiKillCount;
    private final JTextField uiDropsReceived;

    ProbabilityCalculatorInputArea() {
        this.setLayout(new GridLayout(3, 1, 0, 4));
        this.uiDropRate = this.addComponent("Drop Rate:");
        this.uiKillCount = this.addComponent("Kill Count:");
        this.uiDropsReceived = this.addComponent("Drops Received:");
    }

    String getDropRateInput() {
        JTextField field = this.uiDropRate;
        field.setText(field.getText().trim());
        try {
            if (field.getText().contains("/") && field.getText().replaceAll("/", "").length() == field.getText().length() - 1) {
                String num = field.getText().split("/")[0];
                String den = field.getText().split("/")[1];
                if (this.tryParseDouble(num) && this.tryParseDouble(den)) {
                    return field.getText();
                }
                return "0.1";
            }
            if (this.tryParseDouble(field.getText())) {
                return field.getText();
            }
            return "0.1";
        }
        catch (NumberFormatException e) {
            return "0.1";
        }
    }

    void setDropRateInput(String value) {
        this.setInput(this.uiDropRate, value);
    }

    int getKillCountInput() {
        if (this.tryParseInt(this.uiKillCount.getText())) {
            return Integer.parseInt(this.uiKillCount.getText());
        }
        return 100;
    }

    void setKillCountInput(int value) {
        this.setInput(this.uiKillCount, value);
    }

    int getDropsReceivedInput() {
        if (this.tryParseInt(this.uiDropsReceived.getText())) {
            return Integer.parseInt(this.uiDropsReceived.getText());
        }
        return 1;
    }

    void setDropsReceivedInput(int value) {
        this.setInput(this.uiDropsReceived, value);
    }

    private void setInput(JTextField field, Object value) {
        field.setText(String.valueOf(value));
    }

    boolean tryParseDouble(String input) {
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    boolean tryParseInt(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private JTextField addComponent(String label) {
        JPanel container = new JPanel();
        container.setLayout(new GridLayout(1, 2, 0, 4));
        JLabel uiLabel = new JLabel(label);
        FlatTextField uiInput = new FlatTextField();
        uiLabel.setFont(FontManager.getRunescapeSmallFont());
        uiLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        uiLabel.setForeground(Color.WHITE);
        uiInput.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        uiInput.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        uiInput.setBorder((Border)new EmptyBorder(5, 7, 5, 7));
        container.add((Component)uiLabel, "West");
        container.add((Component)uiInput, "East");
        this.add(container);
        return uiInput.getTextField();
    }

    public JTextField getUiDropRate() {
        return this.uiDropRate;
    }

    public JTextField getUiKillCount() {
        return this.uiKillCount;
    }

    public JTextField getUiDropsReceived() {
        return this.uiDropsReceived;
    }
}

