/*
 * Decompiled with CFR 0.152.
 */
package com.tobqolimprovements;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.tobqolimprovements.RemindersOverlay;
import com.tobqolimprovements.ToBQoLImprovementsConfig;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.MenuEntry;
import net.runelite.api.ObjectComposition;
import net.runelite.api.events.AreaSoundEffectPlayed;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ToB QoL Improvements", description="Minor QoL improvements to the Theatre of Blood", tags={"tob", "theatre", "theater", "raids2"}, enabledByDefault=false)
public class ToBQoLImprovementsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ToBQoLImprovementsPlugin.class);
    private static final Set<String> TOB_CHEST_TARGETS = ImmutableSet.of((Object)"stamina potion(4)", (Object)"prayer potion(4)", (Object)"saradomin brew(4)", (Object)"super restore(4)", (Object)"mushroom potato", (Object)"shark", (Object[])new String[]{"sea turtle", "manta ray"});
    @Inject
    private Client client;
    @Inject
    private ToBQoLImprovementsConfig config;
    @Inject
    private ConfigManager configManager;
    private final ArrayListMultimap<String, Integer> optionIndexes = ArrayListMultimap.create();
    private GameObject lootChest;
    boolean chestHasLoot = false;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private RemindersOverlay overlay;
    private static final Set<Integer> VER_SINHAZA_REGIONS = ImmutableSet.of((Object)14386, (Object)14642);
    private static final int VERZIK_P2_AREA_SOUND_EFFECT_ID = 3987;

    @Provides
    ToBQoLImprovementsConfig provideConfig(ConfigManager configManager) {
        return (ToBQoLImprovementsConfig)configManager.getConfig(ToBQoLImprovementsConfig.class);
    }

    public void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    public void shutDown() {
        this.lootChest = null;
        this.chestHasLoot = false;
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int index = 0;
        this.optionIndexes.clear();
        for (MenuEntry entry : menuEntries) {
            String option = Text.removeTags((String)entry.getOption()).toLowerCase();
            this.optionIndexes.put((Object)option, (Object)index++);
        }
        index = 0;
        for (MenuEntry entry : menuEntries) {
            this.swapMenuEntry(index++, entry);
        }
        if (this.config.lootChestBankAll() && this.client.getGameState() == GameState.LOGGED_IN && !this.client.isMenuOpen() && this.isInVerSinhaza()) {
            for (MenuEntry entry : menuEntries) {
                if (!entry.getOption().equals("Bank-all")) continue;
                entry.setForceLeftClick(true);
                break;
            }
            this.client.setMenuEntries(menuEntries);
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.isInVerSinhaza()) {
            if (this.lootChest != null && Objects.requireNonNull(this.getObjectComposition(this.lootChest.getId())).getId() == 41435 && !this.chestHasLoot) {
                this.chestHasLoot = true;
                this.client.setHintArrow(this.lootChest.getWorldLocation());
            }
            if (this.lootChest != null && Objects.requireNonNull(this.getObjectComposition(this.lootChest.getId())).getId() == 41436 && this.chestHasLoot) {
                this.chestHasLoot = false;
                this.client.clearHintArrow();
            }
        } else if (this.lootChest != null) {
            this.lootChest = null;
        }
    }

    @Nullable
    private ObjectComposition getObjectComposition(int id) {
        ObjectComposition objectComposition = this.client.getObjectDefinition(id);
        return objectComposition.getImpostorIds() == null ? objectComposition : objectComposition.getImpostor();
    }

    public boolean isInVerSinhaza() {
        return VER_SINHAZA_REGIONS.contains(Objects.requireNonNull(this.client.getLocalPlayer()).getWorldLocation().getRegionID());
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (event.getGameObject().getId() == 41437) {
            this.lootChest = event.getGameObject();
        }
    }

    private void swapMenuEntry(int index, MenuEntry menuEntry) {
        String option = Text.removeTags((String)menuEntry.getOption()).toLowerCase();
        String target = Text.removeTags((String)menuEntry.getTarget()).toLowerCase();
        if (option.equals("value") && !this.config.tobSupplyChestBuy().toString().equals("value") && TOB_CHEST_TARGETS.contains(target)) {
            this.swap(option, target, index);
        }
    }

    private void swap(String option, String target, int index) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int thisIndex = this.findIndex(menuEntries, index, option, target);
        int optionIdx = this.findIndex(menuEntries, thisIndex, this.config.tobSupplyChestBuy().toString(), target);
        if (thisIndex >= 0 && optionIdx >= 0) {
            this.swap(this.optionIndexes, menuEntries, optionIdx, thisIndex);
        }
    }

    private int findIndex(MenuEntry[] entries, int limit, String option, String target) {
        List indexes = this.optionIndexes.get((Object)option);
        for (int i = indexes.size() - 1; i >= 0; --i) {
            int index = (Integer)indexes.get(i);
            MenuEntry entry = entries[index];
            String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
            if (index > limit || !entryTarget.equals(target)) continue;
            return index;
        }
        return -1;
    }

    private void swap(ArrayListMultimap<String, Integer> optionIndexes, MenuEntry[] entries, int index1, int index2) {
        MenuEntry entry = entries[index1];
        entries[index1] = entries[index2];
        entries[index2] = entry;
        this.client.setMenuEntries(entries);
        optionIndexes.clear();
        int idx = 0;
        for (MenuEntry menuEntry : entries) {
            String option = Text.removeTags((String)menuEntry.getOption()).toLowerCase();
            optionIndexes.put((Object)option, (Object)idx++);
        }
    }

    @Subscribe
    public void onAreaSoundEffectPlayed(AreaSoundEffectPlayed areaSoundEffectPlayed) {
        int soundId = areaSoundEffectPlayed.getSoundId();
        if (this.config.muteVerzikP2AreaSounds() && soundId == 3987) {
            areaSoundEffectPlayed.consume();
        }
    }

    public GameObject getLootChest() {
        return this.lootChest;
    }

    public boolean isChestHasLoot() {
        return this.chestHasLoot;
    }
}

