/*
 * Decompiled with CFR 0.152.
 */
package scapecloud.runelite.api;

import net.runelite.api.Player;

public class NearbyPlayer {
    private final String playerName;
    private final boolean isFriend;
    private final boolean isFriendsChat;
    private final int team;
    private final int combatLevel;

    public NearbyPlayer(Player player) {
        this.playerName = player.getName();
        this.isFriend = player.isFriend();
        this.isFriendsChat = player.isFriendsChatMember();
        this.team = player.getTeam();
        this.combatLevel = player.getCombatLevel();
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public boolean isFriend() {
        return this.isFriend;
    }

    public boolean isFriendsChat() {
        return this.isFriendsChat;
    }

    public int getTeam() {
        return this.team;
    }

    public int getCombatLevel() {
        return this.combatLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NearbyPlayer)) {
            return false;
        }
        NearbyPlayer other = (NearbyPlayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$playerName = this.getPlayerName();
        String other$playerName = other.getPlayerName();
        if (this$playerName == null ? other$playerName != null : !this$playerName.equals(other$playerName)) {
            return false;
        }
        if (this.isFriend() != other.isFriend()) {
            return false;
        }
        if (this.isFriendsChat() != other.isFriendsChat()) {
            return false;
        }
        if (this.getTeam() != other.getTeam()) {
            return false;
        }
        return this.getCombatLevel() == other.getCombatLevel();
    }

    protected boolean canEqual(Object other) {
        return other instanceof NearbyPlayer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $playerName = this.getPlayerName();
        result = result * 59 + ($playerName == null ? 43 : $playerName.hashCode());
        result = result * 59 + (this.isFriend() ? 79 : 97);
        result = result * 59 + (this.isFriendsChat() ? 79 : 97);
        result = result * 59 + this.getTeam();
        result = result * 59 + this.getCombatLevel();
        return result;
    }

    public String toString() {
        return "NearbyPlayer(playerName=" + this.getPlayerName() + ", isFriend=" + this.isFriend() + ", isFriendsChat=" + this.isFriendsChat() + ", team=" + this.getTeam() + ", combatLevel=" + this.getCombatLevel() + ")";
    }

    public NearbyPlayer(String playerName, boolean isFriend, boolean isFriendsChat, int team, int combatLevel) {
        this.playerName = playerName;
        this.isFriend = isFriend;
        this.isFriendsChat = isFriendsChat;
        this.team = team;
        this.combatLevel = combatLevel;
    }
}

