/*
 * Decompiled with CFR 0.152.
 */
package scapecloud.runelite;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scapecloud.runelite.ScapeCloudAPI;
import scapecloud.runelite.ScapeCloudConfig;
import scapecloud.runelite.ScapeCloudImageCapture;
import scapecloud.runelite.ScapeCloudLogin;
import scapecloud.runelite.ScapeCloudOverlay;

@PluginDescriptor(name="OSRSLog", description="Enable the manual and automatic taking of screenshots", tags={"external", "images", "scapecloud", "integration", "notifications"})
public class ScapeCloudPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ScapeCloudPlugin.class);
    private static final String COLLECTION_LOG_TEXT = "New item added to your collection log: ";
    private static final String CHEST_LOOTED_MESSAGE = "You find some treasure in the chest!";
    private static final Map<Integer, String> CHEST_LOOT_EVENTS = ImmutableMap.of((Object)12127, (Object)"The Gauntlet");
    private static final int GAUNTLET_REGION = 7512;
    private static final int CORRUPTED_GAUNTLET_REGION = 7768;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("([0-9]+)");
    private static final Pattern LEVEL_UP_PATTERN = Pattern.compile(".*Your ([a-zA-Z]+) (?:level is|are)? now (\\d+)\\.");
    private static final Pattern BOSSKILL_MESSAGE_PATTERN = Pattern.compile("Your (.+) kill count is: <col=ff0000>(\\d+)</col>.");
    private static final Pattern VALUABLE_DROP_PATTERN = Pattern.compile(".*Valuable drop: ([^<>]+?\\(((?:\\d+,?)+) coins\\))(?:</col>)?");
    private static final Pattern UNTRADEABLE_DROP_PATTERN = Pattern.compile(".*Untradeable drop: ([^<>]+)(?:</col>)?");
    private static final Pattern DUEL_END_PATTERN = Pattern.compile("You have now (won|lost) ([0-9]+) duels?\\.");
    private static final Pattern QUEST_PATTERN_1 = Pattern.compile(".+?ve\\.*? (?<verb>been|rebuilt|.+?ed)? ?(?:the )?'?(?<quest>.+?)'?(?: [Qq]uest)?[!.]?$");
    private static final Pattern QUEST_PATTERN_2 = Pattern.compile("'?(?<quest>.+?)'?(?: [Qq]uest)? (?<verb>[a-z]\\w+?ed)?(?: f.*?)?[!.]?$");
    private static final ImmutableList<String> RFD_TAGS = ImmutableList.of((Object)"Another Cook", (Object)"freed", (Object)"defeated", (Object)"saved");
    private static final ImmutableList<String> WORD_QUEST_IN_NAME_TAGS = ImmutableList.of((Object)"Another Cook", (Object)"Doric", (Object)"Heroes", (Object)"Legends", (Object)"Observatory", (Object)"Olaf", (Object)"Waterfall");
    private static final ImmutableList<String> PET_MESSAGES = ImmutableList.of((Object)"You have a funny feeling like you're being followed", (Object)"You feel something weird sneaking into your backpack", (Object)"You have a funny feeling like you would have been followed");
    private static final Pattern BA_HIGH_GAMBLE_REWARD_PATTERN = Pattern.compile("(?<reward>.+)!<br>High level gamble count: <col=7f0000>(?<gambleCount>.+)</col>");
    private static final Set<Integer> REPORT_BUTTON_TLIS = ImmutableSet.of((Object)548, (Object)161, (Object)164);
    private static final String SD_KINGDOM_REWARDS = "Kingdom Rewards";
    private static final String SD_BOSS_KILLS = "Boss Kills";
    private static final String SD_CLUE_SCROLL_REWARDS = "Clue Scroll Rewards";
    private static final String SD_FRIENDS_CHAT_KICKS = "Friends Chat Kicks";
    private static final String SD_PETS = "Pets";
    private static final String SD_CHEST_LOOT = "Chest Loot";
    private static final String SD_VALUABLE_DROPS = "Valuable Drops";
    private static final String SD_UNTRADEABLE_DROPS = "Untradeable Drops";
    private static final String SD_DUELS = "Duels";
    private static final String SD_COLLECTION_LOG = "Collection Log";
    private static final String SD_PVP_KILLS = "PvP Kills";
    private static final String SD_DEATHS = "Deaths";
    private static final int THROTTLE_AMOUNT = 200;
    private String clueType;
    private Integer clueNumber;
    private KillType killType;
    private Integer killCountNumber;
    private boolean shouldTakeScreenshot;
    @Inject
    private ScapeCloudConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ScapeCloudOverlay screenshotOverlay;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientUI clientUi;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private DrawManager drawManager;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private ScapeCloudAPI api;
    @Inject
    private ScapeCloudImageCapture imageCapture;
    @Inject
    private ScapeCloudLogin login;
    @Inject
    private KeyManager keyManager;
    @Inject
    private SpriteManager spriteManager;
    private BufferedImage reportButton;
    private NavigationButton screenshotButton;
    private NavigationButton scapecloudLoginButton;
    private NavigationButton scapecloudLogoutButton;
    private String kickPlayerName;
    private long lastManualScreenshot;
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> this.config.hotkey()){

        public void hotkeyPressed() {
            ScapeCloudPlugin.this.manualScreenshot();
        }
    };

    @Provides
    ScapeCloudConfig getConfig(ConfigManager configManager) {
        return (ScapeCloudConfig)configManager.getConfig(ScapeCloudConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.screenshotOverlay);
        RuneLite.SCREENSHOT_DIR.mkdirs();
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
        BufferedImage screenshotIcon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"screenshot.png");
        BufferedImage scapecloudLoginIcon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"scapecloud_login.png");
        BufferedImage scapecloudLogoutIcon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"scapecloud_logout.png");
        this.screenshotButton = NavigationButton.builder().tab(false).tooltip("Take screenshot").icon(screenshotIcon).onClick(this::manualScreenshot).popup((Map)ImmutableMap.builder().put((Object)"Open screenshot folder...", () -> LinkBrowser.open((String)RuneLite.SCREENSHOT_DIR.toString())).build()).build();
        this.scapecloudLoginButton = NavigationButton.builder().tab(false).tooltip("OSRSLog Login").icon(scapecloudLoginIcon).onClick(this::loginClick).build();
        this.scapecloudLogoutButton = NavigationButton.builder().tab(false).tooltip("OSRSLog Logout").icon(scapecloudLogoutIcon).onClick(this::logoutClick).build();
        this.clientToolbar.addNavigation(this.screenshotButton);
        this.clientToolbar.addNavigation(this.scapecloudLoginButton);
        this.spriteManager.getSpriteAsync(3057, 0, s -> {
            this.reportButton = s;
        });
        this.lastManualScreenshot = 0L;
        if (this.config.email().length() > 0 && this.config.password().length() > 0) {
            this.executor.submit(() -> this.api.authenticate(this.config.email(), this.config.password(), this::addAndRemoveButtons));
        }
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.screenshotOverlay);
        this.clientToolbar.removeNavigation(this.screenshotButton);
        this.clientToolbar.removeNavigation(this.scapecloudLoginButton);
        this.clientToolbar.removeNavigation(this.scapecloudLogoutButton);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
        this.kickPlayerName = null;
    }

    public void addAndRemoveButtons() {
        this.clientToolbar.removeNavigation(this.scapecloudLoginButton);
        this.clientToolbar.removeNavigation(this.scapecloudLogoutButton);
        this.clientToolbar.addNavigation(this.api.isAuthenticated() ? this.scapecloudLogoutButton : this.scapecloudLoginButton);
    }

    private void loginClick() {
        SwingUtilities.invokeLater(this.login::display);
    }

    private void logoutClick() {
        SwingUtilities.invokeLater(this.login::logout);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.shouldTakeScreenshot) {
            return;
        }
        this.shouldTakeScreenshot = false;
        String screenshotSubDir = null;
        ArrayList<Object> events = new ArrayList<Object>();
        Object fileName = null;
        if (this.client.getWidget(WidgetInfo.LEVEL_UP_LEVEL) != null) {
            Matcher levelMatcher = this.parseLevelUpWidget(WidgetInfo.LEVEL_UP_LEVEL);
            if (levelMatcher != null) {
                String skillName = levelMatcher.group(1);
                String skillLevel = levelMatcher.group(2);
                fileName = skillName + "(" + skillLevel + ")";
            }
            screenshotSubDir = "Levels";
        } else if (this.client.getWidget(WidgetInfo.DIALOG_SPRITE_TEXT) != null) {
            Matcher levelMatcher;
            String text = this.client.getWidget(WidgetInfo.DIALOG_SPRITE_TEXT).getText();
            if (Text.removeTags((String)text).contains("High level gamble")) {
                if (this.config.screenshotHighGamble()) {
                    fileName = ScapeCloudPlugin.parseBAHighGambleWidget(text);
                    screenshotSubDir = "BA High Gambles";
                    events.add("barb_assault");
                    events.add("barbarian_assault");
                    events.add("ba_gamble");
                }
            } else if (this.config.screenshotLevels() && (levelMatcher = this.parseLevelUpWidget(WidgetInfo.DIALOG_SPRITE_TEXT)) != null) {
                String skillName = levelMatcher.group(1);
                String skillLevel = levelMatcher.group(2);
                fileName = skillName + "(" + skillLevel + ")";
                screenshotSubDir = "Levels";
                events.add("level_up");
                events.add("ding");
                events.add(skillName);
                if (Integer.parseInt(skillLevel) == 99) {
                    events.add("level99");
                }
            }
        } else if (this.client.getWidget(WidgetInfo.QUEST_COMPLETED_NAME_TEXT) != null) {
            String text = this.client.getWidget(WidgetInfo.QUEST_COMPLETED_NAME_TEXT).getText();
            Matcher m = ScapeCloudPlugin.parseQuestCompletedWidget(text);
            String quest = m.group("quest");
            fileName = this.getQuestFileName(m);
            screenshotSubDir = "Quests";
            CharSequence[] questNameParts = quest.split("-");
            String questName = String.join((CharSequence)"_", questNameParts);
            events.add("quest");
            events.add("quest_" + questName.replaceAll("[\\s/]", "_").replaceAll("['\\.!:]", "").replaceAll("&", "and"));
        }
        if (fileName != null) {
            this.takeScreenshot((String)fileName, screenshotSubDir);
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath actorDeath) {
        Actor actor = actorDeath.getActor();
        if (actor instanceof Player) {
            Player player = (Player)actor;
            if (player == this.client.getLocalPlayer() && this.config.screenshotPlayerDeath()) {
                this.takeScreenshot("Death", SD_DEATHS);
            } else if (player != this.client.getLocalPlayer() && (player.isFriendsChatMember() || player.isFriend()) && this.config.screenshotFriendDeath() && player.getCanvasTilePoly() != null) {
                this.takeScreenshot("Death " + player.getName(), SD_DEATHS);
            }
        }
    }

    @Subscribe
    public void onPlayerLootReceived(PlayerLootReceived playerLootReceived) {
        if (this.config.screenshotKills()) {
            Player player = playerLootReceived.getPlayer();
            String name = player.getName();
            String fileName = "Kill " + name;
            this.takeScreenshot(fileName, SD_PVP_KILLS);
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent e) {
        if (!"confirmFriendsChatKick".equals(e.getEventName())) {
            return;
        }
        String[] stringStack = this.client.getStringStack();
        int stringSize = this.client.getStringStackSize();
        this.kickPlayerName = stringStack[stringSize - 1];
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        int valuableDropValue;
        int regionID;
        String eventName;
        String fileName;
        Matcher m;
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM && event.getType() != ChatMessageType.TRADE && event.getType() != ChatMessageType.FRIENDSCHATNOTIFICATION) {
            return;
        }
        String chatMessage = event.getMessage();
        if (chatMessage.contains("You have completed") && chatMessage.contains("Treasure") && (m = NUMBER_PATTERN.matcher(Text.removeTags((String)chatMessage))).find()) {
            this.clueNumber = Integer.valueOf(m.group());
            this.clueType = chatMessage.substring(chatMessage.lastIndexOf(m.group()) + m.group().length() + 1, chatMessage.indexOf("Treasure") - 1);
            return;
        }
        if (chatMessage.startsWith("Your Barrows chest count is") && (m = NUMBER_PATTERN.matcher(Text.removeTags((String)chatMessage))).find()) {
            this.killType = KillType.BARROWS;
            this.killCountNumber = Integer.valueOf(m.group());
            return;
        }
        if (chatMessage.startsWith("Your completed Chambers of Xeric count is:") && (m = NUMBER_PATTERN.matcher(Text.removeTags((String)chatMessage))).find()) {
            this.killType = KillType.COX;
            this.killCountNumber = Integer.valueOf(m.group());
            return;
        }
        if (chatMessage.startsWith("Your completed Chambers of Xeric Challenge Mode count is:") && (m = NUMBER_PATTERN.matcher(Text.removeTags((String)chatMessage))).find()) {
            this.killType = KillType.COX_CM;
            this.killCountNumber = Integer.valueOf(m.group());
            return;
        }
        if (chatMessage.startsWith("Your completed Theatre of Blood") && (m = NUMBER_PATTERN.matcher(Text.removeTags((String)chatMessage))).find()) {
            this.killType = chatMessage.contains("Hard Mode") ? KillType.TOB_HM : (chatMessage.contains("Story Mode") ? KillType.TOB_SM : KillType.TOB);
            this.killCountNumber = Integer.valueOf(m.group());
            return;
        }
        if (this.config.screenshotKick() && chatMessage.equals("Your request to kick/ban this user was successful.")) {
            if (this.kickPlayerName == null) {
                return;
            }
            this.takeScreenshot("Kick " + this.kickPlayerName, SD_FRIENDS_CHAT_KICKS);
            this.kickPlayerName = null;
        }
        if (this.config.screenshotPet()) {
            if (PET_MESSAGES.stream().anyMatch(chatMessage::contains)) {
                String fileName2 = "Pet";
                this.takeScreenshot(fileName2, SD_PETS);
            }
        }
        if (this.config.screenshotBossKills() && (m = BOSSKILL_MESSAGE_PATTERN.matcher(chatMessage)).matches()) {
            String bossName = m.group(1);
            String bossKillcount = m.group(2);
            fileName = bossName + "(" + bossKillcount + ")";
            this.takeScreenshot(fileName, SD_BOSS_KILLS);
        }
        if (chatMessage.equals(CHEST_LOOTED_MESSAGE) && this.config.screenshotRewards() && (eventName = CHEST_LOOT_EVENTS.get(regionID = this.client.getLocalPlayer().getWorldLocation().getRegionID())) != null) {
            this.takeScreenshot(eventName, SD_CHEST_LOOT);
        }
        if (this.config.screenshotValuableDrop() && (m = VALUABLE_DROP_PATTERN.matcher(chatMessage)).matches() && (valuableDropValue = Integer.parseInt(m.group(2).replaceAll(",", ""))) >= this.config.valuableDropThreshold()) {
            String valuableDropName = m.group(1);
            fileName = "Valuable drop " + valuableDropName;
            this.takeScreenshot(fileName, SD_VALUABLE_DROPS);
        }
        if (this.config.screenshotUntradeableDrop() && !this.isInsideGauntlet() && (m = UNTRADEABLE_DROP_PATTERN.matcher(chatMessage)).matches()) {
            String untradeableDropName = m.group(1);
            String fileName3 = "Untradeable drop " + untradeableDropName;
            this.takeScreenshot(fileName3, SD_UNTRADEABLE_DROPS);
        }
        if (this.config.screenshotDuels() && (m = DUEL_END_PATTERN.matcher(chatMessage)).find()) {
            String result = m.group(1);
            String count = m.group(2);
            fileName = "Duel " + result + " (" + count + ")";
            this.takeScreenshot(fileName, SD_DUELS);
        }
        if (this.config.screenshotCollectionLogEntries() && chatMessage.startsWith(COLLECTION_LOG_TEXT)) {
            String entry = Text.removeTags((String)chatMessage).substring(COLLECTION_LOG_TEXT.length());
            String fileName4 = "Collection log (" + entry + ")";
            this.takeScreenshot(fileName4, SD_COLLECTION_LOG);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        String screenshotSubDir;
        String fileName;
        int groupId = event.getGroupId();
        switch (groupId) {
            case 23: 
            case 73: 
            case 153: 
            case 155: 
            case 539: {
                if (this.config.screenshotRewards()) break;
                return;
            }
            case 233: {
                if (this.config.screenshotLevels()) break;
                return;
            }
            case 193: {
                if (this.config.screenshotLevels() || this.config.screenshotHighGamble()) break;
                return;
            }
            case 616: {
                if (this.config.screenshotKingdom()) break;
                return;
            }
        }
        switch (groupId) {
            case 616: {
                fileName = "Kingdom " + LocalDate.now();
                screenshotSubDir = SD_KINGDOM_REWARDS;
                break;
            }
            case 539: {
                if (this.killType == KillType.COX) {
                    fileName = "Chambers of Xeric(" + this.killCountNumber + ")";
                    screenshotSubDir = SD_BOSS_KILLS;
                    this.killType = null;
                    this.killCountNumber = 0;
                    break;
                }
                if (this.killType == KillType.COX_CM) {
                    fileName = "Chambers of Xeric Challenge Mode(" + this.killCountNumber + ")";
                    screenshotSubDir = SD_BOSS_KILLS;
                    this.killType = null;
                    this.killCountNumber = 0;
                    break;
                }
                return;
            }
            case 23: {
                if (this.killType != KillType.TOB && this.killType != KillType.TOB_SM && this.killType != KillType.TOB_HM) {
                    return;
                }
                switch (this.killType) {
                    case TOB: {
                        fileName = "Theatre of Blood(" + this.killCountNumber + ")";
                        break;
                    }
                    case TOB_SM: {
                        fileName = "Theatre of Blood Story Mode(" + this.killCountNumber + ")";
                        break;
                    }
                    case TOB_HM: {
                        fileName = "Theatre of Blood Hard Mode(" + this.killCountNumber + ")";
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                screenshotSubDir = SD_BOSS_KILLS;
                this.killType = null;
                this.killCountNumber = 0;
                break;
            }
            case 155: {
                if (this.killType != KillType.BARROWS) {
                    return;
                }
                fileName = "Barrows(" + this.killCountNumber + ")";
                screenshotSubDir = SD_BOSS_KILLS;
                this.killType = null;
                this.killCountNumber = 0;
                break;
            }
            case 153: 
            case 193: 
            case 233: {
                this.shouldTakeScreenshot = true;
                return;
            }
            case 73: {
                if (this.clueType == null || this.clueNumber == null) {
                    return;
                }
                fileName = Character.toUpperCase(this.clueType.charAt(0)) + this.clueType.substring(1) + "(" + this.clueNumber + ")";
                screenshotSubDir = SD_CLUE_SCROLL_REWARDS;
                this.clueType = null;
                this.clueNumber = null;
                break;
            }
            default: {
                return;
            }
        }
        this.takeScreenshot(fileName, screenshotSubDir);
    }

    private void manualScreenshot() {
        long delta = System.currentTimeMillis() - this.lastManualScreenshot;
        if (delta >= 200L) {
            this.takeScreenshot("", null);
            this.lastManualScreenshot = System.currentTimeMillis();
        } else if (this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
            this.clientThread.invokeLater(() -> {
                String message = new ChatMessageBuilder().append(Color.RED, "You are uploading images too quickly, please wait " + (200L - delta) + "ms.").build();
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, null);
            });
        }
    }

    Matcher parseLevelUpWidget(WidgetInfo levelUpLevel) {
        Widget levelChild = this.client.getWidget(levelUpLevel);
        if (levelChild == null) {
            return null;
        }
        Matcher m = LEVEL_UP_PATTERN.matcher(levelChild.getText());
        if (!m.matches()) {
            return null;
        }
        return m;
    }

    @VisibleForTesting
    static Matcher parseQuestCompletedWidget(String text) {
        Matcher questMatch1 = QUEST_PATTERN_1.matcher(text);
        Matcher questMatch2 = QUEST_PATTERN_2.matcher(text);
        Matcher questMatchFinal = questMatch1.matches() ? questMatch1 : questMatch2;
        return questMatchFinal;
    }

    String getQuestFileName(Matcher m) {
        String verb;
        Object quest = m.group("quest");
        String string = verb = m.group("verb") != null ? m.group("verb") : "";
        if (!m.matches()) {
            return "Quest(quest not found)";
        }
        if (verb.contains("kind of")) {
            quest = (String)quest + " partial completion";
        } else if (verb.contains("completely")) {
            quest = (String)quest + " II";
        }
        if (RFD_TAGS.stream().anyMatch(((String)quest + verb)::contains)) {
            quest = "Recipe for Disaster - " + (String)quest;
        }
        if (WORD_QUEST_IN_NAME_TAGS.stream().anyMatch(((String)quest)::contains)) {
            quest = (String)quest + " Quest";
        }
        return "Quest(" + (String)quest + ")";
    }

    @VisibleForTesting
    static String parseBAHighGambleWidget(String text) {
        Matcher highGambleMatch = BA_HIGH_GAMBLE_REWARD_PATTERN.matcher(text);
        if (highGambleMatch.find()) {
            String gambleCount = highGambleMatch.group("gambleCount");
            return String.format("High Gamble(%s)", gambleCount);
        }
        return "High Gamble(count not found)";
    }

    private void takeScreenshot(String fileName, String subDir) {
        if (this.client.getGameState() == GameState.LOGIN_SCREEN) {
            log.info("Login screenshot prevented");
            return;
        }
        Consumer<Image> imageCallback = img -> this.executor.submit(() -> this.takeScreenshot(fileName, subDir, (Image)img));
        if (this.config.displayDate() && REPORT_BUTTON_TLIS.contains(this.client.getTopLevelInterfaceId())) {
            this.screenshotOverlay.queueForTimestamp(imageCallback);
        } else {
            this.drawManager.requestNextFrameListener(imageCallback);
        }
    }

    private void takeScreenshot(String fileName, String subDir, Image image) {
        BufferedImage screenshot = this.config.includeFrame() ? new BufferedImage(this.clientUi.getWidth(), this.clientUi.getHeight(), 2) : new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics graphics = screenshot.getGraphics();
        int gameOffsetX = 0;
        int gameOffsetY = 0;
        if (this.config.includeFrame()) {
            try {
                SwingUtilities.invokeAndWait(() -> this.clientUi.paint(graphics));
            }
            catch (InterruptedException | InvocationTargetException e) {
                log.warn("unable to paint client UI on screenshot", (Throwable)e);
            }
            Point canvasOffset = this.clientUi.getCanvasOffset();
            gameOffsetX = canvasOffset.getX();
            gameOffsetY = canvasOffset.getY();
        }
        graphics.drawImage(image, gameOffsetX, gameOffsetY, null);
        this.imageCapture.takeScreenshot(screenshot, fileName, subDir, this.config.notifyWhenTaken());
    }

    private boolean isInsideGauntlet() {
        return this.client.isInInstancedRegion() && this.client.getMapRegions().length > 0 && (this.client.getMapRegions()[0] == 7512 || this.client.getMapRegions()[0] == 7768);
    }

    @VisibleForTesting
    int getClueNumber() {
        return this.clueNumber;
    }

    @VisibleForTesting
    String getClueType() {
        return this.clueType;
    }

    @VisibleForTesting
    KillType getKillType() {
        return this.killType;
    }

    @VisibleForTesting
    int getKillCountNumber() {
        return this.killCountNumber;
    }

    BufferedImage getReportButton() {
        return this.reportButton;
    }

    static enum KillType {
        BARROWS,
        COX,
        COX_CM,
        TOB,
        TOB_SM,
        TOB_HM;

    }
}

