/*
 * Decompiled with CFR 0.152.
 */
package scapecloud.runelite;

import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import scapecloud.runelite.ScapeCloudAPI;
import scapecloud.runelite.ScapeCloudPlugin;

@Singleton
public class ScapeCloudLogin {
    @Inject
    private ConfigManager manager;
    @Inject
    private ScapeCloudAPI api;
    @Inject
    private ScapeCloudPlugin plugin;
    private JFrame frame;
    private JTextField emailField;
    private JPasswordField passwordField;
    private boolean initialized = false;

    public void display() {
        if (!this.initialized) {
            this.initialize();
        }
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    private void initialize() {
        this.frame = new JFrame("OSRSLog Login");
        this.frame.setSize(300, 300);
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(1);
        this.frame.setIconImage(ImageUtil.loadImageResource(this.getClass(), (String)"scapecloud_icon.png"));
        JLabel emailLabel = new JLabel("Email:");
        emailLabel.setBounds(20, 10, 75, 30);
        this.emailField = new JTextField();
        this.emailField.setBounds(20, 40, 250, 30);
        JLabel passLabel = new JLabel("Password:");
        passLabel.setBounds(20, 75, 75, 30);
        this.passwordField = new JPasswordField();
        this.passwordField.setBounds(20, 105, 250, 30);
        JButton loginButton = new JButton("Log In");
        loginButton.setBounds(75, 160, 150, 30);
        JButton createButton = new JButton("Sign Up");
        createButton.setBounds(75, 210, 150, 30);
        createButton.addActionListener(this::create);
        loginButton.addActionListener(this::login);
        this.frame.getContentPane().setLayout(null);
        this.frame.getContentPane().add(emailLabel);
        this.frame.getContentPane().add(this.emailField);
        this.frame.getContentPane().add(passLabel);
        this.frame.getContentPane().add(this.passwordField);
        this.frame.getContentPane().add(loginButton);
        this.frame.getContentPane().add(createButton);
        this.initialized = true;
    }

    private void create(ActionEvent e) {
        LinkBrowser.browse((String)"https://osrslog.com/sign-up");
    }

    private void login(ActionEvent e) {
        if (this.emailField.getText().length() > 0 && this.passwordField.getPassword().length > 0) {
            String email = this.emailField.getText();
            String password = new String(this.passwordField.getPassword());
            this.api.authenticate(email, password, () -> {
                this.manager.setConfiguration("scape-cloud", "email", email);
                this.manager.setConfiguration("scape-cloud", "password", password);
                JOptionPane.showMessageDialog(this.frame, "Login Successful", "ScapeCloud Login", 1);
                this.frame.setVisible(false);
                this.emailField.setText("");
                this.passwordField.setText("");
                this.plugin.addAndRemoveButtons();
            });
        }
    }

    public void logout() {
        if (0 == JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to log out from OSRSLog?", "OSRSLog Logout", 0)) {
            this.api.logout();
            this.manager.setConfiguration("scape-cloud", "email", "");
            this.manager.setConfiguration("scape-cloud", "password", "");
            this.plugin.addAndRemoveButtons();
        }
    }
}

