/*
 * Decompiled with CFR 0.152.
 */
package scapecloud.runelite;

import com.google.common.base.Strings;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.WorldType;
import net.runelite.client.Notifier;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scapecloud.runelite.ScapeCloudAPI;
import scapecloud.runelite.api.Image;

@Singleton
public class ScapeCloudImageCapture {
    private static final Logger log = LoggerFactory.getLogger(ScapeCloudImageCapture.class);
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Notifier notifier;
    @Inject
    private ScapeCloudAPI api;

    public void takeScreenshot(BufferedImage screenshot, String fileName, @Nullable String subDir, boolean notify) {
        if (this.client.getGameState() == GameState.LOGIN_SCREEN) {
            log.info("Login screenshot prevented");
            return;
        }
        File playerFolder = RuneLite.SCREENSHOT_DIR;
        if (this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getName() != null) {
            EnumSet worldTypes = this.client.getWorldType();
            Object playerDir = this.client.getLocalPlayer().getName();
            if (worldTypes.contains(WorldType.DEADMAN)) {
                playerDir = (String)playerDir + "-Deadman";
            }
            if (!Strings.isNullOrEmpty((String)subDir)) {
                playerDir = (String)playerDir + File.separator + subDir;
            }
            playerFolder = new File(RuneLite.SCREENSHOT_DIR, (String)playerDir);
        }
        playerFolder.mkdirs();
        fileName = (String)fileName + (((String)fileName).isEmpty() ? "" : " ") + ScapeCloudImageCapture.format(new Date());
        try {
            File screenshotFile = new File(playerFolder, (String)fileName + ".png");
            int i = 1;
            while (screenshotFile.exists()) {
                screenshotFile = new File(playerFolder, (String)fileName + String.format("(%d)", i++) + ".png");
            }
            ImageIO.write((RenderedImage)screenshot, "PNG", screenshotFile);
            if (this.api.isAuthenticated()) {
                String name = screenshotFile.getName();
                byte[] bytes = Files.readAllBytes(screenshotFile.toPath());
                this.clientThread.invokeLater(() -> this.api.upload(new Image(name, bytes), notify));
            } else if (notify) {
                this.notifier.notify("A screenshot was saved to " + screenshotFile, TrayIcon.MessageType.INFO);
            }
        }
        catch (IOException ex) {
            log.warn("error writing screenshot", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String format(Date date) {
        DateFormat dateFormat = TIME_FORMAT;
        synchronized (dateFormat) {
            return TIME_FORMAT.format(date);
        }
    }
}

