/*
 * Decompiled with CFR 0.152.
 */
package scapecloud.runelite;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Keybind;

@ConfigGroup(value="scape-cloud")
public interface ScapeCloudConfig
extends Config {
    @ConfigSection(name="What to Screenshot", description="All the options that select what to screenshot", position=5)
    public static final String whatSection = "what";

    @ConfigItem(keyName="includeFrame", name="Include Client Frame", description="Configures whether or not the client frame is included in screenshots", position=1)
    default public boolean includeFrame() {
        return false;
    }

    @ConfigItem(keyName="displayDate", name="Display Date", description="Configures whether or not the report button shows the date the screenshot was taken", position=2)
    default public boolean displayDate() {
        return true;
    }

    @ConfigItem(keyName="notifyWhenTaken", name="Notify When Taken", description="Configures whether or not you are notified when a screenshot has been taken", position=3)
    default public boolean notifyWhenTaken() {
        return true;
    }

    @ConfigItem(keyName="hotkey", name="Screenshot hotkey", description="When you press this key a screenshot will be taken", position=4)
    default public Keybind hotkey() {
        return Keybind.NOT_SET;
    }

    @ConfigItem(keyName="rewards", name="Screenshot Rewards", description="Configures whether screenshots are taken of clues, barrows, and quest completion", position=6, section="what")
    default public boolean screenshotRewards() {
        return true;
    }

    @ConfigItem(keyName="levels", name="Screenshot Levels", description="Configures whether screenshots are taken of level ups", position=7, section="what")
    default public boolean screenshotLevels() {
        return true;
    }

    @ConfigItem(keyName="kingdom", name="Screenshot Kingdom Reward", description="Configures whether screenshots are taken of Kingdom Reward", position=8, section="what")
    default public boolean screenshotKingdom() {
        return true;
    }

    @ConfigItem(keyName="pets", name="Screenshot Pet", description="Configures whether screenshots are taken of receiving pets", position=9, section="what")
    default public boolean screenshotPet() {
        return true;
    }

    @ConfigItem(keyName="kills", name="Screenshot PvP Kills", description="Configures whether or not screenshots are automatically taken of PvP kills", position=10, section="what")
    default public boolean screenshotKills() {
        return false;
    }

    @ConfigItem(keyName="boss", name="Screenshot Boss Kills", description="Configures whether or not screenshots are automatically taken of boss kills", position=11, section="what")
    default public boolean screenshotBossKills() {
        return false;
    }

    @ConfigItem(keyName="playerDeath", name="Screenshot Deaths", description="Configures whether or not screenshots are automatically taken when you die.", position=12, section="what")
    default public boolean screenshotPlayerDeath() {
        return false;
    }

    @ConfigItem(keyName="friendDeath", name="Screenshot Friend Deaths", description="Configures whether or not screenshots are automatically taken when friends or friends chat members die.", position=13, section="what")
    default public boolean screenshotFriendDeath() {
        return false;
    }

    @ConfigItem(keyName="duels", name="Screenshot Duels", description="Configures whether or not screenshots are automatically taken of the duel end screen.", position=14, section="what")
    default public boolean screenshotDuels() {
        return false;
    }

    @ConfigItem(keyName="valuableDrop", name="Screenshot Valuable drops", description="Configures whether or not screenshots are automatically taken when you receive a valuable drop.", position=15, section="what")
    default public boolean screenshotValuableDrop() {
        return false;
    }

    @ConfigItem(keyName="valuableDropThreshold", name="Valuable Threshold", description="The minimum value to save screenshots of valuable drops.", position=16, section="what")
    default public int valuableDropThreshold() {
        return 0;
    }

    @ConfigItem(keyName="untradeableDrop", name="Screenshot Untradeable drops", description="Configures whether or not screenshots are automatically taken when you receive an untradeable drop.", position=17, section="what")
    default public boolean screenshotUntradeableDrop() {
        return false;
    }

    @ConfigItem(keyName="ccKick", name="Screenshot Kicks from FC", description="Take a screenshot when you kick a user from a friends chat.", position=18, section="what")
    default public boolean screenshotKick() {
        return false;
    }

    @ConfigItem(keyName="baHighGamble", name="Screenshot BA high gambles", description="Take a screenshot of your reward from a high gamble at Barbarian Assault.", position=19, section="what")
    default public boolean screenshotHighGamble() {
        return false;
    }

    @ConfigItem(keyName="collectionLogEntries", name="Screenshot collection log entries", description="Take a screenshot when completing an entry in the collection log", position=20, section="what")
    default public boolean screenshotCollectionLogEntries() {
        return true;
    }

    @ConfigItem(keyName="email", name="Email", description="Email for Scape Cloud Service", hidden=true, position=21)
    default public String email() {
        return "";
    }

    @ConfigItem(keyName="password", name="Password", description="Password for Scape Cloud Service", secret=true, hidden=true, position=22)
    default public String password() {
        return "";
    }
}

