/*
 * Decompiled with CFR 0.152.
 */
package scapecloud.runelite;

import com.google.gson.Gson;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageBuilder;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scapecloud.runelite.ScapeCloudPlugin;
import scapecloud.runelite.api.AuthError;
import scapecloud.runelite.api.Authorization;
import scapecloud.runelite.api.Credentials;
import scapecloud.runelite.api.Image;
import scapecloud.runelite.api.ItemInfo;
import scapecloud.runelite.api.Link;
import scapecloud.runelite.api.Metadata;
import scapecloud.runelite.api.NearbyPlayer;
import scapecloud.runelite.api.Refresh;
import scapecloud.runelite.api.SkillInfo;
import scapecloud.runelite.api.UploadError;

@Singleton
class ScapeCloudAPI {
    private static final Logger log = LoggerFactory.getLogger(ScapeCloudAPI.class);
    private static final String FIREBASE_AUTH = "https://identitytoolkit.googleapis.com/v1/accounts:signInWithPassword?key=AIzaSyD64AKzvmmEiFkn-4U5X54D24He813qCjk";
    private static final String FIREBASE_REFRESH = "https://securetoken.googleapis.com/v1/token?key=AIzaSyD64AKzvmmEiFkn-4U5X54D24He813qCjk";
    private static final String OSRSLOG_UPLOAD = "https://www.osrslog.com/api/upload";
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType PNG = MediaType.parse((String)"image/png");
    private static final Gson GSON = new Gson();
    private static final int REFRESH_OFFSET = (int)TimeUnit.MINUTES.toSeconds(5L);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Notifier notifier;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private ScapeCloudPlugin plugin;
    private final AtomicReference<String> idToken = new AtomicReference();
    private final AtomicReference<String> refreshToken = new AtomicReference();
    private ScheduledFuture<?> refreshTask;

    ScapeCloudAPI() {
    }

    public boolean isAuthenticated() {
        return this.idToken.get() != null;
    }

    public void logout() {
        this.idToken.set(null);
        this.refreshToken.set(null);
        if (this.refreshTask != null) {
            this.refreshTask.cancel(false);
            this.refreshTask = null;
        }
    }

    public void authenticate(String email, String password, Runnable success) {
        Request request = new Request.Builder().url(FIREBASE_AUTH).post(RequestBody.create((MediaType)JSON, (String)GSON.toJson((Object)new Credentials(email, password)))).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            String json = response.body().string();
            if (response.isSuccessful()) {
                Authorization auth = (Authorization)GSON.fromJson(json, Authorization.class);
                this.idToken.set(auth.getIdToken());
                this.refreshToken.set(auth.getRefreshToken());
                this.refreshTask = this.executor.schedule(this::reauthenticate, (long)(auth.getExpiresIn() - REFRESH_OFFSET), TimeUnit.SECONDS);
                success.run();
            } else {
                AuthError error = (AuthError)GSON.fromJson(json, AuthError.class);
                log.error("Error occurred while authenticating with OSRSLog. " + error.getError().getMessage());
                this.message("OSRSLog Auth", "Error occurred while authenticating to OSRSLog.");
            }
        }
        catch (IOException e) {
            log.error("Exception occurred while authenticating with OSRSLog.", (Throwable)e);
            this.message("OSRSLog Auth", "Exception occurred while authenticating to OSRSLog.");
        }
    }

    public void reauthenticate() {
        FormBody body = new FormBody.Builder().add("grant_type", "refresh_token").add("refresh_token", this.refreshToken.get()).build();
        Request request = new Request.Builder().url(FIREBASE_REFRESH).post((RequestBody)body).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            String json = response.body().string();
            if (response.isSuccessful()) {
                Refresh refresh = (Refresh)GSON.fromJson(json, Refresh.class);
                this.idToken.set(refresh.getIdToken());
                this.refreshToken.set(refresh.getRefreshToken());
                this.refreshTask = this.executor.schedule(this::reauthenticate, (long)(refresh.getExpiresIn() - REFRESH_OFFSET), TimeUnit.SECONDS);
            } else {
                AuthError error = (AuthError)GSON.fromJson(json, AuthError.class);
                log.error("Error occurred while re-authenticating with OSRSLog, " + error.getError().getMessage());
                this.message("OSRSLog Re-auth", "Error occurred while re-authenticating to OSRSLog.");
                this.logout();
                this.plugin.addAndRemoveButtons();
            }
        }
        catch (IOException e) {
            log.error("Exception occurred while re-authenticating with OSRSLog.", (Throwable)e);
            this.message("OSRSLog Re-auth", "Exception occurred while re-authenticating to OSRSLog.");
        }
    }

    public void upload(Image image, final boolean notify) {
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", image.getName(), RequestBody.create((MediaType)PNG, (byte[])image.getFile())).addFormDataPart("metadata", this.createMetadata()).build();
        Request request = new Request.Builder().url(OSRSLOG_UPLOAD).header("Authorization", "Bearer " + this.idToken.get()).post((RequestBody)body).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.error("Exception occurred while uploading to OSRSLog.", (Throwable)e);
                ScapeCloudAPI.this.message("OSRSLog Upload", "Exception occurred while uploading to OSRSLog.");
            }

            public void onResponse(Call call, Response response) throws IOException {
                String body = response.body().string();
                if (response.isSuccessful()) {
                    Link link = (Link)GSON.fromJson(body, Link.class);
                    StringSelection selection = new StringSelection(link.getData());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, selection);
                    if (notify) {
                        ScapeCloudAPI.this.notifier.notify("A screenshot was uploaded and inserted into your clipboard!", TrayIcon.MessageType.INFO);
                    }
                    ScapeCloudAPI.this.message("OSRSLog Upload", "A screenshot was uploaded and inserted into your clipboard!");
                } else {
                    UploadError error = (UploadError)GSON.fromJson(body, UploadError.class);
                    log.error("Error occurred while uploading to OSRSLog. " + error.getMessage());
                    ScapeCloudAPI.this.message("OSRSLog Upload", "Error occurred while uploading to OSRSLog.");
                }
            }
        });
    }

    private void message(String title, String message) {
        if (this.idToken.get() == null || !this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, message, title, 0));
        } else {
            this.clientThread.invokeLater(() -> this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", new ChatMessageBuilder().append(Color.RED, message).build(), null));
        }
    }

    private String createMetadata() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return "";
        }
        Skill[] skillNames = Skill.values();
        List players = this.client.getPlayers();
        int[] boostedLevels = this.client.getBoostedSkillLevels();
        int[] exp = this.client.getSkillExperiences();
        int[] levels = this.client.getRealSkillLevels();
        WorldPoint pos = player.getWorldLocation();
        String skullIcon = player.getSkullIcon() != null ? player.getSkullIcon().name() : "";
        List<NearbyPlayer> nearby = players.stream().filter(p -> !p.equals(player)).map(NearbyPlayer::new).collect(Collectors.toList());
        String eventType = "NOT_IMPLEMENTED";
        List<SkillInfo> skills = IntStream.range(0, skillNames.length).mapToObj(i -> new SkillInfo(skillNames[i].getName(), boostedLevels[i], levels[i], exp[i])).collect(Collectors.toList());
        ArrayList<ItemInfo> equipment = new ArrayList<ItemInfo>();
        ItemContainer equipmentContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipmentContainer != null) {
            Arrays.stream(equipmentContainer.getItems()).map(item -> new ItemInfo(this.client.getItemDefinition(item.getId()), item.getQuantity())).forEachOrdered(equipment::add);
        }
        ArrayList<ItemInfo> inventory = new ArrayList<ItemInfo>();
        ItemContainer inventoryContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (inventoryContainer != null) {
            Arrays.stream(inventoryContainer.getItems()).map(item -> new ItemInfo(this.client.getItemDefinition(item.getId()), item.getQuantity())).forEachOrdered(inventory::add);
        }
        return GSON.toJson((Object)new Metadata(player.getName(), this.client.getAccountType().name(), skullIcon, eventType, nearby, this.client.getWorldType(), Arrays.asList(pos.getX(), pos.getY(), pos.getPlane()), player.getCombatLevel(), this.client.getWorld(), this.client.getTotalLevel(), this.client.getAccountType().isIronman(), equipment, inventory, skills));
    }
}

