/*
 * Decompiled with CFR 0.152.
 */
package com.globalfkeys;

import com.globalfkeys.FKey;
import com.globalfkeys.GlobalFKeysConfig;
import com.globalfkeys.GlobalFKeysKeyListener;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.WidgetNode;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Global F Keys")
public class GlobalFKeysPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GlobalFKeysPlugin.class);
    static final int COMBAT_TAB_BINDING = 4675;
    static final int SKILLS_TAB_BINDING = 4676;
    static final int QUESTS_TAB_BINDING = 4677;
    static final int INVENTORY_TAB_BINDING = 4678;
    static final int EQUIPMENT_TAB_BINDING = 4679;
    static final int PRAYER_TAB_BINDING = 4680;
    static final int MAGIC_TAB_BINDING = 4682;
    static final int FRIENDS_TAB_BINDING = 4684;
    static final int ACCOUNT_MANAGEMENT_TAB_BINDING = 6517;
    static final int LOGOUT_BINDING = 4689;
    static final int SETTINGS_TAB_BINDING = 4686;
    static final int EMOTE_TAB_BINDING = 4687;
    static final int CHAT_CHANNEL_TAB_BINDING = 4683;
    static final int MUSIC_PLAYER_TAB_BINDING = 4688;
    private static final Set<Integer> VARBITS = ImmutableSet.of((Object)4675, (Object)4676, (Object)4677, (Object)4678, (Object)4679, (Object)4680, (Object[])new Integer[]{4682, 4684, 6517, 4689, 4686, 4687, 4683, 4688});
    @Inject
    private Client client;
    @Inject
    private GlobalFKeysConfig config;
    @Inject
    private KeyManager keyManager;
    @Inject
    private GlobalFKeysKeyListener inputListener;
    @Inject
    private ConfigManager configManager;
    private boolean shouldNotRemapEscape;
    private final Map<Integer, FKey> fkeyVarbitToKey = new HashMap<Integer, FKey>();

    protected void startUp() throws Exception {
        this.keyManager.registerKeyListener((KeyListener)this.inputListener);
        this.configManager.getConfigurationKeys("globalKeybinds").forEach(key -> {
            if (!key.endsWith("Key")) {
                String rawKey = key.split("\\.", 2)[1];
                this.configManager.unsetConfiguration("globalKeybinds", rawKey);
            }
        });
    }

    protected void shutDown() throws Exception {
        this.keyManager.unregisterKeyListener((KeyListener)this.inputListener);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        VARBITS.forEach(varbit -> {
            int varbitVal = this.client.getVarbitValue(varbit.intValue());
            FKey existingValue = this.fkeyVarbitToKey.get(varbit);
            FKey newValue = FKey.VARBIT_TO_FKEY.get(varbitVal);
            if (existingValue == null || existingValue != newValue) {
                this.fkeyVarbitToKey.put((Integer)varbit, newValue);
                log.debug("Storing FKey value {} for varbit {}", (Object)varbitVal, varbit);
            }
        });
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("globalKeybinds")) {
            log.debug("Checking for mutual exclusivity on config changed: {}", (Object)configChanged);
            String fkeyValue = configChanged.getNewValue();
            for (String key : this.configManager.getConfigurationKeys("globalKeybinds")) {
                String configValue;
                String rawKey = key.split("\\.", 2)[1];
                if (rawKey.equals(configChanged.getKey()) || !fkeyValue.equals(configValue = this.configManager.getConfiguration("globalKeybinds", rawKey))) continue;
                this.configManager.setConfiguration("globalKeybinds", rawKey, (Object)FKey.NONE);
                log.debug("Setting config for {} to NONE", (Object)rawKey);
            }
        }
    }

    @Subscribe
    private void onGameTick(GameTick gameTick) {
        boolean modalOpen = false;
        for (WidgetNode node : this.client.getComponentTable()) {
            if (node.getModalMode() == 1) continue;
            modalOpen = true;
        }
        this.shouldNotRemapEscape = modalOpen;
    }

    @Provides
    GlobalFKeysConfig provideConfig(ConfigManager configManager) {
        return (GlobalFKeysConfig)configManager.getConfig(GlobalFKeysConfig.class);
    }

    boolean isDialogOpen() {
        return this.isHidden(WidgetInfo.CHATBOX_MESSAGES) || this.isHidden(WidgetInfo.CHATBOX_TRANSPARENT_LINES) || !this.isHidden(WidgetInfo.BANK_PIN_CONTAINER);
    }

    boolean isOptionsDialogOpen() {
        return this.client.getWidget(WidgetInfo.DIALOG_OPTION) != null;
    }

    private boolean isHidden(WidgetInfo widgetInfo) {
        Widget w = this.client.getWidget(widgetInfo);
        return w == null || w.isSelfHidden();
    }

    boolean chatboxFocused() {
        Widget chatboxParent = this.client.getWidget(WidgetInfo.CHATBOX_PARENT);
        if (chatboxParent == null || chatboxParent.getOnKeyListener() == null) {
            return false;
        }
        Widget worldMapSearch = this.client.getWidget(WidgetInfo.WORLD_MAP_SEARCH);
        return worldMapSearch == null || this.client.getVarcIntValue(190) != 1;
    }

    boolean isWorldMapOpen() {
        return !this.isHidden(WidgetInfo.WORLD_MAP_VIEW) || !this.isHidden(WidgetInfo.WORLD_MAP_OVERVIEW_MAP);
    }

    boolean isShouldNotRemapEscape() {
        return this.shouldNotRemapEscape;
    }

    Map<Integer, FKey> getFkeyVarbitToKey() {
        return this.fkeyVarbitToKey;
    }
}

