/*
 * Decompiled with CFR 0.152.
 */
package com.rseye.io;

import com.google.gson.Gson;
import com.rseye.ConnectorConfig;
import com.rseye.util.Postable;
import java.io.IOException;
import java.util.UUID;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.annotations.EverythingIsNonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler {
    public static final Logger log = LoggerFactory.getLogger(RequestHandler.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient client;
    private final Gson gson;
    private final ConnectorConfig config;

    public RequestHandler(OkHttpClient client, Gson gson, ConnectorConfig config) {
        this.client = client;
        this.gson = gson;
        this.config = config;
    }

    public <T extends Postable> void submit(final T update) {
        Request request = new Request.Builder().url(this.config.baseEndpoint() + update.endpoint().location).header("Authorization", "Bearer: " + this.config.bearerToken()).header("X-Request-Id", UUID.randomUUID().toString()).post(RequestBody.create((MediaType)JSON, (String)this.gson.toJson(update))).build();
        this.client.newCall(request).enqueue(new Callback(){

            @EverythingIsNonNull
            public void onResponse(Call call, Response response) {
                log.debug("Call response: Endpoint: {}, Contents: {}", (Object)update.endpoint().ordinal(), (Object)(response.body() != null ? response.body().toString() : ""));
                response.close();
            }

            @EverythingIsNonNull
            public void onFailure(Call call, IOException e) {
                log.debug("Issue detected while posting to endpoint: {}", (Object)e.getMessage());
            }
        });
    }

    public static enum Endpoint {
        POSITION_UPDATE("position_update/"),
        LOGIN_UPDATE("login_update/"),
        STAT_UPDATE("stat_update/"),
        QUEST_UPDATE("quest_update/"),
        BANK_UPDATE("bank_update/"),
        LOOT_UPDATE("loot_update/"),
        INVENTORY_UPDATE("inventory_update/"),
        EQUIPMENT_UPDATE("equipment_update/"),
        DEATH_UPDATE("death_update/"),
        OVERHEAD_UPDATE("overhead_update/"),
        SKULL_UPDATE("skull_update/");

        public final String location;

        private Endpoint(String location) {
            this.location = location;
        }
    }
}

