/*
 * Decompiled with CFR 0.152.
 */
package com.rseye;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.rseye.ConnectorConfig;
import com.rseye.io.RequestHandler;
import com.rseye.update.BankUpdate;
import com.rseye.update.DeathUpdate;
import com.rseye.update.EquipmentUpdate;
import com.rseye.update.InventoryUpdate;
import com.rseye.update.LoginUpdate;
import com.rseye.update.LootUpdate;
import com.rseye.update.OverheadUpdate;
import com.rseye.update.PositionUpdate;
import com.rseye.update.QuestUpdate;
import com.rseye.update.SkullUpdate;
import com.rseye.update.StatUpdate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.Quest;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.StatChanged;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="rseye-connector")
public class ConnectorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ConnectorPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private Gson gson;
    @Inject
    private ConnectorConfig config;
    @Inject
    private ItemManager itemManager;
    private AtomicInteger ticks = new AtomicInteger(0);
    private RequestHandler requestHandler;
    private GameState gameState = GameState.UNKNOWN;
    private Player player;
    private PositionUpdate lastPositionUpdate;
    private CopyOnWriteArrayList<StatChanged> lastStatUpdate;
    private CopyOnWriteArrayList<QuestUpdate.Quest> lastQuestStateUpdate;
    private ConcurrentHashMap<Integer, QuestUpdate.Quest> questStates;
    private ItemContainer lastBankState;
    private OverheadUpdate lastOverheadState;
    private SkullUpdate lastSkullState;
    private boolean isBankOpen = false;

    protected void startUp() {
        log.info("rseye-connector started!");
        this.ticks = new AtomicInteger(0);
        this.requestHandler = new RequestHandler(this.okHttpClient, this.gson, this.config);
        this.lastStatUpdate = new CopyOnWriteArrayList();
        this.lastQuestStateUpdate = new CopyOnWriteArrayList();
        this.questStates = new ConcurrentHashMap();
        this.lastOverheadState = new OverheadUpdate("", null);
        this.lastSkullState = new SkullUpdate("", null);
    }

    protected void shutDown() {
        log.info("rseye-connector stopped!");
        this.ticks = null;
        this.requestHandler = null;
        this.gameState = GameState.UNKNOWN;
        this.lastStatUpdate = null;
        this.lastQuestStateUpdate = null;
        this.questStates = null;
        this.lastOverheadState = null;
        this.lastSkullState = null;
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.playerIsNull() || this.gameState != GameState.LOGGED_IN) {
            return;
        }
        if (this.ticks.get() % this.config.positionDataFrequency() == 0) {
            this.processPositionUpdate();
        }
        if (this.ticks.get() % this.config.overheadDataFrequency() == 0) {
            this.processOverheadUpdate();
        }
        if (this.ticks.get() % this.config.skullDataFrequency() == 0) {
            this.processSkullUpdate();
        }
        this.processStatUpdate();
        this.processQuestUpdate();
        this.processBankUpdate();
        this.ticks.set(this.ticks.get() > 144000 ? 0 : this.ticks.get() + 1);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gsc) {
        this.gameState = gsc.getGameState();
        if (this.gameState == GameState.LOGIN_SCREEN) {
            this.ticks.set(0);
            this.player = null;
            this.questStates = new ConcurrentHashMap();
            return;
        }
        if (this.gameState == GameState.LOGGED_IN) {
            this.ticks.set(0);
            this.player = this.client.getLocalPlayer();
            this.questStates = new ConcurrentHashMap();
            return;
        }
        if (this.playerIsNull() || !this.config.loginData()) {
            return;
        }
        this.requestHandler.submit(new LoginUpdate(this.player.getName(), gsc.getGameState()));
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        this.lastStatUpdate.add(statChanged);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (itemContainerChanged.getItemContainer() == this.client.getItemContainer(InventoryID.INVENTORY)) {
            this.processInventoryUpdate(itemContainerChanged);
            return;
        }
        if (itemContainerChanged.getItemContainer() == this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            this.processEquipmentUpdate(itemContainerChanged);
            return;
        }
        if (this.playerIsNull() || !this.config.lootData()) {
            return;
        }
        if (itemContainerChanged.getItemContainer() == this.client.getItemContainer(itemContainerChanged.getContainerId())) {
            LootUpdate lootUpdate = new LootUpdate(this.player.getName(), itemContainerChanged.getContainerId(), itemContainerChanged.getItemContainer());
            if (lootUpdate.getItems().size() < 1) {
                return;
            }
            this.requestHandler.submit(lootUpdate);
        }
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        if (this.playerIsNull() || !this.config.lootData()) {
            return;
        }
        this.requestHandler.submit(new LootUpdate(this.player.getName(), npcLootReceived));
    }

    @Subscribe
    public void onPlayerLootReceived(PlayerLootReceived playerLootReceived) {
        if (this.playerIsNull() || !this.config.lootData()) {
            return;
        }
        this.requestHandler.submit(new LootUpdate(this.player.getName(), playerLootReceived));
    }

    @Subscribe
    public void onActorDeath(ActorDeath actorDeath) {
        if (this.playerIsNull() || !this.config.deathData()) {
            return;
        }
        if (actorDeath.getActor().getName() != null && actorDeath.getActor().getName().equals(this.player.getName())) {
            this.requestHandler.submit(new DeathUpdate(this.player.getName()));
        }
    }

    private void processPositionUpdate() {
        if (this.playerIsNull() || !this.config.positionData()) {
            return;
        }
        if (this.lastPositionUpdate == null || !this.player.getWorldLocation().equals((Object)this.lastPositionUpdate.getPosition())) {
            this.lastPositionUpdate = new PositionUpdate(this.player.getName(), this.player.getWorldLocation());
            this.requestHandler.submit(this.lastPositionUpdate);
        }
    }

    private void processStatUpdate() {
        if (this.playerIsNull() || !this.config.statsData()) {
            this.lastStatUpdate.clear();
            return;
        }
        if (!this.lastStatUpdate.isEmpty()) {
            this.requestHandler.submit(new StatUpdate(this.player.getName(), this.player.getCombatLevel(), this.lastStatUpdate));
            this.lastStatUpdate.clear();
        }
    }

    private void processQuestUpdate() {
        if (this.playerIsNull() || !this.config.questData()) {
            return;
        }
        for (Quest quest : Quest.values()) {
            QuestUpdate.Quest existingObject = this.questStates.getOrDefault(quest.getId(), null);
            QuestUpdate.Quest newObject = new QuestUpdate.Quest(quest.getId(), quest.getName(), quest.getState(this.client));
            if (existingObject != null && existingObject.getState().equals((Object)newObject.getState())) continue;
            this.questStates.put(quest.getId(), newObject);
            this.lastQuestStateUpdate.add(newObject);
        }
        if (!this.lastQuestStateUpdate.isEmpty()) {
            this.requestHandler.submit(new QuestUpdate(this.player.getName(), this.client.getVarpValue(101), this.lastQuestStateUpdate));
            this.lastQuestStateUpdate.clear();
        }
    }

    private void processBankUpdate() {
        if (this.playerIsNull() || !this.config.bankData()) {
            return;
        }
        if (this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER) != null) {
            this.isBankOpen = true;
            this.lastBankState = this.client.getItemContainer(InventoryID.BANK);
            return;
        }
        if (this.isBankOpen && this.lastBankState != null) {
            this.isBankOpen = false;
            List<Item> items = Arrays.asList(this.lastBankState.getItems());
            this.requestHandler.submit(new BankUpdate(this.player.getName(), items));
        }
    }

    private void processInventoryUpdate(ItemContainerChanged icc) {
        if (this.playerIsNull() || !this.config.inventoryData()) {
            return;
        }
        List<Item> items = Arrays.asList(icc.getItemContainer().getItems());
        this.requestHandler.submit(new InventoryUpdate(this.player.getName(), items));
    }

    private void processEquipmentUpdate(ItemContainerChanged icc) {
        if (this.playerIsNull() || !this.config.equipmentData()) {
            return;
        }
        List<Item> items = Arrays.asList(icc.getItemContainer().getItems());
        HashMap<EquipmentInventorySlot, Item> equipped = new HashMap<EquipmentInventorySlot, Item>();
        for (EquipmentInventorySlot equipmentInventorySlot : EquipmentInventorySlot.values()) {
            Item item;
            if (equipmentInventorySlot.getSlotIdx() >= items.size() || (item = items.get(equipmentInventorySlot.getSlotIdx())).getId() <= -1 || item.getQuantity() <= 0) continue;
            equipped.put(equipmentInventorySlot, item);
        }
        this.requestHandler.submit(new EquipmentUpdate(this.player.getName(), equipped));
    }

    private void processOverheadUpdate() {
        if (this.playerIsNull() || !this.config.overheadData()) {
            return;
        }
        if (this.lastOverheadState.getOverhead() != null && !this.lastOverheadState.getOverhead().equals((Object)this.player.getOverheadIcon()) || this.lastOverheadState.getOverhead() == null && this.player.getOverheadIcon() != null) {
            this.lastOverheadState = new OverheadUpdate(this.player.getName(), this.player.getOverheadIcon());
            this.requestHandler.submit(this.lastOverheadState);
        }
    }

    private void processSkullUpdate() {
        if (this.playerIsNull() || !this.config.skullData()) {
            return;
        }
        if (this.lastSkullState.getSkull() != null && !this.lastSkullState.getSkull().equals((Object)this.player.getSkullIcon()) || this.lastSkullState.getSkull() == null && this.player.getSkullIcon() != null) {
            this.lastSkullState = new SkullUpdate(this.player.getName(), this.player.getSkullIcon());
            this.requestHandler.submit(this.lastSkullState);
        }
    }

    private boolean playerIsNull() {
        return this.player == null || this.player.getName() == null;
    }

    @Provides
    ConnectorConfig provideConfig(ConfigManager configManager) {
        return (ConnectorConfig)configManager.getConfig(ConnectorConfig.class);
    }
}

