/*
 * Decompiled with CFR 0.152.
 */
package info.sigterm.plugins.fossilisland;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Fossil Island", description="Removes scenery from Fossil Island to improve performance")
public class FossilIslandPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FossilIslandPlugin.class);
    private static final Set<Integer> HIDE = ImmutableSet.of((Object)30822, (Object)30825, (Object)30799, (Object)30823, (Object)30824, (Object)30828, (Object[])new Integer[]{30829, 30830, 30831, 30826, 30827, 30834, 30835, 30836, 30832, 30840});
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;

    protected void startUp() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invoke(this::hide);
        }
    }

    protected void shutDown() {
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.client.setGameState(GameState.LOADING);
            }
        });
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.hide();
        }
    }

    private void hide() {
        if (!this.isInMushroomForest()) {
            return;
        }
        Scene scene = this.client.getScene();
        Tile[][] tiles = scene.getTiles()[0];
        int cnt = 0;
        for (int x = 0; x < 104; ++x) {
            block1: for (int y = 0; y < 104; ++y) {
                Tile tile = tiles[x][y];
                if (tile == null) continue;
                for (GameObject gameObject : tile.getGameObjects()) {
                    if (gameObject == null || !HIDE.contains(gameObject.getId())) continue;
                    scene.removeGameObject(gameObject);
                    ++cnt;
                    continue block1;
                }
            }
        }
        log.debug("Removed {} objects", (Object)cnt);
    }

    private boolean isInMushroomForest() {
        return ArrayUtils.contains((int[])this.client.getMapRegions(), (int)14652) || ArrayUtils.contains((int[])this.client.getMapRegions(), (int)14651);
    }
}

