/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.ui.skills;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.FontManager;
import thestonedturtle.partypanel.ImgUtil;
import thestonedturtle.partypanel.ui.skills.SkillPanelSlot;

public class TotalPanelSlot
extends JPanel {
    private final JLabel levelLabel = new JLabel();
    private BufferedImage background;
    private BufferedImage skillHalf;
    private BufferedImage statHalf;

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.background == null) {
            return;
        }
        g.drawImage(this.background, 0, 0, null);
    }

    private void updateBackgroundImage() {
        if (this.skillHalf != null && this.statHalf != null) {
            this.background = ImgUtil.combineImages(this.skillHalf, this.statHalf);
            this.repaint();
        }
    }

    TotalPanelSlot(int totalLevel, SpriteManager spriteManager) {
        this.setOpaque(false);
        spriteManager.getSpriteAsync(183, 0, img -> {
            this.skillHalf = SkillPanelSlot.resize(img);
            this.updateBackgroundImage();
        });
        spriteManager.getSpriteAsync(184, 0, img -> {
            this.statHalf = SkillPanelSlot.resize(img);
            this.updateBackgroundImage();
        });
        this.setPreferredSize(SkillPanelSlot.PANEL_FULL_SIZE);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        JLabel textLabel = new JLabel("Total level:");
        textLabel.setFont(FontManager.getRunescapeSmallFont());
        textLabel.setForeground(Color.YELLOW);
        this.add((Component)textLabel, c);
        if (totalLevel > 0) {
            this.levelLabel.setText(String.valueOf(totalLevel));
        }
        this.levelLabel.setFont(FontManager.getRunescapeSmallFont());
        this.levelLabel.setForeground(Color.YELLOW);
        ++c.gridy;
        this.add((Component)this.levelLabel, c);
    }

    public void updateTotalLevel(int level) {
        this.levelLabel.setText(String.valueOf(level));
        this.levelLabel.repaint();
    }
}

