/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.ui.skills;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import thestonedturtle.partypanel.ImgUtil;

public class SkillPanelSlot
extends JPanel {
    private static final Dimension PANEL_HALF_SIZE = new Dimension(36, 36);
    static final Dimension PANEL_FULL_SIZE = new Dimension(SkillPanelSlot.PANEL_HALF_SIZE.width * 2, SkillPanelSlot.PANEL_HALF_SIZE.height);
    private final JLabel boostedLabel = new JLabel();
    private final JLabel baseLabel = new JLabel();
    private BufferedImage background;
    private BufferedImage skillHalf;
    private BufferedImage statHalf;

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.background == null) {
            return;
        }
        g.drawImage(this.background, 0, 0, null);
    }

    private void updateBackgroundImage() {
        if (this.skillHalf != null && this.statHalf != null) {
            this.background = ImgUtil.combineImages(this.skillHalf, this.statHalf);
            this.repaint();
        }
    }

    SkillPanelSlot(int boostedLevel, int baseLevel) {
        this.setOpaque(false);
        this.setPreferredSize(PANEL_FULL_SIZE);
        this.setLayout(new BorderLayout());
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridBagLayout());
        textPanel.setPreferredSize(PANEL_HALF_SIZE);
        textPanel.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.5;
        c.weightx = 1.0;
        c.fill = 1;
        this.boostedLabel.setText(String.valueOf(boostedLevel));
        this.boostedLabel.setVerticalAlignment(0);
        this.boostedLabel.setHorizontalAlignment(2);
        this.boostedLabel.setFont(FontManager.getRunescapeSmallFont());
        this.boostedLabel.setForeground(Color.YELLOW);
        this.boostedLabel.setBorder(new EmptyBorder(6, 3, 0, 0));
        c.anchor = 18;
        textPanel.add((Component)this.boostedLabel, c);
        this.baseLabel.setVerticalAlignment(0);
        this.baseLabel.setHorizontalAlignment(4);
        this.baseLabel.setFont(FontManager.getRunescapeSmallFont());
        this.baseLabel.setForeground(Color.YELLOW);
        this.updateBaseLevel(baseLevel);
        c.anchor = 14;
        ++c.gridy;
        textPanel.add((Component)this.baseLabel, c);
        this.add((Component)textPanel, "East");
    }

    void initImages(BufferedImage skillIcon, SpriteManager spriteManager) {
        spriteManager.getSpriteAsync(174, 0, img -> {
            this.skillHalf = ImgUtil.overlapImages(skillIcon, SkillPanelSlot.resize(img), false);
            this.updateBackgroundImage();
        });
        spriteManager.getSpriteAsync(175, 0, img -> {
            this.statHalf = SkillPanelSlot.resize(img);
            this.updateBackgroundImage();
        });
    }

    static BufferedImage resize(BufferedImage img) {
        return ImageUtil.resizeImage((BufferedImage)img, (int)SkillPanelSlot.PANEL_HALF_SIZE.width, (int)SkillPanelSlot.PANEL_HALF_SIZE.height);
    }

    public void updateBaseLevel(int baseLevel) {
        int rightPadding = 8;
        if (baseLevel > 99) {
            rightPadding = 1;
        } else if (baseLevel > 9) {
            rightPadding = 4;
        }
        this.baseLabel.setText(String.valueOf(baseLevel));
        this.baseLabel.setBorder(new EmptyBorder(0, 0, 4, rightPadding));
        this.baseLabel.repaint();
    }

    public void updateBoostedLevel(int boostedLevel) {
        this.boostedLabel.setText(String.valueOf(boostedLevel));
        this.boostedLabel.repaint();
    }
}

