/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.ui.skills;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.api.Skill;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.DynamicGridLayout;
import thestonedturtle.partypanel.data.PartyPlayer;
import thestonedturtle.partypanel.ui.skills.SkillPanelSlot;
import thestonedturtle.partypanel.ui.skills.TotalPanelSlot;

public class PlayerSkillsPanel
extends JPanel {
    private static final List<Skill> SKILLS = ImmutableList.of((Object)Skill.ATTACK, (Object)Skill.HITPOINTS, (Object)Skill.MINING, (Object)Skill.STRENGTH, (Object)Skill.AGILITY, (Object)Skill.SMITHING, (Object)Skill.DEFENCE, (Object)Skill.HERBLORE, (Object)Skill.FISHING, (Object)Skill.RANGED, (Object)Skill.THIEVING, (Object)Skill.COOKING, (Object[])new Skill[]{Skill.PRAYER, Skill.CRAFTING, Skill.FIREMAKING, Skill.MAGIC, Skill.FLETCHING, Skill.WOODCUTTING, Skill.RUNECRAFT, Skill.SLAYER, Skill.FARMING, Skill.CONSTRUCTION, Skill.HUNTER});
    private static final ImmutableMap<Skill, Integer> SPRITE_MAP;
    private static final Dimension PANEL_SIZE;
    private final Map<Skill, SkillPanelSlot> panelMap = new HashMap<Skill, SkillPanelSlot>();
    private final TotalPanelSlot totalLevelPanel;

    public PlayerSkillsPanel(PartyPlayer player, boolean displayVirtualLevels, SpriteManager spriteManager) {
        this.setMinimumSize(PANEL_SIZE);
        this.setPreferredSize(PANEL_SIZE);
        this.setBackground(new Color(62, 53, 41));
        this.setLayout((LayoutManager)new DynamicGridLayout(8, 3, 2, 0));
        int totalLevel = 0;
        for (Skill s : SKILLS) {
            int realLevel = player.getSkillRealLevel(s, displayVirtualLevels);
            SkillPanelSlot slot = new SkillPanelSlot(player.getSkillBoostedLevel(s), realLevel);
            this.panelMap.put(s, slot);
            this.add(slot);
            spriteManager.getSpriteAsync(((Integer)SPRITE_MAP.get((Object)s)).intValue(), 0, img -> SwingUtilities.invokeLater(() -> slot.initImages((BufferedImage)img, spriteManager)));
            this.updateSkill(player, s, displayVirtualLevels);
            totalLevel += realLevel;
        }
        totalLevel = player.getStats() == null ? 9 + Skill.values().length : totalLevel;
        this.totalLevelPanel = new TotalPanelSlot(totalLevel, spriteManager);
        this.add(this.totalLevelPanel);
    }

    public void updateSkill(PartyPlayer player, Skill s, boolean displayVirtualLevels) {
        int baseLevel;
        int boosted = s == Skill.HITPOINTS ? 10 : 1;
        int n = baseLevel = s == Skill.HITPOINTS ? 10 : 1;
        if (player.getStats() != null) {
            boosted = player.getSkillBoostedLevel(s);
            baseLevel = player.getSkillRealLevel(s, displayVirtualLevels);
        }
        SkillPanelSlot panel = this.panelMap.get(s);
        panel.updateBoostedLevel(boosted);
        panel.updateBaseLevel(baseLevel);
        panel.setToolTipText(s.getName());
    }

    public Map<Skill, SkillPanelSlot> getPanelMap() {
        return this.panelMap;
    }

    public TotalPanelSlot getTotalLevelPanel() {
        return this.totalLevelPanel;
    }

    static {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)Skill.ATTACK, (Object)197);
        map.put((Object)Skill.STRENGTH, (Object)198);
        map.put((Object)Skill.DEFENCE, (Object)199);
        map.put((Object)Skill.RANGED, (Object)200);
        map.put((Object)Skill.PRAYER, (Object)201);
        map.put((Object)Skill.MAGIC, (Object)202);
        map.put((Object)Skill.HITPOINTS, (Object)203);
        map.put((Object)Skill.AGILITY, (Object)204);
        map.put((Object)Skill.HERBLORE, (Object)205);
        map.put((Object)Skill.THIEVING, (Object)206);
        map.put((Object)Skill.CRAFTING, (Object)207);
        map.put((Object)Skill.FLETCHING, (Object)208);
        map.put((Object)Skill.MINING, (Object)209);
        map.put((Object)Skill.SMITHING, (Object)210);
        map.put((Object)Skill.FISHING, (Object)211);
        map.put((Object)Skill.COOKING, (Object)212);
        map.put((Object)Skill.FIREMAKING, (Object)213);
        map.put((Object)Skill.WOODCUTTING, (Object)214);
        map.put((Object)Skill.RUNECRAFT, (Object)215);
        map.put((Object)Skill.SLAYER, (Object)216);
        map.put((Object)Skill.FARMING, (Object)217);
        map.put((Object)Skill.CONSTRUCTION, (Object)221);
        map.put((Object)Skill.HUNTER, (Object)220);
        SPRITE_MAP = map.build();
        PANEL_SIZE = new Dimension(211, 296);
    }
}

