/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.ui.prayer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Prayer;
import net.runelite.api.Skill;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import thestonedturtle.partypanel.data.PartyPlayer;
import thestonedturtle.partypanel.data.PrayerData;
import thestonedturtle.partypanel.data.Prayers;
import thestonedturtle.partypanel.ui.prayer.PrayerSlot;
import thestonedturtle.partypanel.ui.prayer.PrayerSprites;

public class PlayerPrayerPanel
extends JPanel {
    private static final Dimension PANEL_SIZE = new Dimension(211, 296);
    private static final Color BACKGROUND = new Color(62, 53, 41);
    private static final int MAX_COLUMNS = 5;
    private final Map<Prayer, PrayerSlot> slotMap = new HashMap<Prayer, PrayerSlot>();
    private final JLabel remainingLabel = new JLabel();

    public PlayerPrayerPanel(PartyPlayer player, SpriteManager spriteManager) {
        this.setLayout(new BorderLayout());
        this.setBackground(BACKGROUND);
        this.setPreferredSize(PANEL_SIZE);
        this.add((Component)this.createPrayerContainer(player.getPrayers(), spriteManager), "North");
        this.add((Component)this.createPrayerRemainingPanel(spriteManager), "South");
        this.updatePrayerRemaining(player.getSkillBoostedLevel(Skill.PRAYER), player.getSkillRealLevel(Skill.PRAYER));
    }

    private JPanel createPrayerContainer(Prayers prayer, SpriteManager spriteManager) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setPreferredSize(new Dimension(PlayerPrayerPanel.PANEL_SIZE.width, PlayerPrayerPanel.PANEL_SIZE.height - 25));
        panel.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.5;
        c.weightx = 0.5;
        c.ipadx = 2;
        c.ipady = 2;
        c.anchor = 10;
        for (PrayerSprites p : PrayerSprites.values()) {
            PrayerData data;
            PrayerSlot slot = new PrayerSlot(p, spriteManager);
            if (prayer != null && (data = prayer.getPrayerData().get(p.getPrayer())) != null) {
                slot.updatePrayerData(data);
            }
            this.slotMap.put(p.getPrayer(), slot);
            if (c.gridx == 5) {
                c.gridx = 0;
                ++c.gridy;
            }
            panel.add((Component)slot, c);
            ++c.gridx;
        }
        return panel;
    }

    private JPanel createPrayerRemainingPanel(SpriteManager spriteManager) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.ipady = 4;
        c.gridwidth = 1;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setOpaque(false);
        panel.setPreferredSize(new Dimension(PlayerPrayerPanel.PANEL_SIZE.width, 25));
        JLabel iconLabel = new JLabel();
        iconLabel.setOpaque(false);
        spriteManager.addSpriteTo(iconLabel, 651, 0);
        iconLabel.setHorizontalAlignment(4);
        this.remainingLabel.setFont(FontManager.getRunescapeSmallFont());
        this.remainingLabel.setForeground(ColorScheme.BRAND_ORANGE);
        this.remainingLabel.setVerticalAlignment(0);
        this.remainingLabel.setHorizontalTextPosition(2);
        this.remainingLabel.setBorder(new EmptyBorder(0, 4, 0, 0));
        this.remainingLabel.setOpaque(false);
        panel.add((Component)iconLabel, c);
        ++c.gridx;
        panel.add((Component)this.remainingLabel, c);
        return panel;
    }

    public void updatePrayerRemaining(int remaining, int maximum) {
        this.remainingLabel.setText(remaining + "/" + maximum);
    }

    public Map<Prayer, PrayerSlot> getSlotMap() {
        return this.slotMap;
    }
}

