/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.ui.equipment;

import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import thestonedturtle.partypanel.data.GameItem;
import thestonedturtle.partypanel.ui.equipment.EquipmentPanelSlot;

public class PlayerEquipmentPanel
extends JPanel {
    private static final ImmutableMap<EquipmentInventorySlot, Integer> EQUIPMENT_SLOT_SPRITE_MAP;
    private static final BufferedImage PANEL_BACKGROUND;
    private static final Dimension PANEL_SIZE;
    private static final Border BORDER_LEFT;
    private static final Border BORDER_RIGHT;
    private final Map<EquipmentInventorySlot, EquipmentPanelSlot> panelMap = new HashMap<EquipmentInventorySlot, EquipmentPanelSlot>();
    private final ItemManager itemManager;
    private final SpriteManager spriteManager;

    public PlayerEquipmentPanel(GameItem[] items, SpriteManager spriteManager, ItemManager itemManager) {
        this.spriteManager = spriteManager;
        this.itemManager = itemManager;
        this.setMinimumSize(PANEL_SIZE);
        this.setPreferredSize(PANEL_SIZE);
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(62, 53, 41));
        spriteManager.getSpriteAsync(170, 0, img -> SwingUtilities.invokeLater(() -> this.createPanel(items, (BufferedImage)img)));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        int x = (this.getWidth() - PANEL_BACKGROUND.getWidth()) / 2;
        int y = (this.getHeight() - PANEL_BACKGROUND.getHeight()) / 2;
        g2d.drawImage((Image)PANEL_BACKGROUND, x, y, null);
    }

    private void createPanel(GameItem[] items, BufferedImage background) {
        this.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.ipadx = 4;
        c.ipady = 3;
        c.anchor = 10;
        c.gridx = 1;
        c.gridy = 0;
        this.createEquipmentPanelSlot(EquipmentInventorySlot.HEAD, items, background, c);
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 13;
        this.createEquipmentPanelSlot(EquipmentInventorySlot.CAPE, items, background, c);
        c.anchor = 10;
        ++c.gridx;
        this.createEquipmentPanelSlot(EquipmentInventorySlot.AMULET, items, background, c);
        ++c.gridx;
        c.anchor = 17;
        this.createEquipmentPanelSlot(EquipmentInventorySlot.AMMO, items, background, c);
        c.anchor = 10;
        c.gridx = 0;
        ++c.gridy;
        this.createEquipmentPanelSlot(EquipmentInventorySlot.WEAPON, items, background, c, BORDER_RIGHT);
        ++c.gridx;
        this.createEquipmentPanelSlot(EquipmentInventorySlot.BODY, items, background, c);
        ++c.gridx;
        this.createEquipmentPanelSlot(EquipmentInventorySlot.SHIELD, items, background, c, BORDER_LEFT);
        c.gridx = 1;
        ++c.gridy;
        this.createEquipmentPanelSlot(EquipmentInventorySlot.LEGS, items, background, c);
        c.gridx = 0;
        ++c.gridy;
        this.createEquipmentPanelSlot(EquipmentInventorySlot.GLOVES, items, background, c, BORDER_RIGHT);
        ++c.gridx;
        this.createEquipmentPanelSlot(EquipmentInventorySlot.BOOTS, items, background, c);
        ++c.gridx;
        this.createEquipmentPanelSlot(EquipmentInventorySlot.RING, items, background, c, BORDER_LEFT);
        this.revalidate();
        this.repaint();
    }

    private void createEquipmentPanelSlot(EquipmentInventorySlot slot, GameItem[] items, BufferedImage background, GridBagConstraints c) {
        this.createEquipmentPanelSlot(slot, items, background, c, null);
    }

    private void createEquipmentPanelSlot(EquipmentInventorySlot slot, GameItem[] items, BufferedImage background, GridBagConstraints constraints, Border border) {
        GridBagConstraints c = (GridBagConstraints)constraints.clone();
        GameItem item = items.length > slot.getSlotIdx() ? items[slot.getSlotIdx()] : null;
        AsyncBufferedImage image = item == null ? null : this.itemManager.getImage(item.getId(), item.getQty(), item.isStackable());
        this.spriteManager.getSpriteAsync(((Integer)EQUIPMENT_SLOT_SPRITE_MAP.get((Object)slot)).intValue(), 0, img -> SwingUtilities.invokeLater(() -> {
            EquipmentPanelSlot panel = new EquipmentPanelSlot(item, (BufferedImage)image, background, (BufferedImage)img);
            if (border != null) {
                panel.setBorder(border);
            }
            this.panelMap.put(slot, panel);
            if (image != null) {
                image.onLoaded(() -> panel.setGameItem(item, (BufferedImage)image));
            }
            this.add((Component)panel, c);
        }));
    }

    public Map<EquipmentInventorySlot, EquipmentPanelSlot> getPanelMap() {
        return this.panelMap;
    }

    static {
        ImmutableMap.Builder sprites = new ImmutableMap.Builder();
        sprites.put((Object)EquipmentInventorySlot.HEAD, (Object)156);
        sprites.put((Object)EquipmentInventorySlot.CAPE, (Object)157);
        sprites.put((Object)EquipmentInventorySlot.AMULET, (Object)158);
        sprites.put((Object)EquipmentInventorySlot.WEAPON, (Object)159);
        sprites.put((Object)EquipmentInventorySlot.RING, (Object)160);
        sprites.put((Object)EquipmentInventorySlot.BODY, (Object)161);
        sprites.put((Object)EquipmentInventorySlot.SHIELD, (Object)162);
        sprites.put((Object)EquipmentInventorySlot.LEGS, (Object)163);
        sprites.put((Object)EquipmentInventorySlot.GLOVES, (Object)164);
        sprites.put((Object)EquipmentInventorySlot.BOOTS, (Object)165);
        sprites.put((Object)EquipmentInventorySlot.AMMO, (Object)166);
        EQUIPMENT_SLOT_SPRITE_MAP = sprites.build();
        PANEL_BACKGROUND = ImageUtil.loadImageResource(PlayerEquipmentPanel.class, (String)"equipment-bars.png");
        PANEL_SIZE = new Dimension(211, 296);
        BORDER_LEFT = new EmptyBorder(0, 15, 0, 0);
        BORDER_RIGHT = new EmptyBorder(0, 0, 0, 15);
    }
}

