/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.ui.equipment;

import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;
import thestonedturtle.partypanel.ImgUtil;
import thestonedturtle.partypanel.data.GameItem;

public class EquipmentPanelSlot
extends JLabel {
    private final int IMAGE_SIZE = 48;
    private final BufferedImage background;
    private final BufferedImage placeholder;
    private GameItem item = null;

    EquipmentPanelSlot(GameItem item, BufferedImage image, BufferedImage background, BufferedImage placeholder) {
        this.background = background;
        this.placeholder = ImageUtil.resizeImage((BufferedImage)ImgUtil.overlapImages(placeholder, background, false), (int)48, (int)48);
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.setGameItem(item, image);
    }

    public void setGameItem(GameItem item, BufferedImage image) {
        this.item = item;
        if (item == null || image == null) {
            this.setIcon(new ImageIcon(this.placeholder));
            this.setToolTipText(null);
            return;
        }
        this.setIcon(new ImageIcon(ImageUtil.resizeImage((BufferedImage)ImgUtil.overlapImages(image, this.background, true), (int)48, (int)48)));
        Object name = item.getName();
        if (item.getQty() > 1) {
            name = (String)name + " x " + QuantityFormatter.formatNumber((long)item.getQty());
        }
        this.setToolTipText((String)name);
    }

    public GameItem getItem() {
        return this.item;
    }
}

