/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Skill;
import net.runelite.client.game.AlternateSprites;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import thestonedturtle.partypanel.PartyPanelConfig;
import thestonedturtle.partypanel.data.GameItem;
import thestonedturtle.partypanel.data.PartyPlayer;
import thestonedturtle.partypanel.data.PrayerData;
import thestonedturtle.partypanel.ui.PlayerBanner;
import thestonedturtle.partypanel.ui.PlayerInventoryPanel;
import thestonedturtle.partypanel.ui.equipment.EquipmentPanelSlot;
import thestonedturtle.partypanel.ui.equipment.PlayerEquipmentPanel;
import thestonedturtle.partypanel.ui.prayer.PlayerPrayerPanel;
import thestonedturtle.partypanel.ui.prayer.PrayerSlot;
import thestonedturtle.partypanel.ui.skills.PlayerSkillsPanel;

public class PlayerPanel
extends JPanel {
    private static final Dimension IMAGE_SIZE = new Dimension(24, 24);
    private static final Color BACKGROUND_COLOR = ColorScheme.DARK_GRAY_COLOR;
    private static final Color BACKGROUND_HOVER_COLOR = ColorScheme.DARKER_GRAY_COLOR;
    private static final BufferedImage EXPAND_ICON = ImageUtil.loadImageResource(PlayerPanel.class, (String)"expand.png");
    private static final int VENOM_THRESHOLD = 1000000;
    private static final BufferedImage HEART_DISEASE = ImageUtil.loadImageResource(AlternateSprites.class, (String)"1067-DISEASE.png");
    private static final BufferedImage HEART_POISON = ImageUtil.loadImageResource(AlternateSprites.class, (String)"1067-POISON.png");
    private static final BufferedImage HEART_VENOM = ImageUtil.loadImageResource(AlternateSprites.class, (String)"1067-VENOM.png");
    private PartyPlayer player;
    private final SpriteManager spriteManager;
    private final ItemManager itemManager;
    private final PlayerBanner banner;
    private final PlayerInventoryPanel inventoryPanel;
    private final PlayerEquipmentPanel equipmentPanel;
    private final PlayerSkillsPanel skillsPanel;
    private final PlayerPrayerPanel prayersPanel;
    private final PartyPanelConfig config;
    private boolean showInfo;
    private final Map<Integer, Boolean> tabMap = new HashMap<Integer, Boolean>();

    public PlayerPanel(PartyPlayer selectedPlayer, PartyPanelConfig config, SpriteManager spriteManager, ItemManager itemManager) {
        this.player = selectedPlayer;
        this.config = config;
        this.spriteManager = spriteManager;
        this.itemManager = itemManager;
        this.showInfo = config.autoExpandMembers();
        this.banner = new PlayerBanner(selectedPlayer, this.showInfo, config.displayPlayerWorlds(), spriteManager);
        this.inventoryPanel = new PlayerInventoryPanel(selectedPlayer.getInventory(), itemManager);
        this.equipmentPanel = new PlayerEquipmentPanel(selectedPlayer.getEquipment(), spriteManager, itemManager);
        this.skillsPanel = new PlayerSkillsPanel(selectedPlayer, config.displayVirtualLevels(), spriteManager);
        this.prayersPanel = new PlayerPrayerPanel(selectedPlayer, spriteManager);
        final JPanel statsPanel = this.banner.getStatsPanel();
        final JLabel expandIcon = this.banner.getExpandIcon();
        Component[] list = new Component[statsPanel.getComponentCount() + 1];
        System.arraycopy(statsPanel.getComponents(), 0, list, 0, list.length - 1);
        list[list.length - 1] = this.banner;
        for (Component comp : list) {
            if (!(comp instanceof JPanel)) continue;
            comp.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        ImageIcon retrieve = (ImageIcon)expandIcon.getIcon();
                        BufferedImage buffered = (BufferedImage)retrieve.getImage();
                        PlayerPanel.this.showInfo = !PlayerPanel.this.showInfo;
                        expandIcon.setIcon(new ImageIcon(ImageUtil.rotateImage((BufferedImage)buffered, (double)Math.PI)));
                        PlayerPanel.this.updatePanel();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    PlayerPanel.this.banner.setBackground(BACKGROUND_HOVER_COLOR);
                    statsPanel.setBackground(BACKGROUND_HOVER_COLOR);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    PlayerPanel.this.banner.setBackground(BACKGROUND_COLOR);
                    statsPanel.setBackground(BACKGROUND_COLOR);
                }
            });
        }
        this.updatePanel();
        this.revalidate();
        this.repaint();
    }

    private void addTab(MaterialTabGroup tabGroup, int spriteID, JPanel panel, String tooltip) {
        this.spriteManager.getSpriteAsync(spriteID, 0, img -> SwingUtilities.invokeLater(() -> {
            MaterialTab tab = new MaterialTab(this.createImageIcon((BufferedImage)img), tabGroup, (JComponent)panel);
            tab.setToolTipText(tooltip);
            tabGroup.addTab(tab);
            tabGroup.revalidate();
            tabGroup.repaint();
            this.tabMap.put(spriteID, false);
            tab.setOnSelectEvent(() -> {
                this.tabMap.replaceAll((k, v) -> {
                    v = false;
                    return v;
                });
                this.tabMap.put(spriteID, true);
                this.updatePlayerData(this.player, false);
                return true;
            });
            if (spriteID == 900) {
                tabGroup.select(tab);
                this.tabMap.put(spriteID, true);
            }
        }));
    }

    private ImageIcon createImageIcon(BufferedImage image) {
        return new ImageIcon(ImageUtil.resizeImage((BufferedImage)image, (int)PlayerPanel.IMAGE_SIZE.width, (int)PlayerPanel.IMAGE_SIZE.height));
    }

    public void updatePlayerData(PartyPlayer newPlayer, boolean hasBreakingBannerChange) {
        this.player = newPlayer;
        this.banner.setPlayer(this.player);
        if (hasBreakingBannerChange) {
            this.banner.recreatePanel();
        }
        if (this.player.getStats() != null) {
            this.banner.refreshStats();
        }
        BufferedImage heart = null;
        if (this.player.getPoison() >= 1000000) {
            heart = HEART_VENOM;
        } else if (this.player.getPoison() > 0) {
            heart = HEART_POISON;
        } else if (this.player.getDisease() > 0) {
            heart = HEART_DISEASE;
        }
        this.banner.setCurrentHeart(heart, this.spriteManager);
        this.banner.setUsingStamIcon(this.player.getStamina() > 0, this.spriteManager);
        if (!this.showInfo) {
            return;
        }
        if (this.tabMap.getOrDefault(900, false).booleanValue()) {
            this.inventoryPanel.updateInventory(this.player.getInventory());
        }
        if (this.tabMap.getOrDefault(901, false).booleanValue()) {
            for (EquipmentInventorySlot equipSlot : EquipmentInventorySlot.values()) {
                GameItem item = null;
                if (this.player.getEquipment().length > equipSlot.getSlotIdx()) {
                    item = this.player.getEquipment()[equipSlot.getSlotIdx()];
                }
                EquipmentPanelSlot slot = this.equipmentPanel.getPanelMap().get(equipSlot);
                if (item != null && slot != null) {
                    AsyncBufferedImage img = this.itemManager.getImage(item.getId(), item.getQty(), item.isStackable());
                    slot.setGameItem(item, (BufferedImage)img);
                    GameItem finalItem = item;
                    img.onLoaded(() -> slot.setGameItem(finalItem, (BufferedImage)img));
                    continue;
                }
                if (slot == null) continue;
                slot.setGameItem(null, null);
            }
        }
        if (this.player.getStats() != null && this.tabMap.getOrDefault(898, false).booleanValue()) {
            int totalLevel = 0;
            for (Skill s : Skill.values()) {
                if (s.equals((Object)Skill.OVERALL)) continue;
                totalLevel += this.player.getSkillRealLevel(s, this.config.displayVirtualLevels());
                this.updateSkill(s);
            }
            this.skillsPanel.getTotalLevelPanel().updateTotalLevel(totalLevel);
        }
        if (this.player.getPrayers() != null && this.tabMap.getOrDefault(779, false).booleanValue()) {
            for (Map.Entry entry : this.prayersPanel.getSlotMap().entrySet()) {
                PrayerData data = this.player.getPrayers().getPrayerData().get(entry.getKey());
                if (data == null) continue;
                ((PrayerSlot)entry.getValue()).updatePrayerData(data);
            }
            this.prayersPanel.updatePrayerRemaining(this.player.getSkillBoostedLevel(Skill.PRAYER), this.player.getSkillRealLevel(Skill.PRAYER));
        }
    }

    public void updatePanel() {
        this.removeAll();
        if (this.showInfo) {
            this.setBorder(new CompoundBorder(new MatteBorder(2, 2, 2, 2, new Color(87, 80, 64)), new EmptyBorder(0, 0, 5, 0)));
        } else {
            this.setBorder(new MatteBorder(2, 2, 2, 2, new Color(87, 80, 64)));
        }
        JPanel view = new JPanel();
        view.setBorder(new EmptyBorder(5, 5, 0, 5));
        MaterialTabGroup tabGroup = new MaterialTabGroup(view);
        tabGroup.setBorder((Border)new EmptyBorder(10, 0, 4, 0));
        this.tabMap.clear();
        this.addTab(tabGroup, 900, this.inventoryPanel, "Inventory");
        this.addTab(tabGroup, 901, this.equipmentPanel, "Equipment");
        this.addTab(tabGroup, 779, this.prayersPanel, "Prayers");
        this.addTab(tabGroup, 898, this.skillsPanel, "Skills");
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        this.add(this.banner);
        if (this.showInfo) {
            this.add((Component)tabGroup);
            this.add(view);
        }
        this.revalidate();
        this.repaint();
    }

    public void updateSkill(Skill s) {
        this.skillsPanel.updateSkill(this.player, s, this.config.displayVirtualLevels());
    }

    public void updateDisplayVirtualLevels() {
        int totalLevel = 0;
        long totalXp = 0L;
        for (Skill s : Skill.values()) {
            if (s.equals((Object)Skill.OVERALL)) continue;
            totalLevel += this.player.getSkillRealLevel(s, this.config.displayVirtualLevels());
            this.updateSkill(s);
        }
        this.skillsPanel.getTotalLevelPanel().updateTotalLevel(totalLevel);
    }

    public void updateDisplayPlayerWorlds() {
        this.banner.updateWorld(this.player.getWorld(), this.config.displayPlayerWorlds());
    }

    public PartyPlayer getPlayer() {
        return this.player;
    }

    public SpriteManager getSpriteManager() {
        return this.spriteManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public PlayerBanner getBanner() {
        return this.banner;
    }

    public PlayerInventoryPanel getInventoryPanel() {
        return this.inventoryPanel;
    }

    public PlayerEquipmentPanel getEquipmentPanel() {
        return this.equipmentPanel;
    }

    public PlayerSkillsPanel getSkillsPanel() {
        return this.skillsPanel;
    }

    public PlayerPrayerPanel getPrayersPanel() {
        return this.prayersPanel;
    }

    public PartyPanelConfig getConfig() {
        return this.config;
    }

    public boolean isShowInfo() {
        return this.showInfo;
    }

    public Map<Integer, Boolean> getTabMap() {
        return this.tabMap;
    }

    public void setShowInfo(boolean showInfo) {
        this.showInfo = showInfo;
    }
}

