/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.util.QuantityFormatter;
import thestonedturtle.partypanel.data.GameItem;

public class PlayerInventoryPanel
extends JPanel {
    private static final Dimension INVI_SLOT_SIZE = new Dimension(50, 42);
    private static final Dimension PANEL_SIZE = new Dimension(211, 296);
    private static final Color INVI_BACKGROUND = new Color(62, 53, 41);
    private final ItemManager itemManager;

    public PlayerInventoryPanel(GameItem[] items, ItemManager itemManager) {
        this.itemManager = itemManager;
        this.setLayout((LayoutManager)new DynamicGridLayout(7, 4, 2, 2));
        this.setBackground(INVI_BACKGROUND);
        this.setPreferredSize(PANEL_SIZE);
        this.updateInventory(items);
    }

    public void updateInventory(GameItem[] items) {
        this.removeAll();
        for (GameItem i : items) {
            JLabel label = new JLabel();
            label.setMinimumSize(INVI_SLOT_SIZE);
            label.setPreferredSize(INVI_SLOT_SIZE);
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(0);
            if (i != null) {
                Object name = i.getName();
                if (i.getQty() > 1) {
                    name = (String)name + " x " + QuantityFormatter.formatNumber((long)i.getQty());
                }
                label.setToolTipText((String)name);
                this.itemManager.getImage(i.getId(), i.getQty(), i.isStackable()).addTo(label);
            }
            this.add(label);
        }
        for (int i = this.getComponentCount(); i < 28; ++i) {
            JLabel label = new JLabel();
            label.setMinimumSize(INVI_SLOT_SIZE);
            label.setPreferredSize(INVI_SLOT_SIZE);
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(0);
            this.add(label);
        }
        this.revalidate();
        this.repaint();
    }
}

