/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.ui;

import com.google.common.base.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.api.Skill;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;
import thestonedturtle.partypanel.data.PartyPlayer;
import thestonedturtle.partypanel.ui.PlayerPanel;

public class PlayerBanner
extends JPanel {
    private static final Dimension STAT_ICON_SIZE = new Dimension(18, 18);
    private static final Dimension ICON_SIZE = new Dimension(30, 28);
    private static final BufferedImage EXPAND_ICON = ImageUtil.loadImageResource(PlayerPanel.class, (String)"expand.png");
    private static final String SPECIAL_ATTACK_NAME = "Special Attack";
    private static final String RUN_ENERGY_NAME = "Run Energy";
    private final JPanel statsPanel = new JPanel();
    private final JLabel iconLabel = new JLabel();
    private final Map<String, JLabel> statLabels = new HashMap<String, JLabel>();
    private final Map<String, JLabel> iconLabels = new HashMap<String, JLabel>();
    private final JLabel expandIcon = new JLabel();
    private final JLabel worldLabel = new JLabel();
    private final ImageIcon expandIconUp;
    private final ImageIcon expandIconDown;
    private PartyPlayer player;
    private boolean checkIcon;
    private BufferedImage currentHeart = null;
    private boolean usingStamIcon;

    public PlayerBanner(PartyPlayer player, boolean expanded, boolean displayWorld, SpriteManager spriteManager) {
        this.player = player;
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(211, 68));
        this.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.statsPanel.setPreferredSize(new Dimension(225, 25));
        this.statsPanel.setLayout(new GridLayout(0, 4));
        this.statsPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.statsPanel.setOpaque(true);
        this.expandIconDown = new ImageIcon(EXPAND_ICON);
        this.expandIconUp = new ImageIcon(ImageUtil.rotateImage((BufferedImage)EXPAND_ICON, (double)Math.PI));
        if (expanded) {
            this.expandIcon.setIcon(this.expandIconUp);
        } else {
            this.expandIcon.setIcon(this.expandIconDown);
        }
        this.worldLabel.setHorizontalTextPosition(2);
        this.worldLabel.setVisible(displayWorld);
        this.usingStamIcon = player.getStamina() > 0;
        this.statsPanel.add(this.createIconPanel(spriteManager, 203, Skill.HITPOINTS.getName(), String.valueOf(player.getSkillBoostedLevel(Skill.HITPOINTS))));
        this.statsPanel.add(this.createIconPanel(spriteManager, 201, Skill.PRAYER.getName(), String.valueOf(player.getSkillBoostedLevel(Skill.PRAYER))));
        this.statsPanel.add(this.createIconPanel(spriteManager, 442, SPECIAL_ATTACK_NAME, player.getStats() == null ? "0" : String.valueOf(player.getStats().getSpecialPercent())));
        this.statsPanel.add(this.createIconPanel(spriteManager, this.usingStamIcon ? 1092 : 1070, RUN_ENERGY_NAME, player.getStats() == null ? "0" : String.valueOf(player.getStats().getRunEnergy())));
        this.recreatePanel();
    }

    public void setExpandIcon(boolean direction) {
        if (direction) {
            this.expandIcon.setIcon(this.expandIconUp);
        } else {
            this.expandIcon.setIcon(this.expandIconDown);
        }
    }

    public void recreatePanel() {
        this.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.ipady = 4;
        this.iconLabel.setBorder(new MatteBorder(1, 1, 1, 1, ColorScheme.DARKER_GRAY_HOVER_COLOR));
        this.iconLabel.setPreferredSize(ICON_SIZE);
        this.iconLabel.setMinimumSize(ICON_SIZE);
        this.iconLabel.setOpaque(false);
        boolean bl = this.checkIcon = this.player.getMember().getAvatar() == null;
        if (!this.checkIcon) {
            this.addIcon();
        }
        this.add((Component)this.iconLabel, c);
        ++c.gridx;
        JPanel nameContainer = new JPanel(new GridLayout(2, 1));
        nameContainer.setBorder(new EmptyBorder(0, 5, 0, 0));
        nameContainer.setOpaque(false);
        JLabel usernameLabel = new JLabel();
        usernameLabel.setLayout(new OverlayLayout(usernameLabel));
        usernameLabel.setHorizontalTextPosition(2);
        if (Strings.isNullOrEmpty((String)this.player.getUsername())) {
            usernameLabel.setText("Not logged in");
        } else {
            String levelText = this.player.getStats() == null ? "" : " (level-" + this.player.getStats().getCombatLevel() + ")";
            usernameLabel.setText(this.player.getUsername() + levelText);
        }
        this.expandIcon.setAlignmentX(1.0f);
        usernameLabel.add((Component)this.expandIcon, "East");
        nameContainer.add(usernameLabel);
        this.worldLabel.setText("Not logged in");
        if (Strings.isNullOrEmpty((String)this.player.getUsername())) {
            this.worldLabel.setText("");
        } else if (this.player.getWorld() > 0) {
            this.worldLabel.setText("World " + this.player.getWorld());
        }
        nameContainer.add(this.worldLabel);
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)nameContainer, c);
        this.refreshStats();
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridwidth = 2;
        this.add((Component)this.statsPanel, c);
        this.revalidate();
        this.repaint();
    }

    private void addIcon() {
        BufferedImage resized = ImageUtil.resizeImage((BufferedImage)this.player.getMember().getAvatar(), (int)28, (int)28);
        this.iconLabel.setIcon(new ImageIcon(resized));
    }

    public void refreshStats() {
        if (this.checkIcon && this.player.getMember().getAvatar() != null) {
            this.addIcon();
            this.checkIcon = false;
        }
        this.statLabels.getOrDefault(Skill.HITPOINTS.getName(), new JLabel()).setText(String.valueOf(this.player.getSkillBoostedLevel(Skill.HITPOINTS)));
        this.statLabels.getOrDefault(Skill.PRAYER.getName(), new JLabel()).setText(String.valueOf(this.player.getSkillBoostedLevel(Skill.PRAYER)));
        this.statLabels.getOrDefault(SPECIAL_ATTACK_NAME, new JLabel()).setText(this.player.getStats() == null ? "0" : String.valueOf(this.player.getStats().getSpecialPercent()));
        this.statLabels.getOrDefault(RUN_ENERGY_NAME, new JLabel()).setText(this.player.getStats() == null ? "0" : String.valueOf(this.player.getStats().getRunEnergy()));
        this.statsPanel.revalidate();
        this.statsPanel.repaint();
    }

    private JPanel createIconPanel(SpriteManager spriteManager, int spriteID, String name, String value) {
        JLabel iconLabel = new JLabel();
        iconLabel.setPreferredSize(STAT_ICON_SIZE);
        this.iconLabels.put(name, iconLabel);
        this.setSpriteIcon(name, spriteID, spriteManager);
        JLabel textLabel = new JLabel(value);
        textLabel.setHorizontalAlignment(0);
        textLabel.setHorizontalTextPosition(0);
        this.statLabels.put(name, textLabel);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)iconLabel, "West");
        panel.add((Component)textLabel, "Center");
        panel.setOpaque(false);
        panel.setToolTipText(name);
        return panel;
    }

    private void setSpriteIcon(String statLabelKey, int spriteID, SpriteManager spriteManager) {
        JLabel label = this.iconLabels.get(statLabelKey);
        spriteManager.getSpriteAsync(spriteID, 0, img -> SwingUtilities.invokeLater(() -> {
            if (spriteID == 201) {
                label.setIcon(new ImageIcon(ImageUtil.resizeImage((BufferedImage)img, (int)(PlayerBanner.STAT_ICON_SIZE.width + 2), (int)(PlayerBanner.STAT_ICON_SIZE.height + 2))));
            } else {
                label.setIcon(new ImageIcon(ImageUtil.resizeImage((BufferedImage)img, (int)PlayerBanner.STAT_ICON_SIZE.width, (int)PlayerBanner.STAT_ICON_SIZE.height)));
            }
            label.revalidate();
            label.repaint();
        }));
    }

    private void setBufferedIcon(String statLabelKey, BufferedImage img) {
        JLabel label = this.iconLabels.get(statLabelKey);
        SwingUtilities.invokeLater(() -> {
            label.setIcon(new ImageIcon(ImageUtil.resizeImage((BufferedImage)img, (int)PlayerBanner.STAT_ICON_SIZE.width, (int)PlayerBanner.STAT_ICON_SIZE.height)));
            label.revalidate();
            label.repaint();
        });
    }

    public void setCurrentHeart(BufferedImage img, SpriteManager spriteManager) {
        if (img == null && this.currentHeart == null || img != null && img.equals(this.currentHeart)) {
            return;
        }
        this.currentHeart = img;
        if (this.currentHeart == null) {
            this.setSpriteIcon(Skill.HITPOINTS.getName(), 203, spriteManager);
        } else {
            this.setBufferedIcon(Skill.HITPOINTS.getName(), this.currentHeart);
        }
        this.statsPanel.revalidate();
        this.statsPanel.repaint();
    }

    public void setUsingStamIcon(boolean isStaminaPotted, SpriteManager spriteManager) {
        if (isStaminaPotted == this.usingStamIcon) {
            return;
        }
        this.usingStamIcon = isStaminaPotted;
        int id = this.usingStamIcon ? 1092 : 1070;
        this.setSpriteIcon(RUN_ENERGY_NAME, id, spriteManager);
        this.statsPanel.revalidate();
        this.statsPanel.repaint();
    }

    public void updateWorld(int world, boolean displayWorlds) {
        this.worldLabel.setVisible(displayWorlds);
        this.worldLabel.setText("World " + world);
    }

    public JPanel getStatsPanel() {
        return this.statsPanel;
    }

    public JLabel getExpandIcon() {
        return this.expandIcon;
    }

    public void setPlayer(PartyPlayer player) {
        this.player = player;
    }

    public PartyPlayer getPlayer() {
        return this.player;
    }
}

