/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import thestonedturtle.partypanel.PartyPanelPlugin;

public class ControlsPanel
extends JPanel {
    private static final String BTN_CREATE_TEXT = "Create party";
    private static final String BTN_LEAVE_TEXT = "Leave party";
    private final JButton startButton = new JButton();
    private final JButton joinPartyButton = new JButton();
    private final JButton rejoinPartyButton = new JButton();
    private final JButton copyPartyIdButton = new JButton();
    private final PartyPanelPlugin plugin;

    public ControlsPanel(PartyPanelPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(0, 2, 4, 2);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.startButton, c);
        c.gridx = 1;
        c.gridy = 0;
        this.add((Component)this.joinPartyButton, c);
        c.gridx = 1;
        c.gridy = 0;
        this.add((Component)this.copyPartyIdButton, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        this.add((Component)this.rejoinPartyButton, c);
        this.startButton.setText(plugin.isInParty() ? BTN_LEAVE_TEXT : BTN_CREATE_TEXT);
        this.startButton.setFocusable(false);
        this.joinPartyButton.setText("Join party");
        this.joinPartyButton.setFocusable(false);
        this.rejoinPartyButton.setText("Join previous party");
        this.rejoinPartyButton.setFocusable(false);
        this.copyPartyIdButton.setText("Copy passphrase");
        this.copyPartyIdButton.setFocusable(false);
        this.startButton.addActionListener(e -> {
            if (plugin.isInParty()) {
                int result = JOptionPane.showOptionDialog(this.startButton, "Are you sure you want to leave the party?", "Leave party?", 0, 2, null, new String[]{"Yes", "No"}, "No");
                if (result == 0) {
                    plugin.leaveParty();
                }
            } else {
                plugin.createParty();
            }
        });
        this.joinPartyButton.addActionListener(e -> {
            if (!plugin.isInParty()) {
                String s = (String)JOptionPane.showInputDialog(this.joinPartyButton, "Please enter the party passphrase:", "Party Passphrase", -1, null, null, "");
                if (s == null) {
                    return;
                }
                plugin.changeParty(s);
            }
        });
        this.rejoinPartyButton.addActionListener(e -> {
            if (!plugin.isInParty()) {
                plugin.changeParty(plugin.getConfig().previousPartyId());
            }
        });
        this.copyPartyIdButton.addActionListener(e -> {
            if (plugin.isInParty()) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(plugin.getPartyPassphrase()), null);
            }
        });
        this.updateControls();
    }

    public void updateControls() {
        this.startButton.setText(this.plugin.isInParty() ? BTN_LEAVE_TEXT : BTN_CREATE_TEXT);
        this.joinPartyButton.setVisible(!this.plugin.isInParty());
        this.rejoinPartyButton.setVisible(!this.plugin.isInParty());
        this.copyPartyIdButton.setVisible(this.plugin.isInParty());
        if (!this.plugin.getConfig().showPartyControls()) {
            this.setVisible(false);
        }
    }
}

