/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.data.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.runelite.api.Prayer;
import net.runelite.client.game.ItemManager;
import net.runelite.client.party.messages.PartyMemberMessage;
import thestonedturtle.partypanel.data.GameItem;
import thestonedturtle.partypanel.data.PartyPlayer;
import thestonedturtle.partypanel.data.events.PartyMiscChange;
import thestonedturtle.partypanel.data.events.PartyStatChange;

public class PartyBatchedChange
extends PartyMemberMessage {
    int[] i;
    int[] e;
    Collection<PartyStatChange> s = new ArrayList<PartyStatChange>();
    Collection<PartyMiscChange> m = new ArrayList<PartyMiscChange>();
    Integer ap;
    Integer ep;

    public boolean isValid() {
        return this.i != null || this.e != null || this.s != null && this.s.size() > 0 || this.m != null && this.m.size() > 0 || this.ap != null || this.ep != null;
    }

    public void removeDefaults() {
        this.s = this.s == null || this.s.size() == 0 ? null : this.s;
        this.m = this.m == null || this.m.size() == 0 ? null : this.m;
    }

    public void process(PartyPlayer player, ItemManager itemManager) {
        GameItem[] gameItems;
        if (this.i != null) {
            gameItems = GameItem.convertItemsToGameItems(this.i, itemManager);
            player.setInventory(gameItems);
        }
        if (this.e != null) {
            gameItems = GameItem.convertItemsToGameItems(this.e, itemManager);
            player.setEquipment(gameItems);
        }
        if (this.s != null) {
            this.s.forEach(change -> change.process(player));
        }
        if (this.m != null) {
            this.m.forEach(change -> change.process(player));
        }
        if (this.ap == null || this.ep == null) {
            return;
        }
        player.getPrayers().getPrayerData().forEach((idx, p) -> {
            p.setAvailable(false);
            p.setEnabled(false);
        });
        for (Prayer p2 : this.unpackActivePrayers()) {
            player.getPrayers().getPrayerData().get(p2).setAvailable(true);
        }
        for (Prayer p2 : this.unpackEnabledPrayers()) {
            player.getPrayers().getPrayerData().get(p2).setEnabled(true);
        }
    }

    public boolean hasBreakingBannerChange() {
        return this.m != null && this.m.stream().anyMatch(e -> e.getT() == PartyMiscChange.PartyMisc.C || e.getT() == PartyMiscChange.PartyMisc.W);
    }

    public boolean hasStatChange() {
        return this.s != null && this.s.size() > 0 || this.m != null && this.m.stream().anyMatch(e -> e.getT() == PartyMiscChange.PartyMisc.S || e.getT() == PartyMiscChange.PartyMisc.R || e.getT() == PartyMiscChange.PartyMisc.C || e.getT() == PartyMiscChange.PartyMisc.T);
    }

    public static <E extends Enum<E>> int pack(Collection<E> items) {
        int i = 0;
        for (Enum e : items) {
            assert (e.ordinal() < 32);
            i |= 1 << e.ordinal();
        }
        return i;
    }

    private Collection<Prayer> unpack(int pack) {
        ArrayList<Prayer> out = new ArrayList<Prayer>();
        for (Prayer p : Prayer.values()) {
            if ((pack & 1 << p.ordinal()) == 0) continue;
            out.add(p);
        }
        return out;
    }

    public Collection<Prayer> unpackActivePrayers() {
        return this.unpack(this.ap);
    }

    public Collection<Prayer> unpackEnabledPrayers() {
        return this.unpack(this.ep);
    }

    public int[] getI() {
        return this.i;
    }

    public int[] getE() {
        return this.e;
    }

    public Collection<PartyStatChange> getS() {
        return this.s;
    }

    public Collection<PartyMiscChange> getM() {
        return this.m;
    }

    public Integer getAp() {
        return this.ap;
    }

    public Integer getEp() {
        return this.ep;
    }

    public void setI(int[] i) {
        this.i = i;
    }

    public void setE(int[] e) {
        this.e = e;
    }

    public void setS(Collection<PartyStatChange> s) {
        this.s = s;
    }

    public void setM(Collection<PartyMiscChange> m) {
        this.m = m;
    }

    public void setAp(Integer ap) {
        this.ap = ap;
    }

    public void setEp(Integer ep) {
        this.ep = ep;
    }

    public String toString() {
        return "PartyBatchedChange(i=" + Arrays.toString(this.getI()) + ", e=" + Arrays.toString(this.getE()) + ", s=" + this.getS() + ", m=" + this.getM() + ", ap=" + this.getAp() + ", ep=" + this.getEp() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartyBatchedChange)) {
            return false;
        }
        PartyBatchedChange other = (PartyBatchedChange)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$ap = this.getAp();
        Integer other$ap = other.getAp();
        if (this$ap == null ? other$ap != null : !((Object)this$ap).equals(other$ap)) {
            return false;
        }
        Integer this$ep = this.getEp();
        Integer other$ep = other.getEp();
        if (this$ep == null ? other$ep != null : !((Object)this$ep).equals(other$ep)) {
            return false;
        }
        if (!Arrays.equals(this.getI(), other.getI())) {
            return false;
        }
        if (!Arrays.equals(this.getE(), other.getE())) {
            return false;
        }
        Collection<PartyStatChange> this$s = this.getS();
        Collection<PartyStatChange> other$s = other.getS();
        if (this$s == null ? other$s != null : !((Object)this$s).equals(other$s)) {
            return false;
        }
        Collection<PartyMiscChange> this$m = this.getM();
        Collection<PartyMiscChange> other$m = other.getM();
        return !(this$m == null ? other$m != null : !((Object)this$m).equals(other$m));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartyBatchedChange;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $ap = this.getAp();
        result = result * 59 + ($ap == null ? 43 : ((Object)$ap).hashCode());
        Integer $ep = this.getEp();
        result = result * 59 + ($ep == null ? 43 : ((Object)$ep).hashCode());
        result = result * 59 + Arrays.hashCode(this.getI());
        result = result * 59 + Arrays.hashCode(this.getE());
        Collection<PartyStatChange> $s = this.getS();
        result = result * 59 + ($s == null ? 43 : ((Object)$s).hashCode());
        Collection<PartyMiscChange> $m = this.getM();
        result = result * 59 + ($m == null ? 43 : ((Object)$m).hashCode());
        return result;
    }
}

