/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.data;

import java.util.HashMap;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.Skill;
import thestonedturtle.partypanel.data.events.PartyStatChange;

public class Stats {
    private final Map<Skill, Integer> baseLevels = new HashMap<Skill, Integer>();
    private final Map<Skill, Integer> boostedLevels = new HashMap<Skill, Integer>();
    private int specialPercent;
    private int runEnergy;
    private int combatLevel;
    private int totalLevel;

    public Stats() {
        for (Skill s : Skill.values()) {
            this.baseLevels.put(s, 1);
            this.boostedLevels.put(s, 1);
        }
        this.baseLevels.put(Skill.HITPOINTS, 10);
        this.boostedLevels.put(Skill.HITPOINTS, 10);
        this.combatLevel = 3;
        this.specialPercent = 0;
        this.runEnergy = 0;
        this.combatLevel = 0;
        this.totalLevel = 0;
    }

    public Stats(Client client) {
        int[] bases = client.getSkillExperiences();
        int[] boosts = client.getBoostedSkillLevels();
        for (Skill s : Skill.values()) {
            this.baseLevels.put(s, Experience.getLevelForXp((int)bases[s.ordinal()]));
            this.boostedLevels.put(s, boosts[s.ordinal()]);
        }
        this.recalculateCombatLevel();
        this.specialPercent = client.getVarpValue(300) / 10;
        this.totalLevel = client.getTotalLevel();
        this.runEnergy = client.getEnergy();
    }

    public int recalculateCombatLevel() {
        this.combatLevel = Experience.getCombatLevel((int)Math.min(this.baseLevels.get(Skill.ATTACK), 99), (int)Math.min(this.baseLevels.get(Skill.STRENGTH), 99), (int)Math.min(this.baseLevels.get(Skill.DEFENCE), 99), (int)Math.min(this.baseLevels.get(Skill.HITPOINTS), 99), (int)Math.min(this.baseLevels.get(Skill.MAGIC), 99), (int)Math.min(this.baseLevels.get(Skill.RANGED), 99), (int)Math.min(this.baseLevels.get(Skill.PRAYER), 99));
        return this.combatLevel;
    }

    public PartyStatChange createPartyStatChangeForSkill(Skill s) {
        return new PartyStatChange(s.ordinal(), this.baseLevels.get(s), this.boostedLevels.get(s));
    }

    public Map<Skill, Integer> getBaseLevels() {
        return this.baseLevels;
    }

    public Map<Skill, Integer> getBoostedLevels() {
        return this.boostedLevels;
    }

    public int getSpecialPercent() {
        return this.specialPercent;
    }

    public int getRunEnergy() {
        return this.runEnergy;
    }

    public int getCombatLevel() {
        return this.combatLevel;
    }

    public int getTotalLevel() {
        return this.totalLevel;
    }

    public void setSpecialPercent(int specialPercent) {
        this.specialPercent = specialPercent;
    }

    public void setRunEnergy(int runEnergy) {
        this.runEnergy = runEnergy;
    }

    public void setCombatLevel(int combatLevel) {
        this.combatLevel = combatLevel;
    }

    public void setTotalLevel(int totalLevel) {
        this.totalLevel = totalLevel;
    }
}

