/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.data;

import java.util.HashMap;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.Prayer;
import thestonedturtle.partypanel.data.PrayerData;
import thestonedturtle.partypanel.ui.prayer.PrayerSprites;

public class Prayers {
    public static final int PRAYER_IS_AVAILABLE = 464;
    private final Map<Prayer, PrayerData> prayerData = new HashMap<Prayer, PrayerData>();
    private int[] prayerIds = new int[0];

    public Prayers() {
        for (Prayer p : Prayer.values()) {
            this.prayerData.put(p, new PrayerData(p, p.ordinal() == 0, false));
        }
    }

    public Prayers(Client client) {
        if (client.getLocalPlayer() != null) {
            for (PrayerSprites p : PrayerSprites.values()) {
                this.updatePrayerState(p, client);
            }
        }
        this.setCurrentPrayerIds(client);
    }

    public boolean updatePrayerState(PrayerSprites p, Client client) {
        boolean changed;
        if (this.prayerIds.length == 0) {
            this.setCurrentPrayerIds(client);
        }
        assert (this.prayerIds.length > 0);
        client.runScript(new Object[]{464, this.prayerIds[p.getScriptIndex()]});
        boolean available = client.getIntStack()[0] > 0;
        boolean enabled = client.isPrayerActive(p.getPrayer());
        PrayerData data = this.prayerData.get(p.getPrayer());
        if (data == null) {
            data = new PrayerData(p.getPrayer(), available, enabled);
            changed = true;
        } else {
            changed = data.isAvailable() != available || data.isEnabled() != enabled;
            data.setAvailable(available);
            data.setEnabled(enabled);
        }
        this.prayerData.put(data.getPrayer(), data);
        return changed;
    }

    private void setCurrentPrayerIds(Client client) {
        EnumComposition prayers = client.getEnum(4956);
        this.prayerIds = prayers.getIntVals();
    }

    public Map<Prayer, PrayerData> getPrayerData() {
        return this.prayerData;
    }
}

