/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.data;

import java.util.Arrays;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.Skill;
import net.runelite.client.game.ItemManager;
import net.runelite.client.party.PartyMember;
import thestonedturtle.partypanel.data.GameItem;
import thestonedturtle.partypanel.data.Prayers;
import thestonedturtle.partypanel.data.Stats;

public class PartyPlayer {
    private transient PartyMember member;
    private String username;
    private Stats stats;
    private GameItem[] inventory;
    private GameItem[] equipment;
    private Prayers prayers;
    private int stamina;
    private int poison;
    private int disease;
    private int world;

    public PartyPlayer(PartyMember member) {
        this.member = member;
        this.username = "";
        this.stats = null;
        this.inventory = new GameItem[28];
        this.equipment = new GameItem[EquipmentInventorySlot.AMMO.getSlotIdx() + 1];
        this.prayers = null;
        this.stamina = 0;
        this.poison = 0;
        this.disease = 0;
        this.world = 0;
    }

    public PartyPlayer(PartyMember member, Client client, ItemManager itemManager) {
        this(member);
        this.stamina = client.getVarbitValue(24);
        this.poison = client.getVarpValue(102);
        this.disease = client.getVarpValue(456);
        this.world = client.getWorld();
        this.updatePlayerInfo(client, itemManager);
    }

    public void updatePlayerInfo(Client client, ItemManager itemManager) {
        if (client.getLocalPlayer() != null) {
            ItemContainer equip;
            this.username = client.getLocalPlayer().getName();
            this.stats = new Stats(client);
            ItemContainer invi = client.getItemContainer(InventoryID.INVENTORY);
            if (invi != null) {
                this.inventory = GameItem.convertItemsToGameItems(invi.getItems(), itemManager);
            }
            if ((equip = client.getItemContainer(InventoryID.EQUIPMENT)) != null) {
                this.equipment = GameItem.convertItemsToGameItems(equip.getItems(), itemManager);
            }
            if (this.prayers == null) {
                this.prayers = new Prayers(client);
            }
        }
    }

    public int getSkillBoostedLevel(Skill skill) {
        if (this.stats == null) {
            return 0;
        }
        return this.stats.getBoostedLevels().get(skill);
    }

    public int getSkillRealLevel(Skill skill) {
        return this.getSkillRealLevel(skill, false);
    }

    public int getSkillRealLevel(Skill skill, boolean allowVirtualLevels) {
        if (this.stats == null) {
            return 0;
        }
        assert (skill != Skill.OVERALL);
        return Math.min(this.stats.getBaseLevels().get(skill), allowVirtualLevels ? 126 : 99);
    }

    public void setSkillsBoostedLevel(Skill skill, int level) {
        if (this.stats == null) {
            return;
        }
        this.stats.getBoostedLevels().put(skill, level);
    }

    public void setSkillsRealLevel(Skill skill, int level) {
        if (this.stats == null) {
            return;
        }
        this.stats.getBaseLevels().put(skill, level);
    }

    public PartyMember getMember() {
        return this.member;
    }

    public String getUsername() {
        return this.username;
    }

    public Stats getStats() {
        return this.stats;
    }

    public GameItem[] getInventory() {
        return this.inventory;
    }

    public GameItem[] getEquipment() {
        return this.equipment;
    }

    public Prayers getPrayers() {
        return this.prayers;
    }

    public int getStamina() {
        return this.stamina;
    }

    public int getPoison() {
        return this.poison;
    }

    public int getDisease() {
        return this.disease;
    }

    public int getWorld() {
        return this.world;
    }

    public void setMember(PartyMember member) {
        this.member = member;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public void setInventory(GameItem[] inventory) {
        this.inventory = inventory;
    }

    public void setEquipment(GameItem[] equipment) {
        this.equipment = equipment;
    }

    public void setPrayers(Prayers prayers) {
        this.prayers = prayers;
    }

    public void setStamina(int stamina) {
        this.stamina = stamina;
    }

    public void setPoison(int poison) {
        this.poison = poison;
    }

    public void setDisease(int disease) {
        this.disease = disease;
    }

    public void setWorld(int world) {
        this.world = world;
    }

    public String toString() {
        return "PartyPlayer(member=" + this.getMember() + ", username=" + this.getUsername() + ", stats=" + this.getStats() + ", inventory=" + Arrays.deepToString(this.getInventory()) + ", equipment=" + Arrays.deepToString(this.getEquipment()) + ", prayers=" + this.getPrayers() + ", stamina=" + this.getStamina() + ", poison=" + this.getPoison() + ", disease=" + this.getDisease() + ", world=" + this.getWorld() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartyPlayer)) {
            return false;
        }
        PartyPlayer other = (PartyPlayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStamina() != other.getStamina()) {
            return false;
        }
        if (this.getPoison() != other.getPoison()) {
            return false;
        }
        if (this.getDisease() != other.getDisease()) {
            return false;
        }
        if (this.getWorld() != other.getWorld()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        Stats this$stats = this.getStats();
        Stats other$stats = other.getStats();
        if (this$stats == null ? other$stats != null : !this$stats.equals(other$stats)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInventory(), other.getInventory())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getEquipment(), other.getEquipment())) {
            return false;
        }
        Prayers this$prayers = this.getPrayers();
        Prayers other$prayers = other.getPrayers();
        return !(this$prayers == null ? other$prayers != null : !this$prayers.equals(other$prayers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartyPlayer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStamina();
        result = result * 59 + this.getPoison();
        result = result * 59 + this.getDisease();
        result = result * 59 + this.getWorld();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        Stats $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : $stats.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInventory());
        result = result * 59 + Arrays.deepHashCode(this.getEquipment());
        Prayers $prayers = this.getPrayers();
        result = result * 59 + ($prayers == null ? 43 : $prayers.hashCode());
        return result;
    }
}

