/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel.data;

import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;

public final class GameItem {
    private final int id;
    private final int qty;
    private final String name;
    private final boolean stackable;
    private final int price;

    public GameItem(Item item, ItemManager itemManager) {
        this(item.getId(), item.getQuantity(), itemManager);
    }

    public GameItem(int id, int qty, ItemManager itemManager) {
        this.id = id;
        this.qty = qty;
        ItemComposition c = itemManager.getItemComposition(id);
        this.name = c.getName();
        this.stackable = c.isStackable();
        this.price = itemManager.getItemPrice(c.getNote() != -1 ? c.getLinkedNoteId() : id);
    }

    public static GameItem[] convertItemsToGameItems(int[] items, ItemManager itemManager) {
        GameItem[] output = new GameItem[items.length / 2];
        for (int i = 0; i < items.length; i += 2) {
            output[i / 2] = items[i] == -1 || items[i + 1] <= 0 ? null : new GameItem(items[i], items[i + 1], itemManager);
        }
        return output;
    }

    public static GameItem[] convertItemsToGameItems(Item[] items, ItemManager itemManager) {
        GameItem[] output = new GameItem[items.length];
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            output[i] = item == null || item.getId() == -1 ? null : new GameItem(item, itemManager);
        }
        return output;
    }

    public int getId() {
        return this.id;
    }

    public int getQty() {
        return this.qty;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStackable() {
        return this.stackable;
    }

    public int getPrice() {
        return this.price;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GameItem)) {
            return false;
        }
        GameItem other = (GameItem)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getQty() != other.getQty()) {
            return false;
        }
        if (this.isStackable() != other.isStackable()) {
            return false;
        }
        if (this.getPrice() != other.getPrice()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getQty();
        result = result * 59 + (this.isStackable() ? 79 : 97);
        result = result * 59 + this.getPrice();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "GameItem(id=" + this.getId() + ", qty=" + this.getQty() + ", name=" + this.getName() + ", stackable=" + this.isStackable() + ", price=" + this.getPrice() + ")";
    }

    public GameItem(int id, int qty, String name, boolean stackable, int price) {
        this.id = id;
        this.qty = qty;
        this.name = name;
        this.stackable = stackable;
        this.price = price;
    }
}

