/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.Prayer;
import net.runelite.api.Skill;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.PartyChanged;
import net.runelite.client.events.PartyMemberAvatar;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.events.UserPart;
import net.runelite.client.party.messages.PartyMessage;
import net.runelite.client.party.messages.UserSync;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.partypanel.PartyPanel;
import thestonedturtle.partypanel.PartyPanelConfig;
import thestonedturtle.partypanel.data.GameItem;
import thestonedturtle.partypanel.data.PartyPlayer;
import thestonedturtle.partypanel.data.PrayerData;
import thestonedturtle.partypanel.data.Prayers;
import thestonedturtle.partypanel.data.Stats;
import thestonedturtle.partypanel.data.events.PartyBatchedChange;
import thestonedturtle.partypanel.data.events.PartyMiscChange;
import thestonedturtle.partypanel.data.events.PartyStatChange;
import thestonedturtle.partypanel.ui.PlayerPanel;
import thestonedturtle.partypanel.ui.prayer.PrayerSprites;

@PluginDescriptor(name="Hub Party Panel")
public class PartyPanelPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PartyPanelPlugin.class);
    private static final BufferedImage ICON = ImageUtil.loadImageResource(PartyPanelPlugin.class, (String)"icon.png");
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private PartyPanelConfig config;
    @Inject
    private PartyService partyService;
    @Inject
    private PluginManager pluginManager;
    @Inject
    SpriteManager spriteManager;
    @Inject
    ItemManager itemManager;
    @Inject
    private WSClient wsClient;
    private final Map<Long, PartyPlayer> partyMembers = new HashMap<Long, PartyPlayer>();
    private PartyPlayer myPlayer = null;
    private NavigationButton navButton;
    private boolean addedButton = false;
    private PartyPanel panel;
    private Instant lastLogout;
    private PartyBatchedChange currentChange = new PartyBatchedChange();

    @Provides
    PartyPanelConfig provideConfig(ConfigManager configManager) {
        return (PartyPanelConfig)configManager.getConfig(PartyPanelConfig.class);
    }

    protected void startUp() throws Exception {
        Optional<Plugin> partyPlugin;
        this.panel = new PartyPanel(this);
        this.navButton = NavigationButton.builder().tooltip("Hub Party Panel").icon(ICON).priority(7).panel((PluginPanel)this.panel).build();
        this.wsClient.registerMessage(PartyBatchedChange.class);
        if (this.isInParty() || this.config.alwaysShowIcon()) {
            this.clientToolbar.addNavigation(this.navButton);
            this.addedButton = true;
        }
        if (this.isInParty()) {
            this.clientThread.invokeLater(() -> {
                this.myPlayer = new PartyPlayer(this.partyService.getLocalMember(), this.client, this.itemManager);
                this.partyService.send((PartyMessage)new UserSync());
                this.partyService.send((PartyMessage)this.partyPlayerAsBatchedChange());
            });
        }
        if ((partyPlugin = this.pluginManager.getPlugins().stream().filter(p -> p.getName().equals("Party")).findFirst()).isPresent() && !this.pluginManager.isPluginEnabled(partyPlugin.get())) {
            this.pluginManager.setPluginEnabled(partyPlugin.get(), true);
        }
        this.lastLogout = Instant.now();
    }

    protected void shutDown() throws Exception {
        if (this.isInParty()) {
            PartyBatchedChange cleanUserInfo = this.partyPlayerAsBatchedChange();
            cleanUserInfo.setI(new int[0]);
            cleanUserInfo.setE(new int[0]);
            cleanUserInfo.setM(Collections.emptySet());
            cleanUserInfo.setS(Collections.emptySet());
            this.partyService.send((PartyMessage)cleanUserInfo);
        }
        this.clientToolbar.removeNavigation(this.navButton);
        this.addedButton = false;
        this.partyMembers.clear();
        this.wsClient.unregisterMessage(PartyBatchedChange.class);
        this.currentChange = new PartyBatchedChange();
        this.panel.getPlayerPanelMap().clear();
        this.lastLogout = null;
    }

    @Subscribe
    protected void onConfigChanged(ConfigChanged c) {
        if (!c.getGroup().equals("partypanel")) {
            return;
        }
        if (this.config.alwaysShowIcon()) {
            if (!this.addedButton) {
                this.clientToolbar.addNavigation(this.navButton);
                this.addedButton = true;
            }
        } else if (this.addedButton && !this.isInParty()) {
            this.clientToolbar.removeNavigation(this.navButton);
            this.addedButton = false;
        }
        this.addedButton = this.config.alwaysShowIcon();
        switch (c.getKey()) {
            case "autoExpandMembers": {
                this.panel.updatePartyMembersExpand(this.config.autoExpandMembers());
                break;
            }
            case "showPartyControls": {
                this.panel.updatePartyControls();
                break;
            }
            case "showPartyPassphrase": {
                this.panel.syncPartyPassphraseVisibility();
                break;
            }
            case "displayVirtualLevels": {
                this.panel.updateDisplayVirtualLevels();
                break;
            }
            case "displayPlayerWorlds": {
                this.panel.updateDisplayPlayerWorlds();
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged c) {
        if (!this.isInParty()) {
            return;
        }
        if (c.getGameState() == GameState.LOGIN_SCREEN) {
            this.lastLogout = Instant.now();
        }
        if (this.myPlayer == null) {
            this.myPlayer = new PartyPlayer(this.partyService.getLocalMember(), this.client, this.itemManager);
            PartyBatchedChange ce = this.partyPlayerAsBatchedChange();
            this.partyService.send((PartyMessage)ce);
            return;
        }
        if (c.getGameState() == GameState.LOGGED_IN) {
            PartyMiscChange e = new PartyMiscChange(PartyMiscChange.PartyMisc.W, this.client.getWorld());
            if (this.myPlayer.getWorld() == e.getV().intValue()) {
                return;
            }
            this.myPlayer.setWorld(e.getV());
            this.currentChange.getM().add(e);
        }
        if (c.getGameState() == GameState.LOGIN_SCREEN) {
            if (this.myPlayer.getWorld() == 0) {
                return;
            }
            this.myPlayer.setWorld(0);
            this.currentChange.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.W, 0));
        }
    }

    public boolean isInParty() {
        return this.partyService.isInParty();
    }

    public boolean isLocalPlayer(long id) {
        return this.partyService.getLocalMember() != null && this.partyService.getLocalMember().getMemberId() == id;
    }

    @Subscribe
    public void onUserPart(UserPart event) {
        PartyPlayer removed = this.partyMembers.remove(event.getMemberId());
        if (removed != null) {
            SwingUtilities.invokeLater(() -> this.panel.removePartyPlayer(removed));
        }
        if (!(!this.addedButton || this.isInParty() && this.partyService.getMembers().size() != 0 || this.config.alwaysShowIcon())) {
            this.clientToolbar.removeNavigation(this.navButton);
            this.addedButton = false;
        }
    }

    @Subscribe
    public void onUserSync(UserSync event) {
        if (!this.addedButton) {
            this.clientToolbar.addNavigation(this.navButton);
            this.addedButton = true;
        }
        if (this.myPlayer != null) {
            PartyBatchedChange c = this.partyPlayerAsBatchedChange();
            if (c.isValid()) {
                this.partyService.send((PartyMessage)c);
            }
            return;
        }
        this.clientThread.invoke(() -> {
            this.myPlayer = new PartyPlayer(this.partyService.getLocalMember(), this.client, this.itemManager);
            PartyBatchedChange c = this.partyPlayerAsBatchedChange();
            if (c.isValid()) {
                this.partyService.send((PartyMessage)c);
            }
        });
    }

    @Subscribe
    public void onPartyChanged(PartyChanged event) {
        this.partyMembers.clear();
        SwingUtilities.invokeLater(this.panel::renderSidebar);
        this.myPlayer = null;
        this.panel.updateParty();
        if (!this.isInParty()) {
            if (!this.config.alwaysShowIcon()) {
                this.clientToolbar.removeNavigation(this.navButton);
                this.addedButton = false;
            }
            this.panel.getPlayerPanelMap().clear();
            return;
        }
        this.config.setPreviousPartyId(event.getPassphrase());
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (!this.isInParty() || this.client.getLocalPlayer() == null || this.partyService.getLocalMember() == null) {
            return;
        }
        if (this.client.getTickCount() % PartyPanelPlugin.messageFreq(this.partyService.getMembers().size()) != 0) {
            return;
        }
        if (this.myPlayer == null || !Objects.equals(this.client.getLocalPlayer().getName(), this.myPlayer.getUsername())) {
            this.myPlayer = new PartyPlayer(this.partyService.getLocalMember(), this.client, this.itemManager);
            PartyBatchedChange c = this.partyPlayerAsBatchedChange();
            this.partyService.send((PartyMessage)c);
            return;
        }
        if (this.myPlayer.getStats() == null) {
            this.myPlayer.updatePlayerInfo(this.client, this.itemManager);
            for (Skill s : Skill.values()) {
                this.currentChange.getS().add(this.myPlayer.getStats().createPartyStatChangeForSkill(s));
            }
        } else {
            int energy = this.client.getEnergy() / 100;
            if (this.myPlayer.getStats().getRunEnergy() != energy) {
                this.myPlayer.getStats().setRunEnergy(energy);
                this.currentChange.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.R, energy));
            }
        }
        if (this.myPlayer.getPrayers() == null) {
            this.myPlayer.setPrayers(new Prayers(this.client));
            ArrayList<Prayer> available = new ArrayList<Prayer>();
            ArrayList<Prayer> enabled = new ArrayList<Prayer>();
            for (PrayerSprites p : PrayerSprites.values()) {
                PrayerData data = this.myPlayer.getPrayers().getPrayerData().get(p.getPrayer());
                if (data.isAvailable()) {
                    available.add(p.getPrayer());
                }
                if (!data.isEnabled()) continue;
                enabled.add(p.getPrayer());
            }
            this.currentChange.setAp(PartyBatchedChange.pack(available));
            this.currentChange.setEp(PartyBatchedChange.pack(enabled));
        } else {
            ArrayList<Prayer> available = new ArrayList<Prayer>();
            ArrayList<Prayer> enabled = new ArrayList<Prayer>();
            boolean change = false;
            for (PrayerSprites p : PrayerSprites.values()) {
                change = this.myPlayer.getPrayers().updatePrayerState(p, this.client) || change;
                PrayerData data = this.myPlayer.getPrayers().getPrayerData().get(p.getPrayer());
                if (data.isAvailable()) {
                    available.add(p.getPrayer());
                }
                if (!data.isEnabled()) continue;
                enabled.add(p.getPrayer());
            }
            if (change) {
                this.currentChange.setAp(PartyBatchedChange.pack(available));
                this.currentChange.setEp(PartyBatchedChange.pack(enabled));
            }
        }
        if (this.currentChange.isValid()) {
            this.currentChange.setMemberId(this.partyService.getLocalMember().getMemberId());
            this.currentChange.removeDefaults();
            this.partyService.send((PartyMessage)this.currentChange);
            this.currentChange = new PartyBatchedChange();
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        if (this.myPlayer == null || this.myPlayer.getStats() == null || !this.isInParty()) {
            return;
        }
        Skill s = event.getSkill();
        if (this.myPlayer.getSkillBoostedLevel(s) == event.getBoostedLevel() && Experience.getLevelForXp((int)event.getXp()) == this.myPlayer.getSkillRealLevel(s)) {
            return;
        }
        int virtualLvl = Experience.getLevelForXp((int)event.getXp());
        this.myPlayer.setSkillsBoostedLevel(event.getSkill(), event.getBoostedLevel());
        this.myPlayer.setSkillsRealLevel(event.getSkill(), virtualLvl);
        this.currentChange.getS().add(new PartyStatChange(event.getSkill().ordinal(), virtualLvl, event.getBoostedLevel()));
        if (this.myPlayer.getStats().getTotalLevel() != this.client.getTotalLevel()) {
            this.myPlayer.getStats().setTotalLevel(this.client.getTotalLevel());
            this.currentChange.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.T, this.myPlayer.getStats().getTotalLevel()));
        }
        int oldCombatLevel = this.myPlayer.getStats().getCombatLevel();
        this.myPlayer.getStats().recalculateCombatLevel();
        if (this.myPlayer.getStats().getCombatLevel() != oldCombatLevel) {
            this.currentChange.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.C, this.myPlayer.getStats().getCombatLevel()));
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged c) {
        if (this.myPlayer == null || !this.isInParty()) {
            return;
        }
        if (c.getContainerId() == InventoryID.INVENTORY.getId()) {
            this.myPlayer.setInventory(GameItem.convertItemsToGameItems(c.getItemContainer().getItems(), this.itemManager));
            int[] items = this.convertItemsToArray(c.getItemContainer().getItems());
            this.currentChange.setI(items);
        } else if (c.getContainerId() == InventoryID.EQUIPMENT.getId()) {
            this.myPlayer.setEquipment(GameItem.convertItemsToGameItems(c.getItemContainer().getItems(), this.itemManager));
            int[] items = this.convertItemsToArray(c.getItemContainer().getItems());
            this.currentChange.setE(items);
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int disease;
        int poison;
        int stamina;
        if (this.myPlayer == null || this.myPlayer.getStats() == null || !this.isInParty()) {
            return;
        }
        int specialPercent = this.client.getVarpValue(300) / 10;
        if (specialPercent != this.myPlayer.getStats().getSpecialPercent()) {
            this.myPlayer.getStats().setSpecialPercent(specialPercent);
            this.currentChange.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.S, specialPercent));
        }
        if ((stamina = this.client.getVarbitValue(24)) != this.myPlayer.getStamina()) {
            this.myPlayer.setStamina(stamina);
            this.currentChange.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.ST, stamina));
        }
        if ((poison = this.client.getVarpValue(102)) != this.myPlayer.getPoison()) {
            this.myPlayer.setPoison(poison);
            this.currentChange.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.P, poison));
        }
        if ((disease = this.client.getVarpValue(456)) != this.myPlayer.getDisease()) {
            this.myPlayer.setDisease(disease);
            this.currentChange.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.D, disease));
        }
    }

    @Subscribe
    public void onPartyBatchedChange(PartyBatchedChange e) {
        if (this.isLocalPlayer(e.getMemberId())) {
            return;
        }
        PartyPlayer player = this.partyMembers.computeIfAbsent(e.getMemberId(), k -> new PartyPlayer(this.partyService.getMemberById(e.getMemberId())));
        if (player.getStats() == null && e.hasStatChange()) {
            player.setStats(new Stats());
        }
        if (player.getPrayers() == null && (e.getAp() != null || e.getEp() != null)) {
            player.setPrayers(new Prayers());
        }
        this.clientThread.invoke(() -> {
            e.process(player, this.itemManager);
            SwingUtilities.invokeLater(() -> {
                PlayerPanel playerPanel = this.panel.getPlayerPanelMap().get(e.getMemberId());
                if (playerPanel != null) {
                    playerPanel.updatePlayerData(player, e.hasBreakingBannerChange());
                    return;
                }
                this.panel.drawPlayerPanel(player);
            });
        });
    }

    @Subscribe
    public void onPartyMemberAvatar(PartyMemberAvatar e) {
        if (this.isLocalPlayer(e.getMemberId()) || this.partyMembers.get(e.getMemberId()) == null) {
            return;
        }
        PartyPlayer player = this.partyMembers.get(e.getMemberId());
        player.getMember().setAvatar(e.getImage());
        SwingUtilities.invokeLater(() -> {
            PlayerPanel p = this.panel.getPlayerPanelMap().get(e.getMemberId());
            if (p != null) {
                p.getBanner().refreshStats();
            }
        });
    }

    public void changeParty(String passphrase) {
        if ((passphrase = passphrase.replace(" ", "-").trim()).length() == 0) {
            return;
        }
        for (int i = 0; i < passphrase.length(); ++i) {
            char ch = passphrase.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '-') continue;
            JOptionPane.showMessageDialog(this.panel.getControlsPanel(), "Party passphrase must be a combination of alphanumeric or hyphen characters.", "Invalid party passphrase", 0);
            return;
        }
        this.partyService.changeParty(passphrase);
        this.panel.updateParty();
    }

    public void createParty() {
        this.clientThread.invokeLater(() -> this.changeParty(this.partyService.generatePassphrase()));
    }

    public String getPartyPassphrase() {
        return this.partyService.getPartyPassphrase();
    }

    public void leaveParty() {
        this.partyService.changeParty(null);
        this.panel.updateParty();
    }

    private int[] convertItemsToArray(Item[] items) {
        int[] eles = new int[items.length * 2];
        for (int i = 0; i < items.length * 2; i += 2) {
            if (items[i / 2] == null) {
                eles[i] = -1;
                eles[i + 1] = 0;
                continue;
            }
            eles[i] = items[i / 2].getId();
            eles[i + 1] = items[i / 2].getQuantity();
        }
        return eles;
    }

    private int[] convertGameItemsToArray(GameItem[] items) {
        int[] eles = new int[items.length * 2];
        for (int i = 0; i < items.length * 2; i += 2) {
            if (items[i / 2] == null) {
                eles[i] = -1;
                eles[i + 1] = 0;
                continue;
            }
            eles[i] = items[i / 2].getId();
            eles[i + 1] = items[i / 2].getQty();
        }
        return eles;
    }

    public PartyBatchedChange partyPlayerAsBatchedChange() {
        PartyBatchedChange c = new PartyBatchedChange();
        if (this.myPlayer == null) {
            return c;
        }
        c.setI(this.convertGameItemsToArray(this.myPlayer.getInventory()));
        c.setE(this.convertGameItemsToArray(this.myPlayer.getEquipment()));
        if (this.myPlayer.getStats() != null) {
            for (Skill s : Skill.values()) {
                c.getS().add(this.myPlayer.getStats().createPartyStatChangeForSkill(s));
            }
            c.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.S, this.myPlayer.getStats().getSpecialPercent()));
            c.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.R, this.myPlayer.getStats().getRunEnergy()));
            c.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.C, this.myPlayer.getStats().getCombatLevel()));
            c.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.T, this.myPlayer.getStats().getTotalLevel()));
        }
        c.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.ST, this.myPlayer.getStamina()));
        c.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.P, this.myPlayer.getPoison()));
        c.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.D, this.myPlayer.getDisease()));
        c.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.W, this.myPlayer.getWorld()));
        if (this.myPlayer.getPrayers() != null) {
            ArrayList<Prayer> available = new ArrayList<Prayer>();
            ArrayList<Prayer> enabled = new ArrayList<Prayer>();
            for (PrayerSprites p : PrayerSprites.values()) {
                PrayerData data = this.myPlayer.getPrayers().getPrayerData().get(p.getPrayer());
                if (data.isAvailable()) {
                    available.add(p.getPrayer());
                }
                if (!data.isEnabled()) continue;
                enabled.add(p.getPrayer());
            }
            c.setAp(PartyBatchedChange.pack(available));
            c.setEp(PartyBatchedChange.pack(enabled));
        }
        c.getM().add(new PartyMiscChange(PartyMiscChange.PartyMisc.U, this.myPlayer.getUsername()));
        c.setMemberId(this.partyService.getLocalMember().getMemberId());
        c.removeDefaults();
        return c;
    }

    @Schedule(period=10L, unit=ChronoUnit.SECONDS)
    public void checkIdle() {
        if (this.client.getGameState() != GameState.LOGIN_SCREEN) {
            return;
        }
        if (this.lastLogout != null && this.lastLogout.isBefore(Instant.now().minus(30L, ChronoUnit.MINUTES)) && this.partyService.isInParty()) {
            log.info("Leaving party due to inactivity");
            this.partyService.changeParty(null);
        }
    }

    private static int messageFreq(int partySize) {
        return Math.max(2, partySize - 6);
    }

    public PartyPanelConfig getConfig() {
        return this.config;
    }

    public Map<Long, PartyPlayer> getPartyMembers() {
        return this.partyMembers;
    }

    public PartyPlayer getMyPlayer() {
        return this.myPlayer;
    }
}

