/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.partypanel;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;
import thestonedturtle.partypanel.PartyPanelPlugin;
import thestonedturtle.partypanel.data.PartyPlayer;
import thestonedturtle.partypanel.ui.ControlsPanel;
import thestonedturtle.partypanel.ui.PlayerPanel;

class PartyPanel
extends PluginPanel {
    private final PartyPanelPlugin plugin;
    private final HashMap<Long, PlayerPanel> playerPanelMap = new HashMap();
    private final JPanel basePanel = new JPanel();
    private final JPanel passphrasePanel = new JPanel();
    private final JLabel passphraseLabel = new JLabel();
    private final ControlsPanel controlsPanel;

    @Inject
    PartyPanel(PartyPanelPlugin plugin) {
        super(false);
        this.plugin = plugin;
        this.setLayout(new BorderLayout());
        this.basePanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.basePanel.setLayout((LayoutManager)new DynamicGridLayout(0, 1, 0, 5));
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new EmptyBorder(6, 2, 6, 2));
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        this.passphrasePanel.setBorder(new EmptyBorder(4, 0, 0, 0));
        this.passphrasePanel.setLayout((LayoutManager)new DynamicGridLayout(0, 1, 0, 5));
        JLabel passphraseTopLabel = new JLabel("Party Passphrase");
        passphraseTopLabel.setForeground(Color.WHITE);
        passphraseTopLabel.setHorizontalTextPosition(0);
        passphraseTopLabel.setHorizontalAlignment(0);
        JMenuItem copyOpt = new JMenuItem("Copy Passphrase");
        copyOpt.addActionListener(e -> {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(this.passphraseLabel.getText()), null);
        });
        JPopupMenu copyPopup = new JPopupMenu();
        copyPopup.setBorder(new EmptyBorder(5, 5, 5, 5));
        copyPopup.add(copyOpt);
        this.passphraseLabel.setText(plugin.getPartyPassphrase());
        this.passphraseLabel.setHorizontalTextPosition(0);
        this.passphraseLabel.setHorizontalAlignment(0);
        this.passphraseLabel.setComponentPopupMenu(copyPopup);
        this.passphrasePanel.add(passphraseTopLabel);
        this.passphrasePanel.add(this.passphraseLabel);
        this.syncPartyPassphraseVisibility();
        this.controlsPanel = new ControlsPanel(plugin);
        topPanel.add(this.controlsPanel);
        topPanel.add(this.passphrasePanel);
        this.add(topPanel, "North");
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)this.basePanel, "North");
        JScrollPane scrollPane = new JScrollPane(northPanel);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.add(scrollPane, "Center");
    }

    void renderSidebar() {
        this.basePanel.removeAll();
        List players = this.plugin.getPartyMembers().values().stream().sorted(Comparator.comparing(o -> Strings.isNullOrEmpty((String)o.getUsername()) ? o.getMember().getDisplayName() : o.getUsername())).collect(Collectors.toList());
        for (PartyPlayer player : players) {
            this.drawPlayerPanel(player);
        }
        if (this.getComponentCount() == 0) {
            this.basePanel.add(new JLabel("There are no members in your party"));
        }
        this.basePanel.revalidate();
        this.basePanel.repaint();
    }

    void drawPlayerPanel(PartyPlayer player) {
        PlayerPanel panel = this.playerPanelMap.computeIfAbsent(player.getMember().getMemberId(), k -> new PlayerPanel(player, this.plugin.getConfig(), this.plugin.spriteManager, this.plugin.itemManager));
        String playerName = player.getUsername() == null ? "" : player.getUsername();
        panel.updatePlayerData(player, panel.getPlayer().getMember().getMemberId() != player.getMember().getMemberId() || !playerName.equals(panel.getPlayer().getUsername()));
        this.basePanel.add(panel);
        this.basePanel.revalidate();
        this.basePanel.repaint();
    }

    void removePartyPlayer(PartyPlayer player) {
        if (player != null) {
            this.playerPanelMap.remove(player.getMember().getMemberId());
            this.renderSidebar();
        }
    }

    void updatePartyMembersExpand(boolean expand) {
        for (PlayerPanel panel : this.playerPanelMap.values()) {
            panel.setShowInfo(expand);
            panel.getBanner().setExpandIcon(expand);
            panel.updatePanel();
        }
    }

    public void updatePartyControls() {
        this.controlsPanel.setVisible(this.plugin.getConfig().showPartyControls());
    }

    public void syncPartyPassphraseVisibility() {
        this.passphraseLabel.setText(this.plugin.getPartyPassphrase());
        this.passphrasePanel.setVisible(this.plugin.getConfig().showPartyPassphrase() && this.plugin.isInParty());
    }

    public void updateParty() {
        this.controlsPanel.updateControls();
        this.syncPartyPassphraseVisibility();
    }

    public void updateDisplayVirtualLevels() {
        this.playerPanelMap.values().forEach(PlayerPanel::updateDisplayVirtualLevels);
    }

    public void updateDisplayPlayerWorlds() {
        this.playerPanelMap.values().forEach(PlayerPanel::updateDisplayPlayerWorlds);
    }

    public HashMap<Long, PlayerPanel> getPlayerPanelMap() {
        return this.playerPanelMap;
    }

    public ControlsPanel getControlsPanel() {
        return this.controlsPanel;
    }
}

