/*
 * Decompiled with CFR 0.152.
 */
package com.examinetooltip.components;

import com.examinetooltip.util.AlphaUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.regex.Pattern;
import net.runelite.client.ui.overlay.RenderableEntity;
import net.runelite.client.util.Text;

public class AlphaTextComponent
implements RenderableEntity {
    private static final String COL_TAG_REGEX = "(<col=([0-9a-fA-F]){2,6}>)";
    private static final Pattern COL_TAG_PATTERN_W_LOOKAHEAD = Pattern.compile("(?=(<col=([0-9a-fA-F]){2,6}>))");
    private String text;
    private Point position = new Point();
    private Color color = Color.WHITE;
    private boolean outline;
    private double alphaModifier = 1.0;

    public Dimension render(Graphics2D graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Color shadowColor = AlphaUtil.getAlphaModdedColor(Color.BLACK, this.alphaModifier);
        if (COL_TAG_PATTERN_W_LOOKAHEAD.matcher(this.text).find()) {
            String[] parts = COL_TAG_PATTERN_W_LOOKAHEAD.split(this.text);
            int x = this.position.x;
            for (String textSplitOnCol : parts) {
                String textWithoutCol = Text.removeTags((String)textSplitOnCol);
                String colColor = textSplitOnCol.substring(textSplitOnCol.indexOf("=") + 1, textSplitOnCol.indexOf(">"));
                graphics.setColor(shadowColor);
                if (this.outline) {
                    graphics.drawString(textWithoutCol, x, this.position.y + 1);
                    graphics.drawString(textWithoutCol, x, this.position.y - 1);
                    graphics.drawString(textWithoutCol, x + 1, this.position.y);
                    graphics.drawString(textWithoutCol, x - 1, this.position.y);
                } else {
                    graphics.drawString(textWithoutCol, x + 1, this.position.y + 1);
                }
                graphics.setColor(AlphaUtil.getAlphaModdedColor(Color.decode("#" + colColor), this.alphaModifier));
                graphics.drawString(textWithoutCol, x, this.position.y);
                x += fontMetrics.stringWidth(textWithoutCol);
            }
        } else {
            graphics.setColor(shadowColor);
            if (this.outline) {
                graphics.drawString(this.text, this.position.x, this.position.y + 1);
                graphics.drawString(this.text, this.position.x, this.position.y - 1);
                graphics.drawString(this.text, this.position.x + 1, this.position.y);
                graphics.drawString(this.text, this.position.x - 1, this.position.y);
            } else {
                graphics.drawString(this.text, this.position.x + 1, this.position.y + 1);
            }
            graphics.setColor(AlphaUtil.getAlphaModdedColor(this.color, this.alphaModifier));
            graphics.drawString(this.text, this.position.x, this.position.y);
        }
        return new Dimension(fontMetrics.stringWidth(this.text), fontMetrics.getHeight());
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setOutline(boolean outline) {
        this.outline = outline;
    }

    public void setAlphaModifier(double alphaModifier) {
        this.alphaModifier = alphaModifier;
    }
}

