/*
 * Decompiled with CFR 0.152.
 */
package com.examinetooltip;

import com.examinetooltip.ExamineTextTime;
import com.examinetooltip.ExamineTooltipConfig;
import com.examinetooltip.ExamineTooltipOverlay;
import com.examinetooltip.ExamineType;
import com.google.common.collect.EvictingQueue;
import com.google.inject.Provides;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Examine Tooltip", description="Shows tooltips or RS3 style hover boxes on examine", tags={"examine", "tooltip", "text", "hover", "rs3"})
public class ExamineTooltipPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ExamineTooltipPlugin.class);
    private static final Pattern PATCH_INSPECT_PATTERN = Pattern.compile("^This is an? .+\\. The (?:soil|patch) has");
    private static final Pattern PLUGIN_HUB_PATCH_PAYMENT_1_PATTERN = Pattern.compile("^A farmer will watch over an? .+ patch for");
    private static final Pattern PLUGIN_HUB_PATCH_PAYMENT_2_PATTERN = Pattern.compile("^An? .+ patch can NOT be protected by a farmer");
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ExamineTooltipOverlay examineTooltipOverlay;
    @Inject
    private ExamineTooltipConfig config;
    private final EvictingQueue<ExamineTextTime> examines = EvictingQueue.create((int)5);
    private final Queue<ExamineTextTime> pendingExamines = new ArrayDeque<ExamineTextTime>();
    private ExamineTextTime pendingPatchInspect;

    @Provides
    ExamineTooltipConfig provideConfig(ConfigManager configManager) {
        return (ExamineTooltipConfig)configManager.getConfig(ExamineTooltipConfig.class);
    }

    private void resetPlugin() {
        this.examines.clear();
        this.pendingExamines.clear();
        this.pendingPatchInspect = null;
    }

    protected void startUp() throws Exception {
        this.examineTooltipOverlay.setLayer(this.config.overlayLayer().getRlLayer());
        this.overlayManager.add((Overlay)this.examineTooltipOverlay);
        this.resetPlugin();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.examineTooltipOverlay);
        this.resetPlugin();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.resetPlugin();
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        ExamineType type;
        block16: {
            block17: {
                String option;
                block15: {
                    option = Text.removeTags((String)event.getMenuOption());
                    if (!option.equals("Examine")) break block15;
                    switch (event.getMenuAction()) {
                        case EXAMINE_ITEM_GROUND: {
                            if (!this.config.showGroundItemExamines()) {
                                return;
                            }
                            type = ExamineType.ITEM_GROUND;
                            break block16;
                        }
                        case CC_OP: 
                        case CC_OP_LOW_PRIORITY: {
                            if (!this.config.showItemExamines()) {
                                return;
                            }
                            type = ExamineType.ITEM_INTERFACE;
                            break block16;
                        }
                        case EXAMINE_OBJECT: {
                            if (!this.config.showObjectExamines()) {
                                return;
                            }
                            type = ExamineType.OBJECT;
                            break block16;
                        }
                        case EXAMINE_NPC: {
                            if (!this.config.showNPCExamines()) {
                                return;
                            }
                            type = ExamineType.NPC;
                            break block16;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (!option.equals("Inspect")) break block17;
                switch (event.getMenuAction()) {
                    case GAME_OBJECT_FIRST_OPTION: 
                    case GAME_OBJECT_SECOND_OPTION: 
                    case GAME_OBJECT_THIRD_OPTION: 
                    case GAME_OBJECT_FOURTH_OPTION: 
                    case GAME_OBJECT_FIFTH_OPTION: {
                        type = ExamineType.PATCH_INSPECT;
                        break block16;
                    }
                    default: {
                        return;
                    }
                }
            }
            return;
        }
        int id = event.getId();
        int actionParam = event.getParam0();
        int wId = event.getParam1();
        ExamineTextTime examine = new ExamineTextTime();
        examine.setType(type);
        examine.setId(id);
        examine.setWidgetId(wId);
        examine.setActionParam(actionParam);
        if (type == ExamineType.PATCH_INSPECT) {
            this.pendingPatchInspect = examine;
        } else {
            this.pendingExamines.offer(examine);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Subscribe
    public void onChatMessage(ChatMessage event) {
        ExamineTextTime pending;
        ExamineType type;
        String text = Text.removeTags((String)event.getMessage());
        switch (event.getType()) {
            case ITEM_EXAMINE: {
                if (text.startsWith("Price of")) {
                    type = ExamineType.PRICE_CHECK;
                    break;
                }
                if (this.checkPluginHubPatchPaymentException(text)) {
                    type = ExamineType.PLUGIN_HUB_PATCH_PAYMENT;
                    break;
                }
                type = ExamineType.ITEM_INTERFACE;
                break;
            }
            case OBJECT_EXAMINE: {
                type = ExamineType.OBJECT;
                break;
            }
            case NPC_EXAMINE: {
                type = ExamineType.NPC;
                break;
            }
            case GAMEMESSAGE: {
                if (PATCH_INSPECT_PATTERN.matcher(event.getMessage()).lookingAt()) {
                    type = ExamineType.PATCH_INSPECT;
                    break;
                }
                if (!this.checkPluginHubPatchPaymentException(text)) return;
                type = ExamineType.PLUGIN_HUB_PATCH_PAYMENT;
                break;
            }
            default: {
                return;
            }
        }
        Instant now = Instant.now();
        if (type == ExamineType.PRICE_CHECK || type == ExamineType.PLUGIN_HUB_PATCH_PAYMENT) {
            if ((type != ExamineType.PRICE_CHECK || !this.config.showPriceCheck()) && (type != ExamineType.PLUGIN_HUB_PATCH_PAYMENT || !this.config.showPluginHubPatchPayment())) return;
            ExamineTextTime examine = new ExamineTextTime();
            examine.setType(type);
            examine.setText(text);
            examine.setTime(now);
            this.examines.add((Object)examine);
            return;
        }
        if (type == ExamineType.PATCH_INSPECT) {
            if (this.pendingPatchInspect == null || !this.config.showPatchInspects()) return;
            pending = this.pendingPatchInspect;
            this.pendingPatchInspect = null;
        } else {
            if (this.pendingExamines.isEmpty()) return;
            pending = this.pendingExamines.poll();
        }
        if (pending.getType() == type || type == ExamineType.ITEM_INTERFACE && pending.getType() == ExamineType.ITEM_GROUND) {
            pending.setTime(now);
            pending.setText(text);
            this.examines.removeIf(x -> x.getText().equals(text));
            this.examines.add((Object)pending);
            return;
        } else {
            this.pendingExamines.clear();
        }
    }

    private boolean checkPluginHubPatchPaymentException(String text) {
        return PLUGIN_HUB_PATCH_PAYMENT_1_PATTERN.matcher(text).lookingAt() || PLUGIN_HUB_PATCH_PAYMENT_2_PATTERN.matcher(text).lookingAt();
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("examinetooltip") && event.getKey().equals("overlayLayer")) {
            this.examineTooltipOverlay.setLayer(this.config.overlayLayer().getRlLayer());
            this.overlayManager.resetOverlay((Overlay)this.examineTooltipOverlay);
        }
    }

    public EvictingQueue<ExamineTextTime> getExamines() {
        return this.examines;
    }
}

