/*
 * Decompiled with CFR 0.152.
 */
package com.examinetooltip;

import com.examinetooltip.ExamineTextTime;
import com.examinetooltip.ExamineTooltipConfig;
import com.examinetooltip.ExamineTooltipPlugin;
import com.examinetooltip.ExamineType;
import com.examinetooltip.components.AlphaTooltipComponent;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.ItemLayer;
import net.runelite.api.NPC;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Renderable;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import org.apache.commons.text.WordUtils;

public class ExamineTooltipOverlay
extends Overlay {
    private static final int SCREEN_PADDING = 5;
    private static final int EXAMINE_PADDING = 10;
    private static final Set<ExamineType> TOOLTIP_ONLY_EXAMINE_TYPES = ImmutableSet.of((Object)((Object)ExamineType.PRICE_CHECK), (Object)((Object)ExamineType.PLUGIN_HUB_PATCH_PAYMENT));
    @Inject
    private TooltipManager tooltipManager;
    @Inject
    private ExamineTooltipConfig config;
    @Inject
    private ExamineTooltipPlugin plugin;
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private Client client;
    private final Map<ExamineTextTime, Dimension> dimMap = new HashMap<ExamineTextTime, Dimension>();
    private final Map<ExamineTextTime, Rectangle> rectMap = new HashMap<ExamineTextTime, Rectangle>();

    public ExamineTooltipOverlay() {
        this.setPosition(OverlayPosition.TOOLTIP);
        this.setPriority(OverlayPriority.HIGHEST);
    }

    public Dimension render(Graphics2D graphics) {
        Instant now = Instant.now();
        Duration defaultTimeout = Duration.ofSeconds(this.config.tooltipTimeout());
        Duration patchTimeout = Duration.ofSeconds(defaultTimeout.getSeconds() + (long)this.config.patchInspectExtraTime());
        boolean shouldClearDimMap = !this.dimMap.isEmpty();
        boolean shouldClearRectMap = !this.rectMap.isEmpty();
        for (ExamineTextTime examine : this.plugin.getExamines()) {
            int fadeout;
            Duration timeout;
            Duration since = Duration.between(examine.getTime(), now);
            if (since.compareTo(timeout = examine.getType() == ExamineType.PATCH_INSPECT ? patchTimeout : defaultTimeout) >= 0) continue;
            long timeLeft = timeout.minus(since).toMillis();
            double alpha = timeLeft < (long)(fadeout = this.config.tooltipFadeout()) && fadeout > 0 ? Math.min(1.0, (double)timeLeft / (double)fadeout) : 1.0;
            if (!this.config.rs3Style() || TOOLTIP_ONLY_EXAMINE_TYPES.contains((Object)examine.getType())) {
                this.renderAsTooltip(examine, alpha);
                continue;
            }
            this.renderAsRS3(examine, graphics, alpha);
            shouldClearDimMap = false;
            shouldClearRectMap = false;
        }
        if (shouldClearDimMap || this.dimMap.size() > 10) {
            this.dimMap.clear();
        }
        if (shouldClearRectMap || this.rectMap.size() > 10) {
            this.rectMap.clear();
        }
        return null;
    }

    private LayoutableRenderableEntity getRenderableEntity(ExamineTextTime examine, double alphaModifier) {
        AlphaTooltipComponent tooltipComponent = new AlphaTooltipComponent();
        tooltipComponent.setText(this.getWrappedText(examine.getText()));
        tooltipComponent.setModIcons(this.client.getModIcons());
        tooltipComponent.setAlphaModifier(alphaModifier);
        if (this.config.customBackgroundColor() != null) {
            tooltipComponent.setBackgroundColor(this.config.customBackgroundColor());
        } else {
            tooltipComponent.setBackgroundColor(this.runeLiteConfig.overlayBackgroundColor());
        }
        return tooltipComponent;
    }

    private void renderAsTooltip(ExamineTextTime examine, double alphaModifier) {
        this.tooltipManager.add(new Tooltip(this.getRenderableEntity(examine, alphaModifier)));
    }

    private void renderAsRS3(ExamineTextTime examine, Graphics2D graphics, double alphaModifier) {
        Dimension dim;
        ExamineType type = examine.getType();
        Rectangle bounds = null;
        switch (type) {
            case NPC: {
                Shape shape;
                NPC[] cachedNPCs = this.client.getCachedNPCs();
                NPC npc = cachedNPCs[examine.getId()];
                if (npc == null || (shape = npc.getConvexHull()) == null) break;
                bounds = shape.getBounds();
                break;
            }
            case ITEM_INTERFACE: {
                bounds = this.findWidgetBounds(examine.getWidgetId(), examine.getActionParam());
                break;
            }
            case PATCH_INSPECT: 
            case ITEM_GROUND: 
            case OBJECT: {
                Tile bridge;
                LocalPoint point = LocalPoint.fromScene((int)examine.getActionParam(), (int)examine.getWidgetId());
                int id = examine.getId();
                Tile tile = this.client.getScene().getTiles()[this.client.getPlane()][point.getSceneX()][point.getSceneY()];
                if (tile == null) break;
                Shape shape = this.getObjectShapeFromTile(tile, type, id);
                if (shape == null && (bridge = tile.getBridge()) != null) {
                    shape = this.getObjectShapeFromTile(bridge, type, id);
                }
                if (shape == null) {
                    shape = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)point);
                }
                if (shape == null) break;
                bounds = shape.getBounds();
                break;
            }
            default: {
                return;
            }
        }
        if (bounds == null && this.config.previousBoundsFallback()) {
            bounds = this.rectMap.get(examine);
        }
        if (bounds == null) {
            if (this.config.tooltipFallback()) {
                this.renderAsTooltip(examine, alphaModifier);
            }
            return;
        }
        boolean isInterfaceExamine = type == ExamineType.ITEM_INTERFACE;
        int x = bounds.x;
        int y = bounds.height + bounds.y;
        if (!isInterfaceExamine) {
            x -= 10;
            y += 10;
        }
        LayoutableRenderableEntity tooltipComponent = this.getRenderableEntity(examine, alphaModifier);
        if ((isInterfaceExamine || this.config.clampRS3()) && (dim = this.dimMap.get(examine)) != null) {
            int yMax;
            int yMin;
            int xMax;
            int xMin;
            if (isInterfaceExamine) {
                xMin = 0;
                xMax = this.client.getCanvasWidth();
                yMin = 0;
                yMax = this.client.getCanvasHeight();
            } else {
                xMin = this.client.getViewportXOffset();
                xMax = this.client.getViewportWidth() + xMin;
                yMin = this.client.getViewportYOffset();
                yMax = this.client.getViewportHeight() + yMin;
            }
            xMax -= 5;
            yMin += 5;
            yMax -= 5;
            if (x < (xMin += 5)) {
                x = xMin;
            } else if (x + dim.width > xMax) {
                x = xMax - dim.width;
            }
            if (y < yMin) {
                y = yMin;
            } else if (y + dim.height > yMax) {
                y = yMax - dim.height;
            }
        }
        tooltipComponent.setPreferredLocation(new Point(x, y));
        this.dimMap.put(examine, tooltipComponent.render(graphics));
        this.rectMap.put(examine, bounds);
    }

    private String getWrappedText(String text) {
        if (this.config.wrapTooltip()) {
            return WordUtils.wrap((String)text, (int)this.config.wrapTooltipColumns(), (String)"</br>", (boolean)false);
        }
        return text;
    }

    private Rectangle findWidgetBounds(int widgetId, int actionParam) {
        Widget widget = this.client.getWidget(WidgetInfo.TO_GROUP((int)widgetId), WidgetInfo.TO_CHILD((int)widgetId));
        if (widget == null) {
            return null;
        }
        if (actionParam < 0) {
            return widget.getBounds();
        }
        try {
            Widget widgetItem = widget.getChild(actionParam);
            if (widgetItem != null) {
                return widgetItem.getBounds();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Shape getObjectShapeFromTile(Tile tile, ExamineType type, int id) {
        if (type == ExamineType.ITEM_GROUND) {
            ItemLayer itemLayer = tile.getItemLayer();
            if (itemLayer != null) {
                Renderable current = itemLayer.getTop();
                while (current instanceof TileItem) {
                    if (((TileItem)current).getId() == id) {
                        return itemLayer.getCanvasTilePoly();
                    }
                    current = current.getNext();
                }
            }
        } else {
            Shape shape;
            Shape shape2;
            for (GameObject object : tile.getGameObjects()) {
                Shape shape3;
                if (!this.objectIdEquals((TileObject)object, id) || (shape3 = object.getConvexHull()) == null) continue;
                return shape3;
            }
            GroundObject gObj = tile.getGroundObject();
            if (this.objectIdEquals((TileObject)gObj, id) && (shape2 = gObj.getConvexHull()) != null) {
                return shape2;
            }
            DecorativeObject dObj = tile.getDecorativeObject();
            if (this.objectIdEquals((TileObject)dObj, id) && (shape = dObj.getConvexHull()) != null) {
                return shape;
            }
            WallObject wObj = tile.getWallObject();
            if (this.objectIdEquals((TileObject)wObj, id)) {
                return wObj.getConvexHull();
            }
        }
        return null;
    }

    private boolean objectIdEquals(TileObject tileObject, int id) {
        if (tileObject == null) {
            return false;
        }
        if (tileObject.getId() == id) {
            return true;
        }
        ObjectComposition comp = this.client.getObjectDefinition(tileObject.getId());
        if (comp.getImpostorIds() != null) {
            return Arrays.stream(comp.getImpostorIds()).anyMatch(imp -> imp == id);
        }
        return false;
    }
}

