/*
 * Decompiled with CFR 0.152.
 */
package com.examinetooltip;

import com.examinetooltip.TooltipOverlayLayer;
import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="examinetooltip")
public interface ExamineTooltipConfig
extends Config {
    public static final String CONFIG_GROUP = "examinetooltip";
    public static final String ITEM_EXAMINES_KEY_NAME = "showItemExamines";
    public static final String OVERLAY_LAYER_KEY_NAME = "overlayLayer";
    @ConfigSection(name="RS3 examine settings", description="Settings relating to using RS3 style examine boxes", position=0)
    public static final String rs3ExamineSettings = "rs3ExamineSettings";
    @ConfigSection(name="Examine types settings", description="Settings to select which examine types to process", position=1)
    public static final String examineTypesSettings = "examineTypesSettings";
    @ConfigSection(name="Examine box display settings", description="Settings relating to how the examine box is displayed visually", position=2)
    public static final String displaySettings = "boxDisplaySettings";
    @ConfigSection(name="Plugin hub compatibility", description="Settings to enable compatibility with other plugin hub plugins", position=3, closedByDefault=true)
    public static final String pluginHubCompatibility = "pluginHubCompatibility";

    @ConfigItem(keyName="rs3Style", name="RS3 style examine box", description="Show examines as a hovering box under the examined items, else show as a cursor tooltip", position=10, section="rs3ExamineSettings")
    default public boolean rs3Style() {
        return true;
    }

    @ConfigItem(keyName="clampRS3", name="Clamp RS3 examine boxes", description="Prevent the RS3 examine boxes from going offscreen", position=11, section="rs3ExamineSettings")
    default public boolean clampRS3() {
        return true;
    }

    @ConfigItem(keyName="previousBoundsFallback", name="Enable screen location fallback", description="Show examines in the last known screen location when the examined object cannot be found", position=12, section="rs3ExamineSettings")
    default public boolean previousBoundsFallback() {
        return true;
    }

    @ConfigItem(keyName="tooltipFallback", name="Enable tooltip fallback", description="Show examines as tooltips when the examined object cannot be found", position=13, section="rs3ExamineSettings")
    default public boolean tooltipFallback() {
        return true;
    }

    @ConfigItem(keyName="overlayLayer", name="Overlay Layer", description="Select on what level the tooltips are shown. Choose 'Above Widgets' to have the tooltips appear below the right-click menu, but might have unintended interaction with other interfaces in the game.", position=14, section="rs3ExamineSettings")
    default public TooltipOverlayLayer overlayLayer() {
        return TooltipOverlayLayer.ALWAYS_ON_TOP;
    }

    @ConfigItem(keyName="showPriceCheck", name="Show price check", description="Show the price check text from the Examine Plugin (\"Price of ...\"), always shown as cursor tooltip", position=20, section="examineTypesSettings")
    default public boolean showPriceCheck() {
        return false;
    }

    @ConfigItem(keyName="showItemExamines", name="Show interface item examines", description="Show text from examining items in interfaces (e.g. inventory, bank, etc.)", position=21, section="examineTypesSettings")
    default public boolean showItemExamines() {
        return true;
    }

    @ConfigItem(keyName="showGroundItemExamines", name="Show ground item examines", description="Show text from examining items on the ground", position=22, section="examineTypesSettings")
    default public boolean showGroundItemExamines() {
        return true;
    }

    @ConfigItem(keyName="showObjectExamines", name="Show object examines", description="Show text from examining objects (e.g. scenery)", position=23, section="examineTypesSettings")
    default public boolean showObjectExamines() {
        return true;
    }

    @ConfigItem(keyName="showNPCExamines", name="Show NPC examines", description="Show text from examining NPCs", position=24, section="examineTypesSettings")
    default public boolean showNPCExamines() {
        return true;
    }

    @ConfigItem(keyName="showPatchInspects", name="Show farming patch inspects", description="Show text from inspecting farming patches", position=25, section="examineTypesSettings")
    default public boolean showPatchInspects() {
        return true;
    }

    @ConfigItem(keyName="tooltipTimeout", name="Tooltip timeout", description="How long to show the examine tooltip", position=30, section="boxDisplaySettings")
    @Units(value="s")
    @Range(min=1, max=10)
    default public int tooltipTimeout() {
        return 4;
    }

    @ConfigItem(keyName="tooltipFadeout", name="Tooltip fadeout", description="Start fading out the tooltip X milliseconds before it disappears, 0 means no fadeout", position=31, section="boxDisplaySettings")
    @Units(value="ms")
    @Range(min=0, max=3000)
    default public int tooltipFadeout() {
        return 1000;
    }

    @ConfigItem(keyName="patchInspectExtraTime", name="Patch extra time", description="Add extra time to show the tooltip when inspecting farming patches (the text is typically quite long)", position=32, section="boxDisplaySettings")
    @Units(value="s")
    @Range(max=10)
    default public int patchInspectExtraTime() {
        return 2;
    }

    @ConfigItem(keyName="wrapTooltip", name="Wrap tooltip", description="Wrap the text in the tooltip if it gets too long", position=33, section="boxDisplaySettings")
    default public boolean wrapTooltip() {
        return true;
    }

    @ConfigItem(keyName="wrapTooltipColumns", name="Wrap columns", description="How many text columns (or characters) before wrapping the text", position=34, section="boxDisplaySettings")
    @Range(min=20)
    default public int wrapTooltipColumns() {
        return 30;
    }

    @Alpha
    @ConfigItem(keyName="customBackgroundColor", name="Custom background color", description="Use a custom background color instead of the globally configured overlay background default", position=35, section="boxDisplaySettings")
    public Color customBackgroundColor();

    @ConfigItem(keyName="showPluginHubPatchPayment", name="PolishToaster's Patch Payment", description="Show text from PolishToaster's Patch Payment plugin, always shown as cursor tooltip", position=50, section="pluginHubCompatibility")
    default public boolean showPluginHubPatchPayment() {
        return true;
    }
}

