/*
 * Decompiled with CFR 0.152.
 */
package com.idyl.snailman.pathfinder;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.idyl.snailman.Util;
import com.idyl.snailman.pathfinder.FlagMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.zip.GZIPInputStream;

public abstract class SplitFlagMap {
    private static final int MAXIMUM_SIZE = 0x1400000;
    private final int regionSize;
    private final LoadingCache<Position, FlagMap> regionMaps;
    private final int flagCount;

    public SplitFlagMap(int regionSize, Map<Position, byte[]> compressedRegions, int flagCount) {
        this.regionSize = regionSize;
        this.flagCount = flagCount;
        this.regionMaps = CacheBuilder.newBuilder().weigher((k, v) -> v.flags.size() / 8).maximumWeight(0x1400000L).build(CacheLoader.from(position -> {
            FlagMap flagMap;
            byte[] compressedRegion = (byte[])compressedRegions.get(position);
            if (compressedRegion == null) {
                return new FlagMap(position.x * regionSize, position.y * regionSize, (position.x + 1) * regionSize - 1, (position.y + 1) * regionSize - 1, this.flagCount);
            }
            GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(compressedRegion));
            try {
                flagMap = new FlagMap(Util.readAllBytes(in), this.flagCount);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ((InputStream)in).close();
            return flagMap;
        }));
    }

    public boolean get(int x, int y, int z, int flag) {
        try {
            return ((FlagMap)this.regionMaps.get((Object)new Position(x / this.regionSize, y / this.regionSize))).get(x, y, z, flag);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException((Throwable)e);
        }
    }

    public static class Position {
        public final int x;
        public final int y;

        public Position(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o) {
            return o instanceof Position && ((Position)o).x == this.x && ((Position)o).y == this.y;
        }

        public int hashCode() {
            return this.x * 31 + this.y;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }
}

