/*
 * Decompiled with CFR 0.152.
 */
package com.idyl.snailman.pathfinder;

import com.idyl.snailman.Transport;
import com.idyl.snailman.pathfinder.Node;
import com.idyl.snailman.pathfinder.PathfinderConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.runelite.api.coords.WorldPoint;

public class Pathfinder
implements Runnable {
    private final WorldPoint start;
    private final WorldPoint target;
    private final PathfinderConfig config;
    private final List<Node> boundary = new LinkedList<Node>();
    private final Set<WorldPoint> visited = new HashSet<WorldPoint>();
    public boolean isComplete;
    private List<WorldPoint> path = new ArrayList<WorldPoint>();
    private boolean done = false;

    public Pathfinder(PathfinderConfig config, WorldPoint start, WorldPoint target, List<WorldPoint> existingPath) {
        this.config = config;
        this.start = start;
        this.target = target;
        this.isComplete = false;
        if (existingPath != null) {
            Node prev = null;
            boolean foundStart = false;
            for (int i = 0; i < existingPath.size(); ++i) {
                WorldPoint point = existingPath.get(i);
                if (!point.equals((Object)start) && !foundStart) continue;
                foundStart = true;
                Node n = new Node(existingPath.get(i), prev);
                this.boundary.add(n);
                prev = n;
            }
        }
        new Thread(this).start();
    }

    public static void writeTransportToFile(String transport) {
        try {
            Files.write(Paths.get("src/main/resources/transports.txt", new String[0]), transport.concat("\n").getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private void addNeighbor(Node node, WorldPoint neighbor) {
        if (!this.visited.add(neighbor)) {
            return;
        }
        this.boundary.add(new Node(neighbor, node));
    }

    private void addNeighbors(Node node) {
        for (WorldPoint neighbor : this.config.getMap().getNeighbors(node.position)) {
            this.addNeighbor(node, neighbor);
        }
        for (Transport transport : (List)this.config.getTransports().getOrDefault(node.position, new ArrayList())) {
            this.addNeighbor(node, transport.getDestination());
        }
    }

    @Override
    public void run() {
        this.boundary.add(new Node(this.start, null));
        Node nearest = this.boundary.get(0);
        int bestDistance = Integer.MAX_VALUE;
        Instant cutoffTime = Instant.now().plus(PathfinderConfig.CALCULATION_CUTOFF);
        long startTime = Instant.now().toEpochMilli();
        while (!this.boundary.isEmpty()) {
            Node node = this.boundary.remove(0);
            if (node.position.equals((Object)this.target)) {
                this.path = node.getPath();
                System.out.println("Found best path.");
                this.isComplete = true;
                break;
            }
            int distance = node.position.distanceTo(this.target);
            if (distance < bestDistance) {
                this.path = node.getPath();
                nearest = node;
                bestDistance = distance;
                cutoffTime = Instant.now().plus(PathfinderConfig.CALCULATION_CUTOFF);
            }
            if (Instant.now().isAfter(cutoffTime)) {
                this.path = nearest.getPath();
                long elapsed = Instant.now().toEpochMilli() - startTime;
                break;
            }
            this.addNeighbors(node);
        }
        long elapsed = Instant.now().toEpochMilli() - startTime;
        System.out.println("Finished calculation in " + elapsed + "ms");
        this.done = true;
        this.boundary.clear();
        this.visited.clear();
    }

    public WorldPoint getStart() {
        return this.start;
    }

    public WorldPoint getTarget() {
        return this.target;
    }

    public List<WorldPoint> getPath() {
        return this.path;
    }

    public boolean isDone() {
        return this.done;
    }
}

