/*
 * Decompiled with CFR 0.152.
 */
package com.idyl.snailman;

import com.google.inject.Provides;
import com.idyl.snailman.SnailManModeConfig;
import com.idyl.snailman.SnailManModeMapOverlay;
import com.idyl.snailman.SnailManModeOverlay;
import com.idyl.snailman.SnailManModePanel;
import com.idyl.snailman.TeleportTimer;
import com.idyl.snailman.Transport;
import com.idyl.snailman.Util;
import com.idyl.snailman.pathfinder.CollisionMap;
import com.idyl.snailman.pathfinder.Pathfinder;
import com.idyl.snailman.pathfinder.PathfinderConfig;
import com.idyl.snailman.pathfinder.SplitFlagMap;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IndexedSprite;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.RenderOverview;
import net.runelite.api.WorldType;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="SnailMan Mode")
public class SnailManModePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SnailManModePlugin.class);
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private SnailManModeOverlay snailManModeOverlay;
    @Inject
    private SnailManModeMapOverlay snailManModeMapOverlay;
    @Inject
    private Client client;
    @Inject
    private SnailManModeConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private WorldService worldService;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    private NavigationButton navButton;
    public Pathfinder pathfinder;
    public PathfinderConfig pathfinderConfig;
    private int currentPathIndex;
    private int snailmanIconOffset = -1;
    private boolean onSeasonalWorld;
    private WorldPoint snailWorldPoint;
    private boolean isLoggedIn;
    private boolean isAlive;
    private boolean isDying;
    private WorldPoint deathPoint;
    private WorldPoint transportStart;
    private MenuEntry lastClick;
    private long lastSaveTime;
    private int tickCount = 0;
    private WorldPoint lastPlayerPoint;
    private static boolean horrorCloseFlag = false;
    private static final int RECALCULATION_THRESHOLD = 20;
    private static final int SNAIL_HORROR_SOUND = 1899;
    private static final int SNAIL_HORROR_DISTANCE = 15;
    private static final String ADD_START = "Add start";
    private static final String ADD_END = "Add end";
    private static final String WALK_HERE = "Walk here";
    private static final String TRANSPORT = ColorUtil.wrapWithColorTag((String)"Transport", (Color)JagexColors.MENU_TARGET);
    private static final String CONFIG_GROUP = "snailman";
    private static final String CONFIG_KEY_SNAIL_LOC = "snailWorldPoint";
    private static final String CONFIG_KEY_IS_ALIVE = "isAlive";
    private static final WorldPoint DEFAULT_SNAIL_START = new WorldPoint(1181, 3624, 0);
    public static final boolean DEV_MODE = false;

    @Provides
    SnailManModeConfig provideConfig(ConfigManager configManager) {
        return (SnailManModeConfig)configManager.getConfig(SnailManModeConfig.class);
    }

    protected void startUp() {
        this.loadResources();
        this.isLoggedIn = false;
        this.onSeasonalWorld = false;
        this.isAlive = true;
        this.isDying = false;
        this.lastSaveTime = Instant.EPOCH.getEpochSecond();
        this.overlayManager.add((Overlay)this.snailManModeOverlay);
        this.overlayManager.add((Overlay)this.snailManModeMapOverlay);
        SnailManModePanel panel = (SnailManModePanel)((Object)this.injector.getInstance(SnailManModePanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(SnailManModePlugin.class, (String)"/snail.png");
        this.navButton = NavigationButton.builder().panel((PluginPanel)panel).tooltip("SnailMan Mode").icon(icon).priority(90).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.snailManModeOverlay);
        this.overlayManager.remove((Overlay)this.snailManModeMapOverlay);
        this.clientToolbar.removeNavigation(this.navButton);
        this.infoBoxManager.removeIf(t -> t instanceof TeleportTimer);
    }

    private void addSnailmanIcon(ChatMessage chatMessage) {
        if (!this.isAlive) {
            return;
        }
        String name = chatMessage.getName();
        boolean isLocalPlayer = Text.standardize((String)name).equalsIgnoreCase(Text.standardize((String)this.client.getLocalPlayer().getName()));
        if (!isLocalPlayer) {
            return;
        }
        chatMessage.getMessageNode().setName(SnailManModePlugin.getImgTag(this.snailmanIconOffset) + Text.removeTags((String)name));
    }

    public WorldPoint getSnailWorldPoint() {
        return this.snailWorldPoint;
    }

    private WorldPoint getSavedSnailWorldPoint() {
        if (this.configManager.getRSProfileKey() == null) {
            return null;
        }
        WorldPoint point = (WorldPoint)this.configManager.getRSProfileConfiguration(CONFIG_GROUP, CONFIG_KEY_SNAIL_LOC, WorldPoint.class);
        if (point == null) {
            return DEFAULT_SNAIL_START;
        }
        return point;
    }

    public void setSnailWorldPoint(WorldPoint point) {
        this.snailWorldPoint = point;
    }

    private void saveSnailWorldPoint() {
        if (this.configManager.getRSProfileKey() == null) {
            return;
        }
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP, CONFIG_KEY_SNAIL_LOC, (Object)this.snailWorldPoint);
    }

    private void saveData() {
        if (this.configManager.getRSProfileKey() == null) {
            return;
        }
        this.saveSnailWorldPoint();
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP, CONFIG_KEY_IS_ALIVE, (Object)this.isAlive);
        this.lastSaveTime = Instant.EPOCH.getEpochSecond();
    }

    public void reset() {
        this.setSnailWorldPoint(DEFAULT_SNAIL_START);
        this.pathfinder = null;
        this.isAlive = true;
        this.isDying = false;
        this.deathPoint = null;
        horrorCloseFlag = false;
        this.client.getLocalPlayer().setAnimation(-1);
        this.client.getLocalPlayer().setGraphic(-1);
        this.saveData();
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (!this.client.isKeyPressed(81) || event.getOption().equals(WALK_HERE)) {
            // empty if block
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN && !this.isLoggedIn) {
            WorldPoint point = this.getSavedSnailWorldPoint();
            String savedAlive = this.configManager.getRSProfileConfiguration(CONFIG_GROUP, CONFIG_KEY_IS_ALIVE);
            this.setSnailWorldPoint(point);
            this.currentPathIndex = 1;
            this.isAlive = savedAlive == null || Boolean.parseBoolean(savedAlive);
            this.isLoggedIn = true;
            this.onSeasonalWorld = this.isSeasonalWorld(this.client.getWorld());
        } else if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN && this.isLoggedIn) {
            this.isLoggedIn = false;
            this.saveData();
            this.pathfinder = null;
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        boolean snailShouldMove;
        if (!this.isLoggedIn || this.config.pauseSnail() || this.isSeasonalWorld(this.client.getWorld())) {
            return;
        }
        ++this.tickCount;
        WorldPoint playerPoint = this.client.getLocalPlayer().getWorldLocation();
        long distanceToSnail = playerPoint.distanceTo2D(this.snailWorldPoint);
        boolean bl = snailShouldMove = this.tickCount % this.config.moveSpeed() == 0 || distanceToSnail <= 20L && this.config.speedBoost();
        if (this.lastPlayerPoint == null) {
            this.lastPlayerPoint = playerPoint;
        }
        if (!snailShouldMove) {
            return;
        }
        if (this.pathfinder == null) {
            this.calculatePath(this.snailWorldPoint, playerPoint, false, false);
            return;
        }
        if (this.currentPathIndex < this.pathfinder.getPath().size() && this.pathfinder.isComplete) {
            int index = Math.max(this.pathfinder.getPath().size() - 1 - this.currentPathIndex, 0);
            WorldPoint target = this.pathfinder.getPath().get(index);
            this.setSnailWorldPoint(target);
            ++this.currentPathIndex;
        }
        if (this.config.horrorMode()) {
            this.performHorrorModeChecks(distanceToSnail);
        }
        if (this.checkTouching()) {
            ChatMessageBuilder message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("You have been touched by the snail. You are dead.");
            if (this.isAlive) {
                this.isDying = true;
                this.deathPoint = playerPoint;
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(message.build()).build());
                this.client.playSoundEffect(2498);
                this.client.getLocalPlayer().setAnimation(836);
                this.client.getLocalPlayer().setAnimationFrame(0);
                this.client.getLocalPlayer().setGraphic(180);
                this.isAlive = false;
                this.clientThread.invoke(() -> this.client.runScript(new Object[]{223}));
                this.saveData();
            }
        }
        this.recalculatePath();
        this.lastPlayerPoint = playerPoint;
        if (Instant.EPOCH.getEpochSecond() - this.lastSaveTime >= 60L && this.isLoggedIn) {
            this.saveData();
        }
        if (this.isDying && !this.deathPoint.equals((Object)playerPoint)) {
            this.isDying = false;
            this.client.getLocalPlayer().setAnimation(-1);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (this.client.getGameState() != GameState.LOADING && this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.client.getLocalPlayer().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)chatMessage.getName());
        boolean isSelf = this.client.getLocalPlayer().getName().equalsIgnoreCase(name);
        switch (chatMessage.getType()) {
            case PRIVATECHAT: 
            case MODPRIVATECHAT: 
            case FRIENDSCHAT: 
            case CLAN_CHAT: {
                if (this.onSeasonalWorld || !isSelf) break;
                this.addSnailmanIcon(chatMessage);
                break;
            }
            case PUBLICCHAT: 
            case MODCHAT: {
                if (!isSelf) break;
                this.addSnailmanIcon(chatMessage);
            }
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!event.getEventName().equals("setChatboxInput")) {
            return;
        }
        this.updateChatbox();
    }

    @Subscribe
    public void onBeforeRender(BeforeRender event) {
        this.updateChatbox();
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        if (event.getActor() instanceof Player) {
            Player player = (Player)event.getActor();
            if (this.isDying) {
                this.isDying = false;
                this.client.getLocalPlayer().setAnimation(-1);
                this.client.getLocalPlayer().setGraphic(-1);
            }
        }
    }

    private void addMenuEntry(MenuEntryAdded event, String option) {
        this.client.createMenuEntry(1).setOption(option).setTarget(TRANSPORT).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).onClick(this::onMenuOptionClicked);
    }

    private void onMenuOptionClicked(MenuEntry entry) {
        Player localPlayer = this.client.getLocalPlayer();
        WorldPoint currentLocation = localPlayer.getWorldLocation();
        if (entry.getOption().equals(ADD_START) && entry.getTarget().equals(TRANSPORT)) {
            this.transportStart = currentLocation;
        }
        if (entry.getOption().equals(ADD_END) && entry.getTarget().equals(TRANSPORT)) {
            WorldPoint transportEnd = this.client.getLocalPlayer().getWorldLocation();
            String transportText = this.transportStart.getX() + " " + this.transportStart.getY() + " " + this.transportStart.getPlane() + "\t" + currentLocation.getX() + " " + currentLocation.getY() + " " + currentLocation.getPlane() + "\t" + this.lastClick.getOption() + " " + Text.removeTags((String)this.lastClick.getTarget()) + " " + this.lastClick.getIdentifier();
            Pathfinder.writeTransportToFile(transportText);
            Transport transport = new Transport(this.transportStart, transportEnd);
            this.pathfinderConfig.getTransports().computeIfAbsent(this.transportStart, k -> new ArrayList()).add(transport);
        }
        if (entry.getType() != MenuAction.WALK) {
            this.lastClick = entry;
        }
    }

    private void performHorrorModeChecks(long distanceToSnail) {
        if (this.config.pauseSnail() || !this.isAlive) {
            return;
        }
        if (distanceToSnail < 15L && !horrorCloseFlag) {
            horrorCloseFlag = true;
            ChatMessageBuilder message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("You see something moving in the fog...");
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(message.build()).build());
            TeleportTimer timer = new TeleportTimer(Duration.of(10L, ChronoUnit.SECONDS), (BufferedImage)this.itemManager.getImage(3327), this);
            this.infoBoxManager.addInfoBox((InfoBox)timer);
            this.client.playSoundEffect(1899);
        } else if (distanceToSnail > 30L && horrorCloseFlag) {
            horrorCloseFlag = false;
        }
    }

    private void updateChatbox() {
        if (!this.isAlive) {
            return;
        }
        Widget chatboxTypedText = this.client.getWidget(WidgetInfo.CHATBOX_INPUT);
        if (this.snailmanIconOffset == -1) {
            return;
        }
        if (chatboxTypedText == null || chatboxTypedText.isHidden()) {
            return;
        }
        String[] chatbox = chatboxTypedText.getText().split(":", 2);
        String rsn = Objects.requireNonNull(this.client.getLocalPlayer()).getName();
        chatboxTypedText.setText(SnailManModePlugin.getImgTag(this.snailmanIconOffset) + Text.removeTags((String)rsn) + ":" + chatbox[1]);
    }

    private static String getImgTag(int iconIndex) {
        return "<img=" + iconIndex + ">";
    }

    private boolean isSeasonalWorld(int worldNumber) {
        WorldResult worlds = this.worldService.getWorlds();
        if (worlds == null) {
            return false;
        }
        World world = worlds.findWorld(worldNumber);
        return world != null && world.getTypes().contains(WorldType.SEASONAL);
    }

    private void recalculatePath() {
        boolean forceRecalc;
        if (!this.isLoggedIn) {
            return;
        }
        if (this.client.isInInstancedRegion()) {
            this.pathfinder = null;
            return;
        }
        WorldPoint playerPoint = this.client.getLocalPlayer().getWorldLocation();
        int distanceFromPlayer = this.snailWorldPoint.distanceTo2D(playerPoint);
        boolean bl = forceRecalc = this.lastPlayerPoint.getPlane() != playerPoint.getPlane();
        if (distanceFromPlayer < 20) {
            if (this.pathfinder.getStart().distanceTo2D(playerPoint) > 0) {
                this.calculatePath(this.snailWorldPoint, playerPoint, true, false);
                this.currentPathIndex = 1;
            }
        } else if (this.pathfinder.getStart().distanceTo2D(playerPoint) >= 20 || forceRecalc) {
            boolean useExistingPath = this.lastPlayerPoint.distanceTo(playerPoint) < 100;
            this.calculatePath(this.snailWorldPoint, playerPoint, forceRecalc, useExistingPath);
            this.currentPathIndex = 1;
        }
    }

    private boolean checkTouching() {
        WorldPoint playerPoint = this.client.getLocalPlayer().getWorldLocation();
        int distanceFromPlayer = this.snailWorldPoint.distanceTo2D(playerPoint);
        return distanceFromPlayer <= 0;
    }

    private void calculatePath(WorldPoint start, WorldPoint end, boolean force, boolean useExisting) {
        if (this.pathfinder != null && !this.pathfinder.isDone() && !force) {
            return;
        }
        if (this.client.isInInstancedRegion()) {
            return;
        }
        List<WorldPoint> existingPath = useExisting ? this.pathfinder.getPath() : null;
        this.pathfinder = new Pathfinder(this.pathfinderConfig, end, start, existingPath);
    }

    public Point mapWorldPointToGraphicsPoint(WorldPoint worldPoint) {
        RenderOverview ro = this.client.getRenderOverview();
        float pixelsPerTile = ro.getWorldMapZoom();
        Widget map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (map != null) {
            Rectangle worldMapRect = map.getBounds();
            int widthInTiles = (int)Math.ceil(worldMapRect.getWidth() / (double)pixelsPerTile);
            int heightInTiles = (int)Math.ceil(worldMapRect.getHeight() / (double)pixelsPerTile);
            Point worldMapPosition = ro.getWorldMapPosition();
            int yTileMax = worldMapPosition.getY() - heightInTiles / 2;
            int yTileOffset = (yTileMax - worldPoint.getY() - 1) * -1;
            int xTileOffset = worldPoint.getX() + widthInTiles / 2 - worldMapPosition.getX();
            int xGraphDiff = (int)((float)xTileOffset * pixelsPerTile);
            int yGraphDiff = (int)((float)yTileOffset * pixelsPerTile);
            yGraphDiff = (int)((double)yGraphDiff - ((double)pixelsPerTile - Math.ceil(pixelsPerTile / 2.0f)));
            xGraphDiff = (int)((double)xGraphDiff + ((double)pixelsPerTile - Math.ceil(pixelsPerTile / 2.0f)));
            yGraphDiff = worldMapRect.height - yGraphDiff;
            return new Point(xGraphDiff += (int)worldMapRect.getX(), yGraphDiff += (int)worldMapRect.getY());
        }
        return null;
    }

    private void loadResources() {
        HashMap<SplitFlagMap.Position, byte[]> compressedRegions = new HashMap<SplitFlagMap.Position, byte[]>();
        HashMap<WorldPoint, List<Transport>> transports = new HashMap<WorldPoint, List<Transport>>();
        try (ZipInputStream in = new ZipInputStream(SnailManModePlugin.class.getResourceAsStream("/collision-map.zip"));){
            ZipEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                String[] n = entry.getName().split("_");
                compressedRegions.put(new SplitFlagMap.Position(Integer.parseInt(n[0]), Integer.parseInt(n[1])), Util.readAllBytes(in));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            String s = new String(Util.readAllBytes(SnailManModePlugin.class.getResourceAsStream("/transports.txt")), StandardCharsets.UTF_8);
            Scanner scanner = new Scanner(s);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.startsWith("#") || line.isEmpty()) continue;
                Transport transport = new Transport(line);
                WorldPoint origin = transport.getOrigin();
                transports.computeIfAbsent(origin, k -> new ArrayList()).add(transport);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.pathfinderConfig = new PathfinderConfig(new CollisionMap(64, compressedRegions), transports, this.client);
        IndexedSprite[] modIcons = this.client.getModIcons();
        if (this.snailmanIconOffset != -1 || modIcons == null) {
            return;
        }
        BufferedImage image = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/helm.png");
        IndexedSprite indexedSprite = ImageUtil.getImageIndexedSprite((BufferedImage)image, (Client)this.client);
        this.snailmanIconOffset = modIcons.length;
        IndexedSprite[] newModIcons = Arrays.copyOf(modIcons, modIcons.length + 1);
        newModIcons[newModIcons.length - 1] = indexedSprite;
        this.client.setModIcons(newModIcons);
    }
}

