/*
 * Decompiled with CFR 0.152.
 */
package com.idyl.snailman;

import com.idyl.snailman.SnailManModeConfig;
import com.idyl.snailman.SnailManModePlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnailManModeOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(SnailManModeOverlay.class);
    private static final int MAX_DRAW_DISTANCE = 32;
    private final Client client;
    private final SnailManModeConfig config;
    private final SnailManModePlugin plugin;
    BufferedImage snailShell = null;

    @Inject
    private SnailManModeOverlay(Client client, SnailManModeConfig config, SnailManModePlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    private java.awt.Point tileCenter(WorldPoint b) {
        if (b.getPlane() != this.client.getPlane()) {
            return null;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)b);
        if (lp == null) {
            return null;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly == null) {
            return null;
        }
        int cx = poly.getBounds().x + poly.getBounds().width / 2;
        int cy = poly.getBounds().y + poly.getBounds().height / 2;
        return new java.awt.Point(cx, cy);
    }

    public Dimension render(Graphics2D graphics) {
        WorldPoint snailPoint = this.plugin.getSnailWorldPoint();
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        long drawDistance = this.config.drawDistance();
        if ((long)snailPoint.distanceTo(playerLocation) >= drawDistance) {
            return null;
        }
        this.drawTile(graphics, snailPoint, this.config.color(), new BasicStroke(2.0f));
        this.drawImg(graphics, snailPoint);
        return null;
    }

    private void drawTile(Graphics2D graphics, WorldPoint point, Color color, Stroke borderStroke) {
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color, (Color)new Color(0, 0, 0, 1), (Stroke)borderStroke);
        }
    }

    private void drawImg(Graphics2D graphics, WorldPoint point) {
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        if (lp == null) {
            return;
        }
        BufferedImage snailShell = this.getSnailImage();
        Point canvasImageLocation = Perspective.getCanvasImageLocation((Client)this.client, (LocalPoint)lp, (BufferedImage)snailShell, (int)75);
        if (canvasImageLocation == null) {
            return;
        }
        OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)canvasImageLocation, (BufferedImage)snailShell);
    }

    private void drawTransport(Graphics2D graphics, WorldPoint point) {
        if (point.getPlane() != this.client.getPlane()) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly == null) {
            return;
        }
        graphics.setColor(Color.GREEN);
        graphics.fill(poly);
    }

    private BufferedImage getSnailImage() {
        if (this.snailShell == null) {
            this.snailShell = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/snail_shell.png");
        }
        return this.snailShell;
    }
}

