/*
 * Decompiled with CFR 0.152.
 */
package com.idyl.snailman;

import com.idyl.snailman.SnailManModeConfig;
import com.idyl.snailman.SnailManModePlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.util.ImageUtil;

public class SnailManModeMapOverlay
extends Overlay {
    private final Client client;
    private final SnailManModePlugin plugin;
    private final SnailManModeConfig config;
    private Area mapClipArea;
    private BufferedImage mapIcon;

    @Inject
    private SnailManModeMapOverlay(Client client, SnailManModePlugin plugin, SnailManModeConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.MANUAL);
        this.drawAfterLayer(WidgetInfo.WORLD_MAP_VIEW);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showOnMap()) {
            return null;
        }
        if (this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW) == null) {
            return null;
        }
        this.mapClipArea = this.getWorldMapClipArea(this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW).getBounds());
        graphics.setClip(this.mapClipArea);
        BufferedImage marker = this.getMapIconImage();
        Point point = this.plugin.mapWorldPointToGraphicsPoint(this.plugin.getSnailWorldPoint());
        graphics.drawImage((Image)marker, point.getX() - marker.getWidth() / 2, point.getY() - marker.getHeight() / 2, null);
        return null;
    }

    private BufferedImage getMapIconImage() {
        if (this.mapIcon == null) {
            this.mapIcon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/marker.png");
        }
        return this.mapIcon;
    }

    private Area getWorldMapClipArea(Rectangle baseRectangle) {
        Widget overview = this.client.getWidget(WidgetInfo.WORLD_MAP_OVERVIEW_MAP);
        Widget surfaceSelector = this.client.getWidget(WidgetInfo.WORLD_MAP_SURFACE_SELECTOR);
        Area clipArea = new Area(baseRectangle);
        if (overview != null && !overview.isHidden()) {
            clipArea.subtract(new Area(overview.getBounds()));
        }
        if (surfaceSelector != null && !surfaceSelector.isHidden()) {
            clipArea.subtract(new Area(surfaceSelector.getBounds()));
        }
        return clipArea;
    }
}

