/*
 * Decompiled with CFR 0.152.
 */
package com.starinfo;

import com.starinfo.EstimateConfig;
import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="starinfoplugin")
public interface StarInfoConfig
extends Config {
    public static final String TEXT_COLOR_KEY = "textColor";
    public static final String THICK_OUTLINE = "thickOutline";
    public static final String INFO_BOX_KEY = "infoBox";
    public static final String HINT_ARROW_KEY = "hintArrow";
    public static final String SHOW_PERCENT = "showPercent";
    public static final String SHOW_DUST = "showDust";
    public static final String SHOW_MINERS = "showMiners";
    public static final String COLOR_STAR = "colorStar";
    public static final String CLIPBOARD = "copyToClipboard";
    public static final String T0_IN_COPY = "t0inCopy";
    public static final String ADD_TO_CHAT = "addToChat";
    public static final String REMOVE_DISTANCE = "removeDistance";
    public static final String ESTIMATE_LAYER = "estimateLayerTime";
    public static final String ESTIMATE_DEPLETION_TIME = "estimateFullTime";
    @ConfigSection(name="Text Overlay", description="Settings for the text overlaid on stars", position=0)
    public static final String textOverlaySection = "textOverlaySection";
    @ConfigSection(name="Health Bar", description="Settings for the health bar on stars", position=19, closedByDefault=true)
    public static final String healthBarSection = "healthBarSection";

    @Alpha
    @ConfigItem(position=1, keyName="textColor", name="Text color", section="textOverlaySection", description="Sets the color of the text above a star.")
    default public Color getTextColor() {
        return Color.GREEN;
    }

    @ConfigItem(position=2, keyName="thickOutline", name="Thick Text Outline", section="textOverlaySection", description="Use thick text outline on star info overlay")
    default public boolean thickOutline() {
        return true;
    }

    @ConfigItem(position=3, keyName="showMiners", name="Show Miners", section="textOverlaySection", description="Display number of active star miners, e.g. 5M = 5 Miners")
    default public boolean showMiners() {
        return true;
    }

    @ConfigItem(position=4, keyName="showPercent", name="Show Layer %", section="textOverlaySection", description="Display the health percentage of the current layer")
    default public boolean showPercent() {
        return true;
    }

    @ConfigItem(position=6, keyName="estimateLayerTime", name="Estimate Layer Time", section="textOverlaySection", description="Display estimated time till the current layer finishes")
    default public EstimateConfig estimateLayerTime() {
        return EstimateConfig.NONE;
    }

    @ConfigItem(position=8, keyName="estimateFullTime", name="Estimate Depletion Time", section="textOverlaySection", description="Display estimated time till the star depletes")
    default public EstimateConfig estimateDeathTime() {
        return EstimateConfig.NONE;
    }

    @ConfigItem(position=9, keyName="xpPerHour", name="Layer Xp/Hr", section="textOverlaySection", description="Display Xp/Hr for current layer")
    default public boolean xpPerHour() {
        return false;
    }

    @ConfigItem(position=10, keyName="dustPerHour", name="Dust/Hr", section="textOverlaySection", description="Display how much Dust per Hour you mine for current layer")
    default public boolean dustPerHour() {
        return false;
    }

    @ConfigItem(position=12, keyName="compactText", name="Compact text", section="textOverlaySection", description="Use abbreviations and less text")
    default public boolean compact() {
        return false;
    }

    @ConfigItem(position=13, keyName="infoBox", name="Show Info Box", description="Whether to display star status info box")
    default public boolean showInfoBox() {
        return true;
    }

    @ConfigItem(position=14, keyName="hintArrow", name="Show Hint Arrow", description="Whether to display hint arrow pointing to star")
    default public boolean showHintArrow() {
        return true;
    }

    @ConfigItem(position=15, keyName="colorStar", name="Highlight Star", description="Highlights stars green if you can mine it, and red if you can't")
    default public boolean colorStar() {
        return true;
    }

    @ConfigItem(position=16, keyName="copyToClipboard", name="Copy to Clipboard Option", description="Allows you to right click stars and copy their information")
    default public boolean copyToClipboard() {
        return true;
    }

    @ConfigItem(position=17, keyName="t0inCopy", name="T0 Clipboard estimate", description="Adds time estimate till star is dead to copy option message")
    default public boolean addT0Estimate() {
        return false;
    }

    @ConfigItem(position=18, keyName="addToChat", name="Add Stars to Chat", description="Adds a message to the game chat when stars are found with their tier/world/location")
    default public boolean addToChat() {
        return true;
    }

    @ConfigItem(position=20, keyName="hideHealthBar", name="Hide health bar", section="healthBarSection", description="Hides the health bar of the star")
    default public boolean hideHealthBar() {
        return false;
    }

    @Range(min=1, max=40)
    @ConfigItem(position=21, keyName="healthBarHeight", name="Health bar height", section="healthBarSection", description="The height of the health bar (5 default)")
    default public int healthBarHeight() {
        return 5;
    }

    @Range(min=10, max=400)
    @ConfigItem(position=22, keyName="healthBarWidth", name="Health bar width", section="healthBarSection", description="The width of the health bar (50 default)")
    default public int healthBarWidth() {
        return 50;
    }

    @Alpha
    @ConfigItem(position=23, keyName="hpColorFore", name="Hp left color", section="healthBarSection", description="Sets the hp bar's hp left color")
    default public Color getHpColorFore() {
        return new Color(0, 169, 255, 180);
    }

    @Alpha
    @ConfigItem(position=24, keyName="hpColorBack", name="Hp background color", section="healthBarSection", description="Sets the hp bar's background color")
    default public Color getHpColorBack() {
        return new Color(0, 22, 33, 180);
    }

    @Range(min=32, max=90)
    @ConfigItem(position=25, keyName="removeDistance", name="Remove distance", description="The tile distance above which star info is removed")
    default public int removeDistance() {
        return 32;
    }
}

