/*
 * Decompiled with CFR 0.152.
 */
package com.starinfo;

import com.starinfo.Location;
import net.runelite.api.GameObject;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;

public class Star {
    public static final String UNKNOWN_MINERS = "?";
    private static final int[] TIER_IDS = new int[]{41229, 41228, 41227, 41226, 41225, 41224, 41223, 41021, 41020};
    private final WorldPoint worldPoint;
    private final int world;
    private NPC npc;
    private GameObject object;
    private String miners = "?";
    private final Location location;
    private int health = -1;
    private int[] tierTicksEstimate;
    private String worldInfo = "";

    public Star(NPC npc, int world) {
        this.npc = npc;
        this.worldPoint = npc.getWorldLocation();
        this.location = Location.forLocation(this.worldPoint);
        this.world = world;
    }

    public Star(GameObject gameObject, int world) {
        this.object = gameObject;
        this.worldPoint = gameObject.getWorldLocation();
        this.location = Location.forLocation(this.worldPoint);
        this.world = world;
    }

    public int getTier() {
        if (this.object == null) {
            return -1;
        }
        return Star.getTier(this.object.getId());
    }

    public static int getTier(int id) {
        for (int i = 0; i < TIER_IDS.length; ++i) {
            if (id != TIER_IDS[i]) continue;
            return i + 1;
        }
        return -1;
    }

    public int getHealth() {
        if (this.npc == null) {
            return this.health;
        }
        if (this.npc.getHealthRatio() >= 0) {
            this.health = 100 * this.npc.getHealthRatio() / this.npc.getHealthScale();
        } else if (this.npc.isDead()) {
            this.health = -1;
        }
        return this.health;
    }

    public String getMessage() {
        return "Star Found: W" + this.world + " T" + this.getTier() + " " + this.location.getDescription() + this.worldInfo;
    }

    public void resetHealth() {
        this.health = 100;
    }

    public WorldPoint getWorldPoint() {
        return this.worldPoint;
    }

    public int getWorld() {
        return this.world;
    }

    public NPC getNpc() {
        return this.npc;
    }

    public void setNpc(NPC npc) {
        this.npc = npc;
    }

    public GameObject getObject() {
        return this.object;
    }

    public void setObject(GameObject object) {
        this.object = object;
    }

    public void setMiners(String miners) {
        this.miners = miners;
    }

    public String getMiners() {
        return this.miners;
    }

    public Location getLocation() {
        return this.location;
    }

    public int[] getTierTicksEstimate() {
        return this.tierTicksEstimate;
    }

    public void setTierTicksEstimate(int[] tierTicksEstimate) {
        this.tierTicksEstimate = tierTicksEstimate;
    }

    public String getWorldInfo() {
        return this.worldInfo;
    }

    public void setWorldInfo(String worldInfo) {
        this.worldInfo = worldInfo;
    }
}

