/*
 * Decompiled with CFR 0.152.
 */
package info.sigterm.plugins.itemfiller;

import com.google.inject.Provides;
import info.sigterm.plugins.itemfiller.ItemFillerConfig;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Item Filler")
public class ItemFillerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ItemFillerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemFillerConfig config;
    private Widget invUpdateWidget;

    protected void startUp() {
        this.clientThread.invoke(this::redrawInventory);
    }

    protected void shutDown() {
        this.clientThread.invoke(this::redrawInventory);
    }

    @Provides
    ItemFillerConfig provideConfig(ConfigManager configManager) {
        return (ItemFillerConfig)configManager.getConfig(ItemFillerConfig.class);
    }

    private void redrawInventory() {
        this.client.runScript(this.client.getWidget(WidgetInfo.INVENTORY).getOnInvTransmitListener());
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        if (scriptPreFired.getScriptId() == 153) {
            int w = this.client.getIntStack()[this.client.getIntStackSize() - 6];
            this.invUpdateWidget = this.client.getWidget(w);
        } else if (scriptPreFired.getScriptId() == 975) {
            int w = this.client.getIntStack()[this.client.getIntStackSize() - 5];
            this.invUpdateWidget = this.client.getWidget(w);
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        int id = scriptPostFired.getScriptId();
        if (id == 6010) {
            Widget w = this.client.getWidget(WidgetInfo.INVENTORY);
            this.replaceItems(w);
            this.replaceItems(this.client.getWidget(268, 0));
        } else if (id == 146) {
            this.replaceItems(this.client.getWidget(WidgetInfo.DEPOSIT_BOX_INVENTORY_ITEMS_CONTAINER));
        } else if (id == 277) {
            this.replaceItems(this.client.getWidget(WidgetInfo.BANK_TAB_CONTAINER));
            this.replaceItems(this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER));
        } else if (id == 296) {
            this.replaceItems(this.client.getWidget(WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER));
        } else if (id == 783) {
            this.replaceItems(this.client.getWidget(WidgetInfo.GRAND_EXCHANGE_INVENTORY_ITEMS_CONTAINER));
        } else if (id == 787) {
            this.replaceItems(this.client.getWidget(WidgetInfo.GUIDE_PRICES_ITEMS_CONTAINER));
        } else if (id == 827) {
            this.replaceItems(this.client.getWidget(430, 0));
        } else if (id == 3327) {
            this.replaceItems(this.client.getWidget(15, 4));
        } else if ((id == 153 || id == 975) && this.invUpdateWidget != null) {
            this.replaceItems(this.invUpdateWidget);
            this.invUpdateWidget = null;
        }
    }

    private void replaceItems(Widget w) {
        if (w == null) {
            return;
        }
        int filler = this.config.filler();
        for (Widget i : w.getDynamicChildren()) {
            if (i.getItemId() != filler) continue;
            log.debug("Replacing {} with an item filler", (Object)i.getName());
            i.setName("Filler");
            i.setTargetVerb(null);
            i.setItemId(20594);
            i.setClickMask(0);
            i.setOnDragCompleteListener(null);
            i.setOnDragListener(null);
            Arrays.fill(i.getActions(), "");
        }
    }
}

