/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.world;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.world.WorldStorage;
import dev.thource.runelite.dudewheresmystuff.world.WorldStorageType;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.ChatMessageType;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.widgets.Widget;
import org.apache.commons.lang3.math.NumberUtils;

public class LogStorage
extends WorldStorage {
    private final Pattern checkPattern = Pattern.compile("This crate currently contains (\\d+) logs, (\\d+) oak logs, (\\d+) willow logs, (\\d+) yew logs and (\\d+) magic logs.");
    private final Pattern depositPattern = Pattern.compile("You put the (.*) in the crate. You now have (\\d+) stored.");
    private final Pattern chatPattern = Pattern.compile("You have (\\d+) sets of (.*) left in storage.");

    protected LogStorage(DudeWheresMyStuffPlugin plugin) {
        super(WorldStorageType.LOG_STORAGE, plugin);
        this.hasStaticItems = true;
        ItemStack logs = new ItemStack(1511, plugin);
        ItemStack oakLogs = new ItemStack(1521, plugin);
        ItemStack willowLogs = new ItemStack(1519, plugin);
        ItemStack yewLogs = new ItemStack(1515, plugin);
        ItemStack magicLogs = new ItemStack(1513, plugin);
        this.items.add(logs);
        this.items.add(oakLogs);
        this.items.add(willowLogs);
        this.items.add(yewLogs);
        this.items.add(magicLogs);
        plugin.getClientThread().invokeLater(() -> this.items.forEach(ItemStack::stripPrices));
    }

    @Override
    public boolean onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.SPAM && chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return false;
        }
        Matcher matcher = this.chatPattern.matcher(chatMessage.getMessage());
        if (!matcher.find()) {
            return false;
        }
        Optional<ItemStack> itemStack = this.items.stream().filter(i -> Objects.equals(i.getName(), matcher.group(2))).findFirst();
        if (!itemStack.isPresent()) {
            return false;
        }
        int quantity = NumberUtils.toInt((String)matcher.group(1), (int)0);
        if (itemStack.get().getQuantity() == (long)quantity) {
            return false;
        }
        itemStack.get().setQuantity(quantity);
        this.lastUpdated = System.currentTimeMillis();
        return true;
    }

    @Override
    public boolean onGameTick() {
        return this.checkForCheck() || this.checkForDeposit();
    }

    private boolean checkForCheck() {
        Widget widget = this.plugin.getClient().getWidget(229, 1);
        if (widget == null) {
            return false;
        }
        Matcher matcher = this.checkPattern.matcher(widget.getText().replace("<br>", " "));
        if (!matcher.find()) {
            return false;
        }
        boolean updated = false;
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            int quantity = NumberUtils.toInt((String)matcher.group(i + 1), (int)0);
            if (itemStack.getQuantity() == (long)quantity) continue;
            itemStack.setQuantity(quantity);
            updated = true;
        }
        if (updated) {
            this.lastUpdated = System.currentTimeMillis();
        }
        return updated;
    }

    private boolean checkForDeposit() {
        Widget widget = this.plugin.getClient().getWidget(193, 2);
        if (widget == null) {
            return false;
        }
        Matcher matcher = this.depositPattern.matcher(widget.getText().replace("<br>", " "));
        if (!matcher.find()) {
            return false;
        }
        Optional<ItemStack> itemStack = this.items.stream().filter(i -> Objects.equals(i.getName(), matcher.group(1))).findFirst();
        if (!itemStack.isPresent()) {
            return false;
        }
        int quantity = NumberUtils.toInt((String)matcher.group(2), (int)0);
        if (itemStack.get().getQuantity() == (long)quantity) {
            return false;
        }
        itemStack.get().setQuantity(quantity);
        this.lastUpdated = System.currentTimeMillis();
        return true;
    }

    @Override
    public boolean isWithdrawable() {
        return false;
    }
}

