/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.world;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.SaveFieldFormatter;
import dev.thource.runelite.dudewheresmystuff.SaveFieldLoader;
import dev.thource.runelite.dudewheresmystuff.carryable.BottomlessBucket;
import dev.thource.runelite.dudewheresmystuff.world.WorldStorage;
import dev.thource.runelite.dudewheresmystuff.world.WorldStorageType;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import net.runelite.client.config.ConfigManager;

public class Leprechaun
extends WorldStorage {
    private static final int[] WATERING_CAN_IDS = new int[]{-1, 5331, 5333, 5334, 5335, 5336, 5337, 5338, 5339, 5340, 13353};
    private final ItemStack rakes;
    private final ItemStack seedDibbers;
    private final ItemStack spades;
    private final ItemStack secateurs;
    private final ItemStack wateringCan;
    private final ItemStack trowels;
    private final ItemStack plantCures;
    private final ItemStack bottomlessBucket;
    private final ItemStack buckets;
    private final ItemStack composts;
    private final ItemStack superComposts;
    private final ItemStack ultraComposts;
    private int secateursType;
    private int wateringCanType;
    private int bottomlessBucketType;
    private int bottomlessBucketCharges;
    private BottomlessBucket bottomlessBucketStorage;

    public Leprechaun(DudeWheresMyStuffPlugin plugin) {
        super(WorldStorageType.LEPRECHAUN, plugin);
        this.hasStaticItems = true;
        this.rakes = new ItemStack(5341, plugin);
        this.seedDibbers = new ItemStack(5343, plugin);
        this.spades = new ItemStack(952, plugin);
        this.secateurs = new ItemStack(5329, plugin);
        this.wateringCan = new ItemStack(5331, plugin);
        this.trowels = new ItemStack(5325, plugin);
        this.plantCures = new ItemStack(6036, plugin);
        this.bottomlessBucket = new ItemStack(22994, plugin);
        this.buckets = new ItemStack(1925, plugin);
        this.composts = new ItemStack(6032, plugin);
        this.superComposts = new ItemStack(6034, plugin);
        this.ultraComposts = new ItemStack(21483, plugin);
        this.items.add(this.rakes);
        this.items.add(this.seedDibbers);
        this.items.add(this.spades);
        this.items.add(this.secateurs);
        this.items.add(this.wateringCan);
        this.items.add(this.trowels);
        this.items.add(this.plantCures);
        this.items.add(this.bottomlessBucket);
        this.items.add(this.buckets);
        this.items.add(this.composts);
        this.items.add(this.superComposts);
        this.items.add(this.ultraComposts);
    }

    public static int[] getWateringCanIds() {
        return (int[])WATERING_CAN_IDS.clone();
    }

    @Override
    protected ArrayList<String> getSaveValues() {
        ArrayList<String> saveValues = super.getSaveValues();
        saveValues.add(SaveFieldFormatter.format(this.secateursType));
        saveValues.add(SaveFieldFormatter.format(this.wateringCanType));
        saveValues.add(SaveFieldFormatter.format(this.bottomlessBucketType));
        saveValues.add(SaveFieldFormatter.format(this.bottomlessBucketCharges));
        return saveValues;
    }

    @Override
    protected void loadValues(ArrayList<String> values) {
        super.loadValues(values);
        this.secateursType = SaveFieldLoader.loadInt(values, this.secateursType);
        this.wateringCanType = SaveFieldLoader.loadInt(values, this.wateringCanType);
        this.bottomlessBucketType = SaveFieldLoader.loadInt(values, this.bottomlessBucketType);
        this.bottomlessBucketCharges = SaveFieldLoader.loadInt(values, this.bottomlessBucketCharges);
    }

    @Override
    public boolean onVarbitChanged() {
        boolean updated = this.updateRakes();
        if (this.updateSeedDibbers()) {
            updated = true;
        }
        if (this.updateSpades()) {
            updated = true;
        }
        if (this.updateSecateurs()) {
            updated = true;
        }
        if (this.updateWateringCan()) {
            updated = true;
        }
        if (this.updateTrowels()) {
            updated = true;
        }
        if (this.updatePlantCures()) {
            updated = true;
        }
        if (this.updateBottomlessBucket()) {
            updated = true;
        }
        if (this.updateBuckets()) {
            updated = true;
        }
        if (this.updateComposts()) {
            updated = true;
        }
        if (this.updateSuperComposts()) {
            updated = true;
        }
        if (this.updateUltraComposts()) {
            updated = true;
        }
        return updated;
    }

    private boolean updateBottomlessBucket() {
        int type = this.plugin.getClient().getVarbitValue(7915);
        int charges = this.plugin.getClient().getVarbitValue(7916);
        return this.setBottomlessBucketVars(type, charges);
    }

    private boolean updateRakes() {
        int quantity = this.plugin.getClient().getVarbitValue(1435) + this.plugin.getClient().getVarbitValue(8357) * 2;
        if ((long)quantity == this.rakes.getQuantity()) {
            return false;
        }
        this.rakes.setQuantity(quantity);
        return true;
    }

    private boolean updateSeedDibbers() {
        int quantity = this.plugin.getClient().getVarbitValue(1436) + this.plugin.getClient().getVarbitValue(8358) * 2;
        if ((long)quantity == this.seedDibbers.getQuantity()) {
            return false;
        }
        this.seedDibbers.setQuantity(quantity);
        return true;
    }

    private boolean updateSpades() {
        int quantity = this.plugin.getClient().getVarbitValue(1437) + this.plugin.getClient().getVarbitValue(8361) * 2;
        if ((long)quantity == this.spades.getQuantity()) {
            return false;
        }
        this.spades.setQuantity(quantity);
        return true;
    }

    private boolean updateSecateurs() {
        boolean updated = false;
        int quantity = this.plugin.getClient().getVarbitValue(1438) + this.plugin.getClient().getVarbitValue(8359) * 2;
        if ((long)quantity != this.secateurs.getQuantity()) {
            this.secateurs.setQuantity(quantity);
            updated = true;
        }
        if (this.setSecateursType(this.plugin.getClient().getVarbitValue(1848))) {
            updated = true;
        }
        return updated;
    }

    private boolean updateTrowels() {
        int quantity = this.plugin.getClient().getVarbitValue(1440) + this.plugin.getClient().getVarbitValue(8360) * 2;
        if ((long)quantity == this.trowels.getQuantity()) {
            return false;
        }
        this.trowels.setQuantity(quantity);
        return true;
    }

    private boolean updatePlantCures() {
        int quantity = this.plugin.getClient().getVarbitValue(6268);
        if ((long)quantity == this.plantCures.getQuantity()) {
            return false;
        }
        this.plantCures.setQuantity(quantity);
        return true;
    }

    private boolean updateBuckets() {
        int quantity = this.plugin.getClient().getVarbitValue(1441) + this.plugin.getClient().getVarbitValue(4731) * 32 + this.plugin.getClient().getVarbitValue(6265) * 256;
        if ((long)quantity == this.buckets.getQuantity()) {
            return false;
        }
        this.buckets.setQuantity(quantity);
        return true;
    }

    private boolean updateComposts() {
        int quantity = this.plugin.getClient().getVarbitValue(1442) + this.plugin.getClient().getVarbitValue(6266) * 256;
        if ((long)quantity == this.composts.getQuantity()) {
            return false;
        }
        this.composts.setQuantity(quantity);
        return true;
    }

    private boolean updateSuperComposts() {
        int quantity = this.plugin.getClient().getVarbitValue(1443) + this.plugin.getClient().getVarbitValue(6267) * 256;
        if ((long)quantity == this.superComposts.getQuantity()) {
            return false;
        }
        this.superComposts.setQuantity(quantity);
        return true;
    }

    private boolean updateUltraComposts() {
        int quantity = this.plugin.getClient().getVarbitValue(5732);
        if ((long)quantity == this.ultraComposts.getQuantity()) {
            return false;
        }
        this.ultraComposts.setQuantity(quantity);
        return true;
    }

    private boolean updateWateringCan() {
        int wateringCanState = this.plugin.getClient().getVarbitValue(1439);
        if (wateringCanState >= WATERING_CAN_IDS.length) {
            return false;
        }
        return this.setWateringCanType(wateringCanState);
    }

    private boolean setSecateursType(int secateursType) {
        int secateursId;
        this.secateursType = secateursType;
        int n = secateursId = secateursType == 1 ? 7409 : 5329;
        if (this.secateurs.getId() == secateursId) {
            return false;
        }
        this.secateurs.setId(secateursId, this.plugin);
        return true;
    }

    private boolean setWateringCanType(int wateringCanType) {
        this.wateringCanType = wateringCanType;
        int wateringCanId = WATERING_CAN_IDS[wateringCanType];
        if (wateringCanId == -1) {
            if (this.wateringCan.getQuantity() == 0L) {
                return false;
            }
            this.wateringCan.setQuantity(0L);
            return true;
        }
        if (this.wateringCan.getQuantity() == 1L && this.wateringCan.getId() == wateringCanId) {
            return false;
        }
        this.wateringCan.setId(wateringCanId, this.plugin);
        this.wateringCan.setQuantity(1L);
        return true;
    }

    private boolean setBottomlessBucketVars(int bottomlessBucketType, int bottomlessBucketCharges) {
        int oldBottomlessBucketCharges = this.bottomlessBucketCharges;
        this.bottomlessBucketType = bottomlessBucketType;
        this.bottomlessBucketCharges = bottomlessBucketCharges;
        int itemId = 22994;
        if (bottomlessBucketType == 1) {
            this.bottomlessBucket.setName("Bottomless compost bucket");
        } else if (bottomlessBucketType != 0) {
            itemId = 22997;
        }
        if (oldBottomlessBucketCharges == bottomlessBucketCharges && itemId == this.bottomlessBucket.getId()) {
            return false;
        }
        this.bottomlessBucket.setId(itemId);
        Object name = "Bottomless compost bucket";
        if (bottomlessBucketCharges > 0) {
            name = (String)name + " (" + bottomlessBucketCharges + " ";
            if (bottomlessBucketType == 2) {
                name = (String)name + "compost)";
            } else if (bottomlessBucketType == 3) {
                name = (String)name + "supercompost)";
            } else if (bottomlessBucketType == 4) {
                name = (String)name + "ultracompost)";
            }
        }
        this.bottomlessBucket.setName((String)name);
        this.bottomlessBucket.setQuantity(bottomlessBucketType == 0 ? 0L : 1L);
        if (this.bottomlessBucketStorage != null) {
            this.bottomlessBucketStorage.updateCompost(bottomlessBucketType, bottomlessBucketCharges);
            if (this.bottomlessBucketStorage.getStoragePanel() != null) {
                this.bottomlessBucketStorage.getStoragePanel().refreshItems();
                SwingUtilities.invokeLater(this.bottomlessBucketStorage.getStoragePanel()::update);
            }
        }
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.secateursType = 0;
        this.wateringCanType = 0;
        this.bottomlessBucketType = 0;
    }

    @Override
    public void load(ConfigManager configManager, String managerConfigKey, String profileKey) {
        super.load(configManager, managerConfigKey, profileKey);
        this.setSecateursType(this.secateursType);
        this.setWateringCanType(this.wateringCanType);
        this.setBottomlessBucketVars(this.bottomlessBucketType, this.bottomlessBucketCharges);
    }

    public void setBottomlessBucketStorage(BottomlessBucket bottomlessBucketStorage) {
        this.bottomlessBucketStorage = bottomlessBucketStorage;
    }
}

